/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.users.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import ro.atreides.users.Group;
import ro.atreides.users.GuiPanel;
import ro.atreides.users.Permission;
import ro.atreides.users.PermissionEntry;
import ro.atreides.users.User;
import ro.atreides.users.UserLogEntry;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.db.DatabaseManager;
import ro.atreides.utils.sql.SqlUtils;

public class UsersImpl
implements DaoInterface {
    private PreparedStatement selectAllUsers;
    private PreparedStatement selectUserById;
    private PreparedStatement selectUserByLogin;
    private PreparedStatement updateUser;
    private PreparedStatement addUser;
    private PreparedStatement deleteUser;
    private PreparedStatement selectUsersInGroup;
    private PreparedStatement selectUsersByGroupId;
    private PreparedStatement selectChildrenForPanel;
    private PreparedStatement selectPanelByKey;
    private PreparedStatement selectAllPanels;
    private PreparedStatement selectPermissionsForPanelAndUser;
    private PreparedStatement selectPermissionEntriesForUser;
    private PreparedStatement selectAllPermissions;
    private PreparedStatement selectGroupsForUser;
    private PreparedStatement selectAllGroups;
    private PreparedStatement addUserToGroup;
    private PreparedStatement removeUserFromAllGroups;
    private PreparedStatement selectUserByLoginName;
    private PreparedStatement selectPanelNameById;
    private PreparedStatement selectPermissionsNameById;
    private PreparedStatement removeAllGuiPermissionsFromUser;
    private PreparedStatement addGuiPermissionToUser;
    private PreparedStatement addUserLog;
    private PreparedStatement userLogReport;
    private PreparedStatement getGroupByKey;
    private PreparedStatement getUserLogCount;
    private PreparedStatement deleteAllUserLog;
    private Connection connection;

    public Connection getConnection() {
        return this.connection;
    }

    public UsersImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Vector getInferiorGroupsForGroups(Vector groups, int idLanguage) throws SQLException {
        Vector<Group> result = new Vector<Group>();
        String s = "select messages.label as name, groups.id as id from keys inner join groups on groups.id_key = keys.id inner join messages on messages.id_key = keys.id where id_parent in (";
        Iterator iter = groups.iterator();
        while (iter.hasNext()) {
            Group iUser = (Group)iter.next();
            s = s + iUser.getId();
            if (!iter.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ") and messages.id_lang = " + idLanguage;
        System.out.println("s: " + s);
        ResultSet rs = SqlUtils.executeQuery(s, DatabaseManager.getInstance().getFirstConnection());
        while (rs.next()) {
            Group g = this.getGroupFromResultSet(rs);
            result.add(g);
        }
        rs.close();
        Logger.logInfo(this, result.toString());
        return result;
    }

    public void deleteUserLog() throws SQLException {
        this.deleteAllUserLog.execute();
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.deleteAllUserLog = this.connection.prepareStatement("delete from user_log");
        this.getUserLogCount = this.connection.prepareStatement("select count(id) from user_log");
        this.addUserLog = this.connection.prepareStatement("insert into user_log ( id_user, text ) values ( ?, ? )");
        this.userLogReport = this.connection.prepareStatement("select user_log.*, users.login from user_log inner join users on user_log.id_user = users.id  where dateadd < ? and dateadd >= ? and ( id_user = ? or ? = -1 ) and text like ? order by dateadd");
        this.removeAllGuiPermissionsFromUser = this.connection.prepareStatement("delete from gui_permissions where id_user = ?");
        this.addGuiPermissionToUser = this.connection.prepareStatement("insert into gui_permissions (id_user, id_panel, id_permission) values (?, ?, ?)");
        this.selectUserByLogin = this.connection.prepareStatement("select * from users where login = ? and status = 1");
        this.selectAllUsers = this.connection.prepareStatement("select * from users where status = 1 and (virtual = ? or ? = -1 )");
        this.selectUserById = this.connection.prepareStatement("select * from users where id = ?");
        this.updateUser = this.connection.prepareStatement("update users set password = ?, id_language = ?, login = ?, name = ?, cod_autentificare = ?, cod_unic = ? where id= ?");
        this.addUser = this.connection.prepareStatement("insert into users (name, password, login, id_language, cod_autentificare, cod_unic, status, virtual) values ( ? , ?, ?, ?, ?, ?, 1, ? )");
        this.deleteUser = this.connection.prepareStatement("update users set status = 2 where id = ?");
        String s = "select users.id as id, users.name as name, password, login, cod_autentificare, cod_unic, id_language, is_god, virtual from users inner join users_groups on users.id = users_groups.id_user  inner join groups on users_groups.id_group = groups.id inner join keys on groups.id_key = keys.id";
        this.selectUsersInGroup = this.connection.prepareStatement(s + " where keys.label like ? and users.status = " + 1 + " order by login");
        this.selectUsersByGroupId = this.connection.prepareStatement(s + " where groups.id = ? and users.status = " + 1 + " order by login");
        this.selectChildrenForPanel = this.connection.prepareStatement("select messages.label as name, gui_panels.id as id, classname, id_parent from gui_panels inner join keys on gui_panels.id_key = keys.id inner join messages on messages.id_key = keys.id where id_parent = ? and messages.id_lang = ?");
        this.selectPanelByKey = this.connection.prepareStatement("select messages.label as name, gui_panels.id as id, classname, id_parent from gui_panels inner join keys on gui_panels.id_key = keys.id inner join messages on messages.id_key = keys.id where keys.label = ? and messages.id_lang = ?");
        this.selectAllPanels = this.connection.prepareStatement("select messages.label as name, gui_panels.id as id, classname, id_parent from gui_panels inner join keys on gui_panels.id_key = keys.id inner join messages on messages.id_key = keys.id where messages.id_lang = ?");
        this.selectPermissionsForPanelAndUser = this.connection.prepareStatement("select messages.label as permission from gui_panels inner join gui_permissions on gui_panels.id = gui_permissions.id_panel inner join permissions on gui_permissions.id_permission = permissions.id inner join keys on permissions.id_key = keys.id inner join messages on messages.id_key = keys.id where gui_panels.id = ? and gui_permissions.id_user = ? and messages.id_lang = ?");
        this.selectPermissionEntriesForUser = this.connection.prepareStatement("select gui_permissions.id_panel as panel, gui_permissions.id_permission as permission, gui_panels.classname as classname from users inner join gui_permissions on users.id = gui_permissions.id_user inner join gui_panels on gui_permissions.id_panel = gui_panels.id where users.id = ?");
        this.selectGroupsForUser = this.connection.prepareStatement("select messages.label as name, groups.id as id from keys inner join groups on groups.id_key = keys.id inner join users_groups on groups.id = users_groups.id_group inner join users on users_groups.id_user = users.id inner join messages on messages.id_key = keys.id where users.id = ? and messages.id_lang = ?");
        this.selectAllPermissions = this.connection.prepareStatement("select messages.label as permission, permissions.id as id from permissions inner join keys on permissions.id_key = keys.id inner join messages on messages.id_key = keys.id where messages.id_lang = ?");
        String s1 = "select messages.label as name, groups.id as id from groups inner join keys on groups.id_key = keys.id inner join messages on messages.id_key = keys.id where messages.id_lang = ?";
        this.selectAllGroups = this.connection.prepareStatement(s1);
        this.getGroupByKey = this.connection.prepareStatement(s1 + " and keys.label = ?");
        this.addUserToGroup = this.connection.prepareStatement("insert into users_groups (id_user, id_group) values (?, ?)");
        this.removeUserFromAllGroups = this.connection.prepareStatement("delete from users_groups where id_user = ?");
        this.selectUserByLoginName = this.connection.prepareStatement("select * from users where login = ? and status = 1");
        this.selectPanelNameById = this.connection.prepareStatement("select messages.label as name, gui_panels.id as id from gui_panels inner join keys on gui_panels.id_key = keys.id inner join messages on messages.id_key = keys.id where gui_panels.id = ? and messages.id_lang = ?");
        this.selectPermissionsNameById = this.connection.prepareStatement("select messages.label as name, permissions.id as id from permissions inner join keys on permissions.id_key = keys.id inner join messages on messages.id_key = keys.id where permissions.id = ? and messages.id_lang = ?");
    }

    public void addUser(User user) throws SQLException {
        this.addUser.setString(1, user.getName());
        this.addUser.setString(2, user.getPassword());
        this.addUser.setString(3, user.getLogin());
        this.addUser.setInt(4, user.getLanguage());
        this.addUser.setString(5, user.getCodAutentificare());
        this.addUser.setString(6, user.getCodUnic());
        this.addUser.setInt(7, user.isVirtual() ? 1 : 0);
        this.addUser.execute();
    }

    public User getUserById(int userId) throws SQLException {
        User result = null;
        this.selectUserById.setInt(1, userId);
        ResultSet rs = this.selectUserById.executeQuery();
        if (rs.next()) {
            result = UsersImpl.getUserFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public static User getUserFromResultSet(ResultSet rs) throws SQLException {
        User result = new User(rs.getInt("id"), rs.getString("login"), rs.getString("password"), rs.getString("name"), rs.getInt("id_language"), rs.getString("cod_autentificare"), rs.getString("cod_unic"), rs.getInt("virtual") == 1);
        return result;
    }

    public User getUserByLogin(String userName) throws SQLException {
        User result = null;
        this.selectUserByLogin.setString(1, userName);
        ResultSet rs = this.selectUserByLogin.executeQuery();
        if (rs.next()) {
            result = UsersImpl.getUserFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void updateUser(User user) throws SQLException {
        this.updateUser.setString(1, user.getPassword());
        this.updateUser.setInt(2, user.getLanguage());
        this.updateUser.setString(3, user.getLogin());
        this.updateUser.setString(4, user.getName());
        this.updateUser.setString(5, user.getCodAutentificare());
        this.updateUser.setString(6, user.getCodUnic());
        this.updateUser.setInt(7, user.getId());
        this.updateUser.execute();
    }

    public Vector getAllUsers(int virtual) throws SQLException {
        Vector<User> result = new Vector<User>();
        this.selectAllUsers.setInt(1, virtual);
        this.selectAllUsers.setInt(2, virtual);
        ResultSet rs = this.selectAllUsers.executeQuery();
        while (rs.next()) {
            User u = UsersImpl.getUserFromResultSet(rs);
            result.add(u);
        }
        rs.close();
        return result;
    }

    public int selectIdUserByLoginName(String loginName) throws SQLException {
        int id = -1;
        this.selectUserByLoginName.setString(1, loginName);
        ResultSet rs = this.selectUserByLoginName.executeQuery();
        if (rs.next()) {
            id = rs.getInt("id");
        }
        rs.close();
        return id;
    }

    public void deleteUser(User user) throws SQLException {
        this.deleteUser.setInt(1, user.getId());
        this.deleteUser.execute();
    }

    public Vector getUsersByGroupId(int idGroup) throws SQLException {
        Vector<User> result = new Vector<User>();
        this.selectUsersByGroupId.setInt(1, idGroup);
        ResultSet rs = this.selectUsersByGroupId.executeQuery();
        while (rs.next()) {
            User u = UsersImpl.getUserFromResultSet(rs);
            result.add(u);
        }
        rs.close();
        return result;
    }

    public Vector<User> getUsersInGroup(String groupKey) throws SQLException {
        Vector<User> result = new Vector<User>();
        this.selectUsersInGroup.setString(1, groupKey);
        ResultSet rs = this.selectUsersInGroup.executeQuery();
        while (rs.next()) {
            User u = UsersImpl.getUserFromResultSet(rs);
            result.add(u);
        }
        rs.close();
        return result;
    }

    public Collection getChildrenForPanel(int idPanel, int idUser, int idLanguage) throws SQLException {
        Vector<GuiPanel> result = new Vector<GuiPanel>();
        this.selectChildrenForPanel.setInt(1, idPanel);
        this.selectChildrenForPanel.setInt(2, idLanguage);
        ResultSet rs = this.selectChildrenForPanel.executeQuery();
        while (rs.next()) {
            GuiPanel u = this.getPanelFromResultSet(rs);
            this.selectPermissionsForPanelAndUser.setInt(1, u.getId());
            this.selectPermissionsForPanelAndUser.setInt(2, idUser);
            this.selectPermissionsForPanelAndUser.setInt(3, idLanguage);
            ResultSet rs2 = this.selectPermissionsForPanelAndUser.executeQuery();
            boolean anyPerm = false;
            while (rs2.next()) {
                anyPerm = true;
                String key = rs2.getString("permission");
                if (key.equals("permissions_add")) {
                    u.setAdd(true);
                }
                if (key.equals("permissions_remove")) {
                    u.setRemove(true);
                }
                if (key.equals("permissions_edit")) {
                    u.setEdit(true);
                }
                if (!key.equals("permissions_view")) continue;
                u.setView(true);
            }
            rs2.close();
            if (!anyPerm) continue;
            result.add(u);
        }
        rs.close();
        return result;
    }

    public Collection getPanelsByKey(String key, int idLanguage) throws SQLException {
        Vector<GuiPanel> result = new Vector<GuiPanel>();
        this.selectPanelByKey.setString(1, key);
        this.selectPanelByKey.setInt(2, idLanguage);
        ResultSet rs = this.selectPanelByKey.executeQuery();
        while (rs.next()) {
            GuiPanel gp = this.getPanelFromResultSet(rs);
            result.add(gp);
        }
        rs.close();
        return result;
    }

    public Vector getAllPanels(int idLanguage) throws SQLException {
        Vector<GuiPanel> result = new Vector<GuiPanel>();
        this.selectAllPanels.setInt(1, idLanguage);
        ResultSet rs = this.selectAllPanels.executeQuery();
        while (rs.next()) {
            GuiPanel gp = this.getPanelFromResultSet(rs);
            result.add(gp);
        }
        rs.close();
        return result;
    }

    public Collection getAllPermissions(int idLanguage) throws SQLException {
        Vector<Permission> result = new Vector<Permission>();
        this.selectAllPermissions.setInt(1, idLanguage);
        ResultSet rs = this.selectAllPermissions.executeQuery();
        while (rs.next()) {
            Permission toAdd = new Permission(rs.getInt("id"), rs.getString("permission"));
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private GuiPanel getPanelFromResultSet(ResultSet rs) throws SQLException {
        GuiPanel gp = new GuiPanel(rs.getString("classname"), rs.getInt("id"), rs.getString("name"));
        return gp;
    }

    public Vector getGroupsForUser(int idUser, int idLanguage) throws SQLException {
        Vector<Group> result = new Vector<Group>();
        this.selectGroupsForUser.setInt(1, idUser);
        this.selectGroupsForUser.setInt(2, idLanguage);
        ResultSet rs = this.selectGroupsForUser.executeQuery();
        while (rs.next()) {
            Group toAdd = this.getGroupFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public Group getGroupByKey(int idLanguage, String key) throws SQLException {
        Group result = null;
        this.getGroupByKey.setInt(1, idLanguage);
        this.getGroupByKey.setString(2, key);
        ResultSet rs = this.getGroupByKey.executeQuery();
        if (rs.next()) {
            result = this.getGroupFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Collection getAllGroups(int idLanguage) throws SQLException {
        Vector<Group> result = new Vector<Group>();
        this.selectAllGroups.setInt(1, idLanguage);
        ResultSet rs = this.selectAllGroups.executeQuery();
        while (rs.next()) {
            Group toAdd = this.getGroupFromResultSet(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    private Group getGroupFromResultSet(ResultSet rs) throws SQLException {
        Group toAdd = new Group(rs.getInt("id"), rs.getString("name"));
        return toAdd;
    }

    public void addUserToGroup(int idUser, int idGroup) throws SQLException {
        this.addUserToGroup.setInt(1, idUser);
        this.addUserToGroup.setInt(2, idGroup);
        this.addUserToGroup.execute();
    }

    public void removeUserFromAllGroups(int idUser) throws SQLException {
        this.removeUserFromAllGroups.setInt(1, idUser);
        this.removeUserFromAllGroups.execute();
    }

    public Vector getPermissionEntriesForUser(int idUser, int idLanguage) throws SQLException {
        Vector<PermissionEntry> result = new Vector<PermissionEntry>();
        this.selectPermissionEntriesForUser.setInt(1, idUser);
        ResultSet rs = this.selectPermissionEntriesForUser.executeQuery();
        while (rs.next()) {
            int idPanel = rs.getInt("panel");
            int idPermission = rs.getInt("permission");
            String className = rs.getString("classname");
            String panel = this.getPanelLabelById(idPanel, idLanguage);
            String permission = this.getPermissionLabelById(idPermission, idLanguage);
            PermissionEntry pe = new PermissionEntry(panel, permission, idPanel, idPermission, className);
            result.add(pe);
        }
        rs.close();
        return result;
    }

    public String getPanelLabelById(int idPanel, int idLanguage) throws SQLException {
        String result = null;
        this.selectPanelNameById.setInt(1, idPanel);
        this.selectPanelNameById.setInt(2, idLanguage);
        ResultSet rs = this.selectPanelNameById.executeQuery();
        if (rs.next()) {
            result = rs.getString("name");
        }
        rs.close();
        return result;
    }

    public String getPermissionLabelById(int idPermission, int idLanguage) throws SQLException {
        String result = null;
        this.selectPermissionsNameById.setInt(1, idPermission);
        this.selectPermissionsNameById.setInt(2, idLanguage);
        ResultSet rs = this.selectPermissionsNameById.executeQuery();
        if (rs.next()) {
            result = rs.getString("name");
        }
        rs.close();
        return result;
    }

    public void removeAllGuiPermissionsFromUser(int userId) throws SQLException {
        this.removeAllGuiPermissionsFromUser.setInt(1, userId);
        this.removeAllGuiPermissionsFromUser.execute();
    }

    public void addGuiPermissionToUser(int userId, int panelId, int permissionId) throws SQLException {
        this.addGuiPermissionToUser.setInt(1, userId);
        this.addGuiPermissionToUser.setInt(2, panelId);
        this.addGuiPermissionToUser.setInt(3, permissionId);
        this.addGuiPermissionToUser.execute();
    }

    public void addUserLog(int idUser, String text) throws SQLException {
        this.addUserLog.setInt(1, idUser);
        this.addUserLog.setString(2, text);
        this.addUserLog.execute();
    }

    public int getUserLogCount() throws SQLException {
        ResultSet rs = this.getUserLogCount.executeQuery();
        rs.next();
        int res = rs.getInt(1);
        rs.close();
        return res;
    }

    public Vector getUserLogReport(Timestamp start, Timestamp stop, int idUser, String prefix) throws SQLException {
        Vector<UserLogEntry> result = new Vector<UserLogEntry>();
        this.userLogReport.setTimestamp(1, stop);
        this.userLogReport.setTimestamp(2, start);
        this.userLogReport.setInt(3, idUser);
        this.userLogReport.setInt(4, idUser);
        String prefixS = prefix + "%";
        this.userLogReport.setString(5, prefixS);
        ResultSet rs = this.userLogReport.executeQuery();
        while (rs.next()) {
            UserLogEntry ue = new UserLogEntry();
            ue.setIdUser(rs.getInt("id_user"));
            ue.setDateadd(Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(rs.getTimestamp("dateadd")));
            ue.setText(rs.getString("text"));
            ue.setUser(rs.getString("login"));
            result.add(ue);
        }
        rs.close();
        return result;
    }
}

