/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.users.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import ro.atreides.users.GuiPanel;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.CleanupRequired;
import ro.atreides.utils.Logger;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;

public class AdministrationPanel
extends ReflectedJPanel
implements CleanupRequired {
    private JTabbedPane _main = null;
    private UsersLogic usersLogic = UsersLogic.getInstance();
    public static User loggedUser;
    public static int openCount;

    public void setLoggedUser(User loggedUser) {
        AdministrationPanel.loggedUser = loggedUser;
    }

    private void init() {
        this._main = new JTabbedPane();
        Collection rights = this.usersLogic.getBoLevelOnePanels(loggedUser);
        for (GuiPanel uv : rights) {
            Collection children = this.usersLogic.getChildrenForPanel(uv.getId(), loggedUser.getId(), loggedUser);
            this.usersLogic.buildGui(this._main, children, loggedUser, this.usersLogic, 1);
        }
    }

    @Override
    public void doStuff() {
        this.init();
        this.display();
    }

    @Override
    public void cleanup() {
        --openCount;
        Component[] comps = this._main.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            try {
                CleanupRequired cl = (CleanupRequired)((Object)comps[i]);
                cl.cleanup();
                continue;
            }
            catch (ClassCastException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        if (loggedUser != null) {
            this.usersLogic.addUserLogCommit(loggedUser.getId(), LangRoAll.logout);
        }
        if (openCount > 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DialogUtils.errorDialog(GuiUtils.currentFrame, "Aveti mai multe deschide ferestre de administrare ! Este recomandat sa le inchideti pe toate !", LangRoAll.eroare);
                }
            });
        }
        loggedUser = null;
    }

    private void display() {
        ++openCount;
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.fill = 1;
        c.anchor = 10;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this._main, c);
    }

    static {
        openCount = 0;
    }
}

