/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.users.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.users.Group;
import ro.atreides.users.GuiPanel;
import ro.atreides.users.Permission;
import ro.atreides.users.PermissionEntry;
import ro.atreides.users.UserEntry;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.EventListener;
import ro.atreides.utils.ReflectedJPanel;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.multilanguage.Language;
import ro.atreides.utils.multilanguage.LanguageLogic;
import ro.atreides.utils.users.gui.AdministrationPanel;

public class UsersPanel
extends ReflectedJPanel {
    private AbstractTM usersTm;
    private AbstractTM permissionsTm;
    private AbstractTM groupsTm;
    private UserEntry editUser;
    private UsersLogic usersLogic;
    private JTextField login;
    private JTextField name;
    private JTextField codAutentificare;
    private JTextField codUnic;
    private JComboBox languageCombo;
    private JPasswordField parola;
    private JPasswordField parolaAgain;
    private JButton saveButton;
    private JButton deleteButton;
    private JButton resetButton;
    private JButton cancelButton;
    private Vector permissions = new Vector();
    private Vector groupsCollection = new Vector();

    public UsersPanel(UsersLogic usersLogic) {
        this.usersLogic = usersLogic;
        usersLogic.addListener(new EventListener(){

            @Override
            public void dataChanged() {
                UsersPanel.this.updateUsersTable();
            }

            @Override
            public String getName() {
                return "UsersPanel";
            }
        }, 4);
        this.display();
        this.updateUsersTable();
    }

    @Override
    public void doStuff() {
    }

    private void updateUsersTable() {
        this.usersTm.refresh(this.usersLogic.getUserEntries(AdministrationPanel.loggedUser));
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.3;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)this.getUsersTable(), c);
        c.weighty = 0.7;
        ++c.gridy;
        this.add((Component)this.getDetailsPanel(), c);
    }

    private JPanel getGroupsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        final JComboBox groups = new JComboBox((Vector)this.usersLogic.getAllGroups(AdministrationPanel.loggedUser));
        result.add(groups, c);
        c.gridx = 1;
        c.gridy = 0;
        JButton adauga = new JButton(LangRoAll.adauga);
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Group g = (Group)groups.getSelectedItem();
                if (!UsersPanel.this.groupsCollection.contains(g)) {
                    UsersPanel.this.groupsCollection.add(g);
                    UsersPanel.this.groupsTm.refresh(UsersPanel.this.groupsCollection);
                }
            }
        });
        result.add((Component)adauga, c);
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.fill = 1;
        c.gridwidth = 2;
        String[] columns = new String[]{LangRoAll.grup};
        this.groupsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Group g = (Group)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return g.getName();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final JTable tabel = new JTable(this.groupsTm);
        tabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tabel.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    UsersPanel.this.groupsCollection.removeElementAt(selRow);
                    UsersPanel.this.groupsTm.refresh(UsersPanel.this.groupsCollection);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(tabel);
        result.add((Component)scroll, c);
        result.setBorder(new TitledBorder("Grupuri"));
        return result;
    }

    private JPanel getButtonsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        this.saveButton = new JButton(LangRoAll.salveaza);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.saveUser();
            }
        });
        result.add((Component)this.saveButton, c);
        c.gridx += 2;
        this.resetButton = new JButton("Valori initiale");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.initFields();
            }
        });
        result.add((Component)this.resetButton, c);
        c.gridx += 2;
        this.deleteButton = new JButton(LangRoAll.sterge);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.deleteUser();
            }
        });
        result.add((Component)this.deleteButton, c);
        c.gridx += 2;
        this.cancelButton = new JButton(LangRoAll.renunta);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsersPanel.this.setEditUser(null);
                UsersPanel.this.initFields();
            }
        });
        result.add((Component)this.cancelButton, c);
        return result;
    }

    private JPanel getPersonalInfoPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Nume"), c);
        ++c.gridx;
        this.name = new JTextField(10);
        result.add((Component)this.name, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod unic"), c);
        ++c.gridx;
        this.codUnic = new JTextField(10);
        result.add((Component)this.codUnic, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Limba"), c);
        ++c.gridx;
        this.languageCombo = new JComboBox((Vector)LanguageLogic.getInstance().getAllLanguages());
        result.add((Component)this.languageCombo, c);
        result.setBorder(new TitledBorder("Informatii personale"));
        return result;
    }

    private JPanel getAutentificarePanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(LangRoAll.login), c);
        ++c.gridx;
        this.login = new JTextField(10);
        result.add((Component)this.login, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel(LangRoAll.parola), c);
        ++c.gridx;
        this.parola = new JPasswordField(10);
        result.add((Component)this.parola, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Parola din nou"), c);
        ++c.gridx;
        this.parolaAgain = new JPasswordField(10);
        result.add((Component)this.parolaAgain, c);
        ++c.gridy;
        c.gridx = 0;
        result.add((Component)new JLabel("Cod autentificare"), c);
        ++c.gridx;
        this.codAutentificare = new JTextField(10);
        result.add((Component)this.codAutentificare, c);
        result.setBorder(new TitledBorder("Autentificare"));
        return result;
    }

    private JPanel getDetailsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.gridy = 0;
        c.gridx = 0;
        result.add((Component)this.getPersonalInfoPanel(), c);
        ++c.gridx;
        result.add((Component)this.getAutentificarePanel(), c);
        ++c.gridx;
        c.fill = 1;
        result.add((Component)this.getGroupsPanel(), c);
        c.gridwidth = 3;
        ++c.gridy;
        c.gridx = 0;
        c.weighty = 1.0;
        c.fill = 1;
        result.add((Component)this.getPermissionsPanel(), c);
        ++c.gridy;
        c.fill = 2;
        c.weighty = 0.0;
        result.add((Component)this.getButtonsPanel(), c);
        result.setBorder(new TitledBorder(LangRoAll.detalii));
        return result;
    }

    private void deleteUser() {
        String result;
        if (this.editUser != null && Validators.correctString(result = this.usersLogic.deleteUser(this.editUser, AdministrationPanel.loggedUser))) {
            DialogUtils.errorDialog(this, result, LangRoAll.nuPotContinua);
            return;
        }
        this.editUser = null;
        this.initFields();
    }

    private void saveUser() {
        String name = this.name.getText();
        if (!Validators.correctString(name)) {
            DialogUtils.errorDialog(this, "Nume incorect", LangRoAll.nuPotContinua);
            this.name.requestFocus();
            return;
        }
        String login = this.login.getText();
        if (!Validators.correctString(login)) {
            DialogUtils.errorDialog(this, "Login name incorect", LangRoAll.nuPotContinua);
            this.login.requestFocus();
            return;
        }
        int id = this.usersLogic.getIdUserWithLogin(login);
        if (id != -1) {
            if (this.editUser != null) {
                if (this.editUser.getId() != id) {
                    DialogUtils.errorDialog(this, "Login deja inregistrat", LangRoAll.nuPotContinua);
                    this.login.setText("");
                    this.login.requestFocus();
                    return;
                }
            } else {
                DialogUtils.errorDialog(this, "Login deja inregistrat", LangRoAll.nuPotContinua);
                this.login.setText("");
                this.login.requestFocus();
                return;
            }
        }
        String pass1 = new String(this.parola.getPassword());
        String pass2 = new String(this.parolaAgain.getPassword());
        Language l = (Language)this.languageCombo.getSelectedItem();
        String cod = this.codAutentificare.getText();
        String codUnic1 = this.codUnic.getText();
        if (this.editUser == null) {
            if (!this.checkPasswords(pass1, pass2)) {
                return;
            }
            if (!Validators.correctString(pass1) && !DialogUtils.confirmDialog(this, "Parola nesetata. Confirmati corectitudinea", LangRoAll.confirmare)) {
                return;
            }
            this.usersLogic.addUser(name, pass1, login, l.getId(), this.groupsCollection, this.permissions, cod, codUnic1);
            this.initFields();
        } else {
            if (pass1 != null && pass1.length() > 0 || pass2 != null && pass2.length() > 0) {
                if (!this.checkPasswords(pass1, pass2)) {
                    return;
                }
            } else {
                pass1 = this.editUser.getPassword();
            }
            this.usersLogic.updateUser(this.editUser, name, pass1, login, l.getId(), this.groupsCollection, this.permissions, cod, codUnic1);
            this.editUser = null;
            this.initFields();
        }
    }

    private boolean checkPasswords(String pass1, String pass2) {
        if (pass1 == null || pass2 == null) {
            return false;
        }
        if (!pass1.equals(pass2)) {
            DialogUtils.errorDialog(this, "Parolele nu coincid", LangRoAll.nuPotContinua);
            this.parola.setText("");
            this.parolaAgain.setText("");
            this.parola.requestFocus();
            return false;
        }
        return true;
    }

    private JPanel getPermissionsPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel("Sectiune"), c);
        c.gridx = 1;
        final JComboBox panelsCombo = new JComboBox((Vector)this.usersLogic.getAllPanels(AdministrationPanel.loggedUser));
        result.add(panelsCombo, c);
        c.gridx = 2;
        result.add((Component)new JLabel("Permisii"), c);
        c.gridx = 3;
        final JComboBox permissionsCombo = new JComboBox((Vector)this.usersLogic.getAllPermissions(AdministrationPanel.loggedUser));
        result.add(permissionsCombo, c);
        c.gridx = 4;
        JButton adauga = new JButton(LangRoAll.adauga);
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiPanel panel = (GuiPanel)panelsCombo.getSelectedItem();
                Permission permission = (Permission)permissionsCombo.getSelectedItem();
                UsersPanel.this.permissionAdd(panel, permission);
            }
        });
        result.add((Component)adauga, c);
        c.weighty = 1.0;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 5;
        String[] columns = new String[]{"Sectiune", "Permisie"};
        this.permissionsTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                PermissionEntry gp = (PermissionEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return gp.getPanelName();
                    }
                    case 1: {
                        return gp.getPermissionsString();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final JTable tabel = new JTable(this.permissionsTm);
        tabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tabel.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2) {
                    UsersPanel.this.permissions.removeElementAt(selRow);
                    UsersPanel.this.refreshPermissions();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(tabel);
        result.add((Component)scroll, c);
        result.setBorder(new TitledBorder("Permisii"));
        return result;
    }

    private void refreshPermissions() {
        this.permissionsTm.refresh(this.permissions);
    }

    private void permissionAdd(GuiPanel panel, Permission perm) {
        PermissionEntry pe = new PermissionEntry(panel.getPanelName(), perm.getLabel(), panel.getId(), perm.getId(), panel.getClassName());
        if (!this.permissions.contains(pe)) {
            this.permissions.add(pe);
            this.refreshPermissions();
        }
    }

    private JPanel getUsersTable() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.anchor = 10;
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        String[] columns = new String[]{LangRoAll.login, "Nume", "Grupuri", "Limba", "Cod unic"};
        this.usersTm = new AbstractTM(columns, Utils.getStringClass(columns.length), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                UserEntry user = (UserEntry)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return user.getLogin();
                    }
                    case 1: {
                        return user.getName();
                    }
                    case 2: {
                        return UsersPanel.this.usersLogic.getGroupsAsString(user.getGroups());
                    }
                    case 3: {
                        return UsersPanel.this.usersLogic.getLanguageById(user.getLanguage());
                    }
                    case 4: {
                        return user.getCodUnic();
                    }
                }
                return "";
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }
        });
        final JTable tabel = new JTable(this.usersTm);
        tabel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = tabel.rowAtPoint(e.getPoint());
                if (selRow == -1) {
                    return;
                }
                final UserEntry selected = (UserEntry)UsersPanel.this.usersTm.getObjectAt(selRow);
                final JPopupMenu popup = new JPopupMenu();
                JMenuItem edit = new JMenuItem(LangRoAll.modifica);
                popup.add(edit);
                edit.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UsersPanel.this.setEditUser(selected);
                        popup.setVisible(false);
                    }
                });
                popup.show(e.getComponent(), e.getX(), e.getY());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JScrollPane scroll = new JScrollPane(tabel);
        result.add((Component)scroll, c);
        result.setBorder(new TitledBorder("Utilizatori"));
        return result;
    }

    private void initFields() {
        if (this.editUser != null) {
            this.name.setText(this.editUser.getName());
            this.login.setText(this.editUser.getLogin());
            this.permissions = new Vector(this.editUser.getPermissions());
            this.refreshPermissions();
            this.groupsCollection = new Vector(this.editUser.getGroups());
            this.groupsTm.refresh(this.groupsCollection);
            this.parola.setText("");
            this.parolaAgain.setText("");
            this.codAutentificare.setText(this.editUser.getCodAutentificare());
            this.codUnic.setText(this.editUser.getCodUnic());
        } else {
            this.permissions = new Vector();
            this.refreshPermissions();
            this.groupsCollection = new Vector();
            this.groupsTm.refresh(this.groupsCollection);
            this.login.setText("");
            this.parola.setText("");
            this.parolaAgain.setText("");
            this.name.setText("");
            this.codAutentificare.setText("");
            this.codUnic.setText("");
        }
    }

    private void setEditUser(UserEntry editUser) {
        this.editUser = editUser;
        this.initFields();
    }

    public void cleanup() {
        this.usersTm.refresh(new Vector());
        this.permissionsTm.refresh(new Vector());
        this.groupsTm.refresh(new Vector());
    }
}

