/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.valute;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.valute.Valuta;

public class ValuteImpl
implements DaoInterface {
    private Connection conn;
    private PreparedStatement addValuta;
    private PreparedStatement getAllValute;
    private PreparedStatement getValutaById;
    private PreparedStatement updateValuta;
    private PreparedStatement deleteValutaById;
    private PreparedStatement getValutaPrincipala;
    private PreparedStatement getValutaByDenumire;

    public ValuteImpl(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addValuta = this.conn.prepareStatement("insert into valute (denumire, principala, paritate) values (?, ?, ?)");
        this.getAllValute = this.conn.prepareStatement("select * from valute order by id");
        this.getValutaById = this.conn.prepareStatement("select * from valute where id = ?");
        this.updateValuta = this.conn.prepareStatement("update valute set denumire = ?, principala = ?, paritate = ? where id = ?");
        this.deleteValutaById = this.conn.prepareStatement("delete from valute where id = ?");
        this.getValutaPrincipala = this.conn.prepareStatement("select * from valute where principala = 1");
        this.getValutaByDenumire = this.conn.prepareStatement("select * from valute where denumire = ?");
    }

    public Vector<Valuta> getAllValute() throws SQLException {
        Vector<Valuta> result = new Vector<Valuta>();
        ResultSet rs = this.getAllValute.executeQuery();
        while (rs.next()) {
            result.add(this.getValutaFromRS(rs));
        }
        return result;
    }

    private Valuta getValutaFromRS(ResultSet rs) throws SQLException {
        Valuta valuta = new Valuta();
        valuta.setId(rs.getInt("id"));
        valuta.setDenumire(rs.getString("denumire"));
        int principala = rs.getInt("principala");
        valuta.setPrincipala(principala == 1);
        valuta.setParitate(rs.getDouble("paritate"));
        return valuta;
    }

    public void addValuta(Valuta valuta) throws SQLException {
        this.addValuta.setString(1, valuta.getDenumire());
        this.addValuta.setInt(2, valuta.isPrincipala() ? 1 : 0);
        this.addValuta.setDouble(3, valuta.getParitate());
        this.addValuta.execute();
    }

    public Valuta getValutaById(int idValuta) throws SQLException {
        this.getValutaById.setInt(1, idValuta);
        ResultSet rs = this.getValutaById.executeQuery();
        if (rs.next()) {
            Valuta valuta = this.getValutaFromRS(rs);
            return valuta;
        }
        return null;
    }

    public void updateValuta(Valuta v) throws SQLException {
        this.updateValuta.setString(1, v.getDenumire());
        this.updateValuta.setInt(2, v.isPrincipala() ? 1 : 0);
        this.updateValuta.setDouble(3, v.getParitate());
        this.updateValuta.setInt(4, v.getId());
        this.updateValuta.executeUpdate();
    }

    public void deleteValutaById(int idValuta) throws SQLException {
        this.deleteValutaById.setInt(1, idValuta);
        this.deleteValutaById.execute();
    }

    public Valuta getValutaPrincipala() throws SQLException {
        ResultSet rs = this.getValutaPrincipala.executeQuery();
        if (rs.next()) {
            Valuta valuta = this.getValutaFromRS(rs);
            return valuta;
        }
        return null;
    }

    public Valuta getValutaByDenumire(String denumire) throws SQLException {
        this.getValutaByDenumire.setString(1, denumire);
        ResultSet rs = this.getValutaByDenumire.executeQuery();
        if (rs.next()) {
            return this.getValutaFromRS(rs);
        }
        return null;
    }
}

