/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.xmllauncher;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.Vector;
import org.xml.sax.SAXException;
import ro.atreides.ecr.EcrFactory;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.xmllauncher.XmlProperties;

public class XmlLauncher {
    private static final String applicationFile = "application.xml";
    public static String launchingDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(String[] args) {
        File appFile;
        Logger.getInstance(6, "launcher.log");
        if (args == null || args.length < 1) {
            Logger.logError((Object)XmlLauncher.class.getName(), "missing launching dir");
            Utils.systemExit();
        }
        if (!(appFile = new File((launchingDir = args[0]) + File.separator + applicationFile)).exists()) {
            Logger.logError((Object)XmlLauncher.class.getName(), "missing application.xml");
            Utils.systemExit();
        }
        try {
            File[] ecrFiles;
            File[] moduleFiles;
            Vector<String> allItems = new Vector<String>();
            Vector<String> params = new Vector<String>();
            Properties appProps = XmlProperties.readPropertiesFromXml(appFile.getAbsolutePath(), false);
            for (String s : appProps.stringPropertyNames()) {
                if (s.toLowerCase().startsWith("application")) continue;
                params.add(s);
                params.add(appProps.getProperty(s));
            }
            File dir = new File(launchingDir);
            File[] sectionFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String s1 = name.toLowerCase();
                    return s1.startsWith("section") && s1.endsWith(".xml");
                }
            });
            if (sectionFiles.length != 1) {
                Logger.logError((Object)XmlLauncher.class.getName(), "Section file must be one and only one ");
                Utils.systemExit();
            }
            Properties sectionProps = XmlProperties.readPropertiesFromXml(sectionFiles[0].getAbsolutePath(), false);
            params.add("-section");
            params.add(sectionProps.getProperty("section"));
            String module = new String();
            for (File moduleFile : moduleFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String s1 = name.toLowerCase();
                    return s1.startsWith("module") && s1.endsWith(".xml");
                }
            })) {
                Properties moduleProps = XmlProperties.readPropertiesFromXml(moduleFile.getAbsolutePath(), false);
                for (String key : moduleProps.stringPropertyNames()) {
                    if (key.toLowerCase().startsWith("module")) {
                        module = module + moduleProps.getProperty(key) + ",";
                        continue;
                    }
                    params.add(key);
                    params.add(moduleProps.getProperty(key));
                }
            }
            if (module.length() > 0) {
                allItems.add("-modules");
                module = module.substring(0, module.length() - 1);
                allItems.add(module);
            }
            if ((ecrFiles = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    String s1 = name.toLowerCase();
                    return s1.startsWith("ecr") && s1.endsWith(".xml");
                }
            })).length > 1) {
                Logger.logError((Object)XmlLauncher.class.getName(), "Ecr file must be at most one ");
                Utils.systemExit();
            }
            if (ecrFiles.length == 1) {
                Properties ecrProps = XmlProperties.readPropertiesFromXml(ecrFiles[0].getAbsolutePath(), true);
                String type = ecrProps.getProperty("ecr");
                params.add("-ecrType");
                params.add(type);
                EcrFactory.launcherProperties.put(type, ecrProps);
            }
            allItems.addAll(params);
            String className = appProps.getProperty("application");
            Class<?> cls = Class.forName(className);
            Method meth = cls.getMethod("startProgram", String[].class);
            String s = "Launching class " + className + " with params [ ";
            String[] params1 = new String[allItems.size()];
            int i = 0;
            for (String item : allItems) {
                params1[i++] = item;
                s = s + "\"" + item + "\" ";
            }
            s = s + "]";
            Logger.logDebug(XmlLauncher.class.getName(), s);
            meth.invoke(null, new Object[]{params1});
            System.out.println(">>>> after meth.invoke");
        }
        catch (IOException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (SAXException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (ClassNotFoundException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (IllegalAccessException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (NoSuchMethodException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (InvocationTargetException e) {
            Logger.logException(XmlLauncher.class.getName(), (Exception)e);
            Utils.systemExit();
        }
        catch (Throwable e) {
            Logger.logError((Object)XmlLauncher.class.getName(), e);
            Utils.systemExit();
        }
    }
}

