/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.anaf;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.anaf.GsonRmiClient;
import ro.deversoft.anaf.RmiObserver;
import ro.deversoft.anaf.beans.FoundOrNotBean;
import ro.deversoft.anaf.beans.OrderBean;
import ro.deversoft.anaf.beans.ResponseBean;

public class AnafUtils {
    private static final String CITY_TARGET = "MUN";
    private static final String TAG = AnafUtils.class.getName();
    private static final String JUD_TARGET = "JUD";

    public static ResponseBean pullBean() {
        ResponseBean rBean = null;
        try {
            GsonRmiClient instance = GsonRmiClient.getInstance();
            rBean = instance.pullBean();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return rBean;
    }

    public static Object pullFoundBean() {
        FoundOrNotBean fbean = null;
        try {
            GsonRmiClient instance = GsonRmiClient.getInstance();
            ResponseBean rBean = instance.pullBean();
            if (rBean == null) {
                return "Raspuns invalid de la server!";
            }
            String message = rBean.getMessage();
            List<FoundOrNotBean> foundBeans = rBean.getFound();
            List<FoundOrNotBean> notfoundBeans = rBean.getNotfound();
            if (!message.equalsIgnoreCase("SUCCESS") || foundBeans.isEmpty()) {
                FoundOrNotBean foundOrNotBean = notfoundBeans.get(0);
                String mesaj = null;
                if (foundOrNotBean != null) {
                    mesaj = foundOrNotBean.getMesaj();
                }
                return "Eroare cerere ANAF : " + (mesaj == null ? "NA" : mesaj);
            }
            fbean = foundBeans.get(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return fbean;
    }

    public static String getValidCUI(List<FoundOrNotBean> foundOrNotBeanList) {
        String result = null;
        if (!foundOrNotBeanList.isEmpty()) {
            FoundOrNotBean foundOrNotBean = foundOrNotBeanList.get(0);
            if (foundOrNotBean == null) {
                return null;
            }
            String cui = foundOrNotBean.getCui();
            if (Validators.correctString(cui)) {
                result = cui;
            }
        }
        return result;
    }

    public static String getCityFromAddress(String address) {
        String[] splitAddress = address.split(",[ ]*");
        String city = "";
        for (int i = splitAddress.length - 1; i >= 0; --i) {
            String[] splitElement;
            String element = splitAddress[i];
            for (String spEl : splitElement = element.split("\\s+")) {
                if (spEl.toUpperCase().contains(CITY_TARGET)) {
                    city = element.replace(spEl, "").trim();
                    continue;
                }
                if (!spEl.toUpperCase().contains(JUD_TARGET)) continue;
                city = city + ", " + element;
            }
        }
        return city;
    }

    public static String getAdressWithoutCity(String address) {
        String[] splitAddress = address.split(",[ ]*");
        String addressNoCity = address;
        for (String element : splitAddress) {
            if (!element.toUpperCase().contains(CITY_TARGET) && !element.toUpperCase().contains(JUD_TARGET)) continue;
            addressNoCity = addressNoCity.replace(element + ",", "").trim();
        }
        return addressNoCity;
    }

    public static String getFoundOrNotMessage(List<FoundOrNotBean> foundOrNotList) {
        FoundOrNotBean foundOrNotBean;
        String message = null;
        if (!foundOrNotList.isEmpty() && (foundOrNotBean = foundOrNotList.get(0)) != null) {
            message = foundOrNotBean.getMesaj();
        }
        return message == null ? "NA" : message;
    }

    public static synchronized void invokeAnafCall(String cui, RmiObserver rObs) {
        String ipAndPort = VpConfig.getInstance().anafGsonServerConf;
        if (ipAndPort != null) {
            ipAndPort = ipAndPort.replace("=", ":");
            try {
                GsonRmiClient client = GsonRmiClient.getInstance();
                client.attach(rObs);
                client.invokeAnafCall(cui, ipAndPort);
            }
            catch (IOException | URISyntaxException e) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Eroare comunicare JSON. Incercati din nou peste cateva minute! Daca eroarea persista contactati adminii.", LangRoAll.eroare);
                e.printStackTrace();
            }
        }
    }

    public static OrderBean verifyResponseFromServer(String requestObject, ResponseBean rBean) {
        OrderBean.Builder result = new OrderBean.Builder();
        String message = rBean.getMessage();
        List<FoundOrNotBean> found = rBean.getFound();
        if (message.equals("SUCCESS") && found != null && !found.isEmpty()) {
            FoundOrNotBean fBean = found.get(0);
            result.setCuiFound(true).setCui(fBean.getCui()).setMesaj(fBean.getMesaj()).setPlatitorTVA(fBean.isTva());
        } else {
            result.setCuiFound(false);
            List<FoundOrNotBean> notfound = rBean.getNotfound();
            if (notfound != null && !notfound.isEmpty()) {
                String notFoundMessage;
                FoundOrNotBean nfBean = notfound.get(0);
                String beanCui = nfBean.getCui();
                if (Validators.correctString(beanCui)) {
                    result.setCui(beanCui);
                }
                if (Validators.correctString(notFoundMessage = nfBean.getMesaj())) {
                    result.setMesaj(notFoundMessage);
                }
            } else {
                result.setMesaj(rBean.getMessage());
            }
        }
        String formattedReqObj = requestObject.replaceAll("[^0-9]", "");
        if (!formattedReqObj.equals(result.getCui())) {
            return new OrderBean.Builder().setMesaj("Valorile CUI trimis si CUI primit in raspuns de la server nu coincid!").build();
        }
        return result.build();
    }
}

