/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.anaf;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.serializer.ExceptionSerializer;
import com.google.code.gsonrmi.serializer.ParameterSerializer;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.code.gsonrmi.transport.rmi.RmiService;
import com.google.code.gsonrmi.transport.tcp.TcpProxy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.anaf.RmiObserver;
import ro.deversoft.anaf.beans.ResponseBean;

public class GsonRmiClient {
    private static GsonRmiClient instance;
    private List<RmiObserver> observers = new ArrayList<RmiObserver>();
    private Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer()).registerTypeAdapter((Type)((Object)Parameter.class), new ParameterSerializer()).create();
    private ResponseBean bean = null;
    private Transport t = new Transport();
    private String requestObject = null;

    public static synchronized GsonRmiClient getInstance() throws IOException, URISyntaxException {
        if (instance == null) {
            instance = new GsonRmiClient();
        }
        return instance;
    }

    private GsonRmiClient() throws IOException, URISyntaxException {
        new TcpProxy(Arrays.asList(new InetSocketAddress(30101)), this.t, this.gson).start();
        new RmiService(this.t, this.gson).start();
        new Call(new Route(new URI("rmi:service")), "register", "myObject", this).send(this.t);
    }

    @RMI
    public void returnedBean(String returnedObject, RpcError rpcError) {
        ResponseBean bean;
        System.out.println(returnedObject);
        if (rpcError != null) {
            System.err.println(rpcError.message);
        }
        if (Validators.correctString(returnedObject) && (bean = this.gson.fromJson(returnedObject, ResponseBean.class)) != null) {
            this.bean = bean;
        }
        try {
            this.notifyAllObservers(this.requestObject);
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }

    public ResponseBean getBean() {
        return this.bean;
    }

    public ResponseBean pullBean() {
        ResponseBean recBean = this.bean;
        this.bean = null;
        this.observers.clear();
        return recBean;
    }

    public synchronized void invokeAnafCall(String cui, String ipAndPort) throws IOException, URISyntaxException {
        this.requestObject = cui;
        new Call(new Route(new URI("tcp://" + ipAndPort), new URI("rmi:herObject")), "executeVerificarePersoanaJuridica", cui).callback(new URI("rmi:myObject"), "returnedBean", new Object[0]).send(this.t);
    }

    public void attach(RmiObserver obs) {
        this.observers.add(obs);
    }

    public void notifyAllObservers(String cui) throws ConcurrentModificationException {
        for (RmiObserver rObs : this.observers) {
            rObs.onUpdate(cui);
        }
        this.requestObject = null;
    }
}

