/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.android.foodtablet.gsonserver;

import com.google.code.gsonrmi.annotations.RMI;
import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import ro.atreides.nomenclatura.Categorie;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.promo.ClientPromotieView;
import ro.atreides.promo.Promotion;
import ro.atreides.promo.PromotionElement;
import ro.atreides.promo.PromotionLogic;
import ro.atreides.promo.PromotionPeriod;
import ro.atreides.restaurant.base.Meniu;
import ro.atreides.restaurant.base.OptiuneMeniu;
import ro.atreides.restaurant.base.OptiuneProdus;
import ro.atreides.restaurant.base.OrdineServire;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.base.Table;
import ro.atreides.restaurant.gui.touch2.LocationPanel2;
import ro.atreides.restaurant.logic.BonFIscalInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Order;
import ro.atreides.utils.Utils;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.atreides.utils.tva.Tva;
import ro.atreides.utils.tva.TvaLogic;
import ro.deversoft.android.foodtablet.DeverFood.utils.gson.beans.Payment;
import ro.deversoft.android.foodtablet.DeverFood.utils.gson.beans.SaleUpper;
import ro.deversoft.android.foodtablet.Enums;
import ro.deversoft.android.foodtablet.dao.Clients;
import ro.deversoft.android.foodtablet.dao.Cod_de_bare_produse;
import ro.deversoft.android.foodtablet.dao.Groups;
import ro.deversoft.android.foodtablet.dao.Menu_choice;
import ro.deversoft.android.foodtablet.dao.Menu_products;
import ro.deversoft.android.foodtablet.dao.Menus;
import ro.deversoft.android.foodtablet.dao.Orders;
import ro.deversoft.android.foodtablet.dao.Produs;
import ro.deversoft.android.foodtablet.dao.Promotion_items;
import ro.deversoft.android.foodtablet.dao.Promotions;
import ro.deversoft.android.foodtablet.dao.Sales;
import ro.deversoft.android.foodtablet.dao.Sectie;
import ro.deversoft.android.foodtablet.dao.Servire;
import ro.deversoft.android.foodtablet.dao.Tip_Plata;
import ro.deversoft.android.foodtablet.dao.User;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;
import ro.deversoft.android.foodtablet.gsonserver.LocatieTableBean;

public class RealImplDeverFoodGSONServer
extends GSONEntity {
    private static RealImplDeverFoodGSONServer deverFoodGsonServer;
    private ConnectionPool pool;
    private Hashtable<String, LocatieTableBean> clientiTableHash = new Hashtable();
    private Hashtable<Integer, ro.deversoft.android.foodtablet.dao.Categorie> categoriiHash = new Hashtable();
    private Hashtable<Integer, Sectie> sectiiHash = new Hashtable();
    private Hashtable<Integer, Produs> productsHash = new Hashtable();
    private ArrayList<Cod_de_bare_produse> coduriList = new ArrayList();
    private Vector<Menus> menus = new Vector();
    private Vector<Menu_choice> menuChoices = new Vector();
    private Vector<Menu_products> menuProducts = new Vector();
    private Vector<Promotions> promotii = new Vector();
    private Vector<Promotion_items> promotion_items = new Vector();
    public static Vector<String> sectii;

    private RealImplDeverFoodGSONServer(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
        this.reloadData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public synchronized boolean reloadData() {
        this.pool = ConnectionPool.getInstance();
        this.menuChoices.clear();
        this.menuProducts.clear();
        this.menus.clear();
        this.promotii.clear();
        this.promotion_items.clear();
        this.coduriList.clear();
        Vector allLocations = RestLogic.getInstance().getLocations();
        for (Location location : allLocations) {
            LocatieTableBean locatie1 = new LocatieTableBean();
            locatie1.setCodLocatie(location.getCod());
            this.clientiTableHash.put(locatie1.getCodLocatie(), locatie1);
        }
        Vector<ro.atreides.nomenclatura.Sectie> allSectii = NomeclaturaLogic.getInstance().getAllSectii();
        for (ro.atreides.nomenclatura.Sectie sectie : allSectii) {
            Sectie s = new Sectie(sectie.getName(), true, null);
            s.setId(sectie.getId());
            this.sectiiHash.put(sectie.getId(), s);
        }
        Vector<Categorie> categorii = null;
        if (sectii != null && sectii.size() > 0) {
            categorii = NomeclaturaLogic.getInstance().getCategoriiNaturalOrder(sectii);
            Collections.sort(categorii, NomeclaturaLogic.FORCED_ORDER__CATEGORIES_COMPARATOR);
        } else {
            categorii = NomeclaturaLogic.getInstance().getCategoriiForcedOrder(-1);
        }
        for (Categorie categorie : categorii) {
            Sectie id_sectie = this.sectiiHash.get(categorie.getSectie());
            ro.deversoft.android.foodtablet.dao.Tva id_tva = new ro.deversoft.android.foodtablet.dao.Tva(categorie.getIdTva());
            ro.deversoft.android.foodtablet.dao.Categorie toadd = new ro.deversoft.android.foodtablet.dao.Categorie(categorie.getName(), true, categorie.getCodDepartament(), categorie.getNrOrdine(), id_sectie, null, id_tva);
            toadd.setId(categorie.getId());
            if (categorie.getName().startsWith("-")) {
                Logger.logDebug(this, "Categorie IGNORED : " + categorie.getName());
                continue;
            }
            Logger.logDebug(this, "Categorie ADDED : " + categorie.getName());
            this.categoriiHash.put(categorie.getId(), toadd);
        }
        try {
            Vector<Product> allProducts = NomeclaturaLogic.getInstance().getAllProducts(1);
            for (Product product : allProducts) {
                ro.deversoft.android.foodtablet.dao.Categorie cat = this.categoriiHash.get(product.getIdCategorie());
                double pret = RestLogic.getInstance().getPriceForProductNoCommit(product.getId());
                Produs toadd = new Produs(pret, product.getName(), true, product.getNumeSectie(), product.getNumeCasa(), product.getCod() + "", "0", cat, null);
                toadd.setId(product.getId());
                Vector<String> allCodes = NomeclaturaLogic.getInstance().getAllBarCodesByIdProd(product.getId());
                for (String code : allCodes) {
                    Cod_de_bare_produse codBare = new Cod_de_bare_produse(code, toadd);
                    this.coduriList.add(codBare);
                }
                this.productsHash.put(product.getId(), toadd);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        Vector<Meniu> meniuri = RestLogic.getInstance().getAllMeniuri();
        int i = 0;
        int j = 1;
        for (Meniu sourceMenu : meniuri) {
            Menus targetMenu = new Menus(sourceMenu.getLabel(), sourceMenu.getZile(), sourceMenu.isActiv(), ++i, null);
            targetMenu.setId(sourceMenu.getId());
            Vector optiuneMeniu = RestLogic.getInstance().getOptiuniForMenu(sourceMenu.getId());
            for (OptiuneMeniu sourceOm : optiuneMeniu) {
                String omS = sourceOm.getNumeOptiune();
                Menu_choice menu_choice = new Menu_choice(omS, true, 1, targetMenu);
                menu_choice.setId(j++);
                Vector<OptiuneProdus> sourceProduse = RestLogic.getInstance().getOptiuniProdus(sourceMenu.getId(), sourceOm.getIdOptiune());
                for (OptiuneProdus sourceProduct : sourceProduse) {
                    double cant = sourceProduct.getCantitate();
                    double pret = sourceProduct.getPret();
                    int idProdus = sourceProduct.getIdProdus();
                    int idCateg = sourceProduct.getIdCategorie();
                    ro.deversoft.android.foodtablet.dao.Categorie cat = null;
                    Produs prod = null;
                    if (idProdus > 0) {
                        prod = this.productsHash.get(idProdus);
                    }
                    if (idCateg > 0) {
                        cat = this.categoriiHash.get(idCateg);
                    }
                    Menu_products menu_products = new Menu_products(true, cant, pret, menu_choice, null, cat, prod);
                    menu_products.setId(sourceProduct.getId());
                    this.menuProducts.add(menu_products);
                }
                this.menuChoices.add(menu_choice);
            }
            this.menus.add(targetMenu);
        }
        Vector<Promotion> dbPromos = PromotionLogic.getInstance().getPromotions();
        for (Promotion dbPromo : dbPromos) {
            PromotionPeriod period = dbPromo.getPeriod();
            Vector<PromotionElement> elements = dbPromo.getPromoElements();
            String perioadaText = period.getStartAsString() + "-" + period.getStopAsString();
            Promotions promotionToAdd = new Promotions(dbPromo.getId(), dbPromo.getLabel(), true, this.getTipDiscount(dbPromo), this.getTipPerioada(period), perioadaText, period.getWeekDays(), dbPromo.isPublicPromotion(), false, 0.0, 0.0);
            promotionToAdd.setId(dbPromo.getId());
            this.promotii.add(promotionToAdd);
            for (PromotionElement promotionElement : elements) {
                Produs produs = null;
                if (promotionElement.getProduct() > 0) {
                    produs = this.productsHash.get(promotionElement.getProduct());
                }
                ro.deversoft.android.foodtablet.dao.Categorie cat = null;
                if (promotionElement.getSubcat() > 0) {
                    cat = this.categoriiHash.get(promotionElement.getSubcat());
                }
                Sectie sec = null;
                if (promotionElement.getCategory() > 0) {
                    sec = this.sectiiHash.get(promotionElement.getCategory());
                }
                Promotion_items pi = new Promotion_items(promotionElement.getValue(), promotionToAdd, produs, cat, sec);
                this.promotion_items.add(pi);
            }
        }
        return true;
    }

    public static synchronized RealImplDeverFoodGSONServer getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            deverFoodGsonServer = new RealImplDeverFoodGSONServer(url, serverName, clientName, listeningPort);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return deverFoodGsonServer;
    }

    @RMI
    public List<Servire> getServiri() {
        LinkedList<Servire> servireList = new LinkedList<Servire>();
        Vector<OrdineServire> servire = RestLogic.getInstance().getOrdineServire(-1);
        for (OrdineServire ordineServire : servire) {
            Servire toadd = new Servire(ordineServire.getServire());
            toadd.setId(ordineServire.getId());
            servireList.add(toadd);
        }
        return servireList;
    }

    @RMI
    public List<User> getUsers() {
        LinkedList<User> users = new LinkedList<User>();
        Vector<ro.atreides.users.User> allusers = UsersLogic.getInstance().getUsersInGroup("group_fo_users");
        for (ro.atreides.users.User user : allusers) {
            Color c = LocationPanel2.getColorForUser(user);
            boolean retur = UsersLogic.getInstance().isUserInGroup(user.getId(), "group_bo_users");
            User toAdd = new User(user.getLogin(), c.getRGB(), user.getName(), user.getPassword(), retur, user.getCodAutentificare(), "", user.getCodUnic());
            toAdd.setId(user.getId());
            users.add(toAdd);
        }
        return users;
    }

    @RMI
    public List<Groups> getGroups() {
        LinkedList<Groups> groupsLinkedList = new LinkedList<Groups>();
        groupsLinkedList.add(new Groups("Admin"));
        groupsLinkedList.add(new Groups("Waiter"));
        groupsLinkedList.add(new Groups("Retur"));
        groupsLinkedList.add(new Groups("Promo"));
        return groupsLinkedList;
    }

    @RMI
    public List<Sectie> getSectii() {
        return new ArrayList<Sectie>(this.sectiiHash.values());
    }

    @RMI
    public List<ro.deversoft.android.foodtablet.dao.Tva> getTVA() {
        LinkedList<ro.deversoft.android.foodtablet.dao.Tva> tvaLinkedList = new LinkedList<ro.deversoft.android.foodtablet.dao.Tva>();
        Vector<Tva> tvas = TvaLogic.getInstance().getTvas();
        for (Tva tva : tvas) {
            ro.deversoft.android.foodtablet.dao.Tva toadd = new ro.deversoft.android.foodtablet.dao.Tva(tva.getCota(), false, tva.getCodCasa());
            toadd.setId(tva.getId());
            tvaLinkedList.add(toadd);
        }
        return tvaLinkedList;
    }

    @RMI
    public List<ro.deversoft.android.foodtablet.dao.Categorie> getCategorii() {
        return new ArrayList<ro.deversoft.android.foodtablet.dao.Categorie>(this.categoriiHash.values());
    }

    @RMI
    public List<Produs> getProduse() {
        return new ArrayList<Produs>(this.productsHash.values());
    }

    @RMI
    public List<Cod_de_bare_produse> getCoduriBare() {
        return this.coduriList;
    }

    @RMI
    public List<Tip_Plata> getPaymentTypes() {
        LinkedList<Tip_Plata> result = new LinkedList<Tip_Plata>();
        for (TipPlata tipPlata2 : TipPlataProvider.getInstance().getTipPlata()) {
            boolean hasEcrMapping = Validators.correctString(tipPlata2.getEcrMapping());
            Tip_Plata toAdd = new Tip_Plata(tipPlata2.getId(), tipPlata2.getLabel(), hasEcrMapping, tipPlata2.getEcrMapping());
            result.add(toAdd);
        }
        return result;
    }

    @RMI
    public List<Clients> getClients() {
        LinkedList<Clients> result = new LinkedList<Clients>();
        Vector<ClientPromotieView> clientiPromotii = PromotionLogic.getInstance().getPromotiiClient();
        for (ClientPromotieView view : clientiPromotii) {
            Clients c1 = new Clients();
            c1.setId(view.getIdClient());
            c1.setNume(view.getClient());
            c1.setCod_unic(view.getCodStart());
            Logger.logDebug(this, "Trimit client : " + c1.toString());
            result.add(c1);
        }
        return result;
    }

    @RMI
    public List<Promotions> getPromotions() {
        return this.promotii;
    }

    @RMI
    public List<Promotion_items> getPromotionsItems() {
        return this.promotion_items;
    }

    private Enums.tipPerioadaPromo getTipPerioada(PromotionPeriod dbPromoPeriod) {
        switch (dbPromoPeriod.getTip()) {
            case 1: {
                return Enums.tipPerioadaPromo.IntreZile;
            }
            case 2: {
                return Enums.tipPerioadaPromo.IntreOre;
            }
        }
        return Enums.tipPerioadaPromo.Permanent;
    }

    private Enums.tipDiscountPromo getTipDiscount(Promotion promo) {
        switch (promo.getType()) {
            case 1: {
                return Enums.tipDiscountPromo.PretFix;
            }
            case 3: {
                return Enums.tipDiscountPromo.ValFixa;
            }
        }
        return Enums.tipDiscountPromo.Procent;
    }

    @RMI
    public List<Menus> getMeniuri() {
        return this.menus;
    }

    @RMI
    public List<Menu_choice> getMenuChoices() {
        return this.menuChoices;
    }

    @RMI
    public List<Menu_products> getMenuProducts() {
        return this.menuProducts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public String printBonFiscal(Vector<SaleUpper> saleVector, Vector<Payment> paymentVector, Vector<String> comentarii, String chararcter, String orderIdentifier, Integer codOperator, Double reducere, String key) {
        try {
            int clientIndex = 0;
            Vector<Sale> newSales = new Vector<Sale>();
            for (SaleUpper saleUpper : saleVector) {
                Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(saleUpper.getIdProduct());
                Sale newSale = RestLogic.getInstance().buildSaleNoCommit(product, saleUpper.getQuantity(), 0.0, "", -1, -1, -1, -1, -1, System.currentTimeMillis(), saleUpper.getPrice(), "", clientIndex);
                newSales.add(newSale);
            }
            Vector<Plata> plati = new Vector<Plata>();
            for (Payment payment : paymentVector) {
                String tipPlataName = payment.getPayMode();
                TipPlata tp = TipPlataProvider.getInstance().getTipPlataByCodCasa(tipPlataName);
                if (tp == null) {
                    tp = TipPlataProvider.getInstance().getTipPlataByNameNoCommit(tipPlataName);
                }
                if (tp != null) {
                    Plata plata = new Plata(tp.getId(), payment.getSumAmount(), payment.getPayMode(), payment.getProductLine1(), payment.getProductLine2(), clientIndex);
                    plati.add(plata);
                    continue;
                }
                Logger.logWarning(this, "Am primit un payment " + tipPlataName + " suma " + payment.getSumAmount() + " dar nu l-am gasit in server !!");
            }
            ro.atreides.users.User user = null;
            Client client = null;
            int idClient = -1;
            String locatieName = "";
            String tableName = "";
            int idOrder = -1;
            BonFIscalInterface bonfiscalinterface = new BonFIscalInterface(){

                @Override
                public double[] getIstoricIncasariClient(Client c, Date start, Date end) {
                    return new double[0];
                }

                @Override
                public void addPlata(int idOrder, TipPlata tp, double diff, String detalii, int clientIndex) throws SQLException {
                }
            };
            RestLogic.getInstance().printBonFiscalNoArch(newSales, plati, user, client, orderIdentifier, comentarii, idOrder, "", "", bonfiscalinterface, idClient, locatieName, tableName, clientIndex);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                // empty catch block
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public Boolean printOrder(Orders remoteOrder, List<Sales> saleses, String codLocatie, String user, HashMap<String, Double> hashMap, String orderId) {
        String s = "Comanda " + orderId + " cod locatie : " + codLocatie + " user : " + user + " a fost tiparita";
        Logger.logDebug(this, s);
        for (Sales salese : saleses) {
            String s1 = salese.getId_produs().getNume() + " ---- " + salese.getPret_redus();
            Logger.logDebug(this, s1);
        }
        LocatieTableBean bean = this.clientiTableHash.get(codLocatie);
        if (bean != null) {
            try {
                TipPlata defaultTP;
                Promotions remotePromo;
                int idTable = bean.getIdMasa();
                if (idTable <= 0) {
                    String cod = bean.getCodLocatie();
                    Vector<Location> locations = new Vector<Location>();
                    Location loc = RestLogic.getInstance().getLocationByCodNoCommit(cod);
                    locations.add(loc);
                    Table freeTable = RestLogic.getInstance().getFirstFreeTableNoCommit(locations);
                    idTable = freeTable.getId();
                }
                ro.atreides.users.User targetUser = UsersLogic.getInstance().getUserByLoginNoCommit(user);
                Order order = RestLogic.getInstance().newOrderNoCommit(idTable, targetUser.getId(), remoteOrder.isProtocol());
                double totalOrder = 0.0;
                Vector<Sale> goodSales = new Vector<Sale>();
                for (Sales sale1 : saleses) {
                    Produs produs = sale1.getId_produs();
                    String cod = produs.getCod_extern();
                    Product product = NomeclaturaLogic.getInstance().getProductByCodNoCommit(Integer.parseInt(cod));
                    Sale sale = RestLogic.getInstance().buildSale(product, 0.0, sale1.getQuantity(), "", -1, -1, -1, -1, -1, remoteOrder.getClose_date().getTime(), sale1.getPret_redus().floatValue(), "", 0);
                    sale.setPpuOriginal(sale1.getPret_original());
                    double discount = sale1.getPret_original() * sale1.getQuantity() - sale1.getPret_redus() * sale1.getQuantity();
                    sale.setDiscount(discount);
                    totalOrder += (double)sale1.getPret_redus().floatValue() * sale1.getQuantity();
                    goodSales.add(sale);
                }
                for (Sale element : goodSales) {
                    element.setIdOrder(order.getId());
                    RestLogic.getInstance().addSaleNoCommit(element, targetUser.getId());
                }
                if (remoteOrder.getId_client() != null) {
                    Clients remoteClient = remoteOrder.getId_client();
                    Logger.logDebug(this, "Primit client : " + remoteClient.toString());
                    RestLogic.getInstance().setClientAndPromotionForOrderNoCommit(order, remoteClient.getId(), -1);
                }
                if ((remotePromo = remoteOrder.getId_promoO()) != null) {
                    RestLogic.getInstance().setPromotionForOrderNoCommit(order, remotePromo.getId());
                }
                if (order.isProtocol()) {
                    RestLogic.getInstance().recomputePricesNoCommit(order);
                }
                RestLogic.getInstance().closeOrderNoCommit(order, new Timestamp(remoteOrder.getClose_date().getTime()));
                RestLogic.getInstance().setOrderIdentifierNoCommit(order.getId(), codLocatie + "_" + Formatters.currentDateAndTimeForFileSystem.format(remoteOrder.getClose_date()));
                RestLogic.getInstance().updateOrderF(order, true);
                double achitat = 0.0;
                for (String tipPlata2 : hashMap.keySet()) {
                    String s1 = "tipplata: " + tipPlata2 + " valoare " + hashMap.get(tipPlata2);
                    Logger.logDebug(this, s1);
                    TipPlata tp = TipPlataProvider.getInstance().getTipPlataByNameNoCommit(tipPlata2);
                    if (tp != null) {
                        Double val = hashMap.get(tipPlata2);
                        if (val == null) continue;
                        double suma = val;
                        Plata plata = new Plata(tp.getId(), suma, tp.getEcrMapping(), tp.getLabel(), "", 0);
                        RestLogic.getInstance().addPlataToOrderNoCommit(order, plata);
                        achitat += suma;
                        continue;
                    }
                    Logger.logError((Object)this, "TIp plata negasit : " + tipPlata2);
                }
                System.out.println("Total Order : " + totalOrder + " achitat = " + achitat);
                if (Utils.isValueGreaterThanZero(totalOrder - achitat) && (defaultTP = TipPlataProvider.getInstance().getDefaultTipPlataNoCommit()) != null) {
                    Plata plata = new Plata(defaultTP.getId(), totalOrder - achitat, defaultTP.getEcrMapping(), defaultTP.getLabel(), "", 0);
                    RestLogic.getInstance().addPlataToOrderNoCommit(order, plata);
                }
                this.pool.commit();
                Boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
                Boolean bl = false;
                return bl;
            }
            finally {
                this.pool.releaseConnection();
            }
        }
        Logger.logError((Object)this, "Cod locatie incorect : " + codLocatie);
        return false;
    }
}

