/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.android.printserver;

import com.google.code.gsonrmi.annotations.RMI;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.clienti.ClientLogic;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.nomenclatura.Sectie;
import ro.atreides.restaurant.VpConfig;
import ro.atreides.restaurant.base.Bon;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.BonMarcajInterface;
import ro.atreides.restaurant.logic.NotaInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.users.UsersLogic;
import ro.atreides.utils.Client;
import ro.atreides.utils.Location;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.plati.Plata;
import ro.deversoft.android.foodtablet.dao.Clients;
import ro.deversoft.android.foodtablet.dao.Orders;
import ro.deversoft.android.foodtablet.dao.Produs;
import ro.deversoft.android.foodtablet.dao.Sales;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;

public class RealImplPrintServer
extends GSONEntity {
    private static RealImplPrintServer deverFoodGsonServer;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private RealImplPrintServer(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
    }

    public static synchronized RealImplPrintServer getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            deverFoodGsonServer = new RealImplPrintServer(url, serverName, clientName, listeningPort);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return deverFoodGsonServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public Boolean printNota(Orders remoteOrder, String codLocatie, String fullTableName, Collection<Sales> salesList, Boolean groupByClientIndex, Integer clientiIndex, Clients remoteClient, final Collection<ro.deversoft.android.foodtablet.dao.Plata> remotePlati, String key) {
        try {
            NotaInterface nif = new NotaInterface(){

                @Override
                public Vector<Plata> getPlati() {
                    Vector<Plata> plati = new Vector<Plata>();
                    if (remotePlati != null) {
                        for (ro.deversoft.android.foodtablet.dao.Plata remotePlata : remotePlati) {
                            Plata toAdd = new Plata(remotePlata.getTip_plata().getId(), remotePlata.getVal_platita(), "", remotePlata.getTip_plata().getTipPlata(), "", 0);
                            plati.add(toAdd);
                        }
                    }
                    return plati;
                }
            };
            Location locatie = RestLogic.getInstance().getLocationByCodNoCommit(codLocatie);
            int idUser = remoteOrder.getId_user().getId();
            User ospatar = UsersLogic.getInstance().getUserByIdNoCommit(idUser);
            String detaliiNota = "";
            int idPromotion = -1;
            Client client = null;
            if (remoteClient != null) {
                client = ClientLogic.getInstance().getClientByIdNoCommit(remoteClient.getId());
            }
            String adresaClient = "";
            String numeClient = "";
            String telefonClient = "";
            String idOrder = "";
            if (client != null) {
                if (VpConfig.getInstance().notaPrintNumeClient) {
                    numeClient = client.toString();
                }
                if (VpConfig.getInstance().notaPrintTelefonClient) {
                    telefonClient = client.getTelefoane(", ");
                }
            }
            long now = System.currentTimeMillis();
            Vector<Sale> tempSales = new Vector<Sale>();
            for (Sales remoteSale : salesList) {
                int idServire = -1;
                if (remoteSale.getId_servire() != null) {
                    idServire = remoteSale.getId();
                }
                double price = remoteSale.getPret_redus();
                Produs remoteProduct = remoteSale.getId_produs();
                String cod = remoteProduct.getCod_extern();
                Product product = NomeclaturaLogic.getInstance().getProductByCodNoCommit(Integer.parseInt(cod));
                Sale newSale = RestLogic.getInstance().buildSaleNoCommit(product, remoteSale.getQuantity(), 0.0, remoteSale.getMod_preparare(), -1, remoteSale.getPlatouNr(), -1, -1, idServire, now, price, "", clientiIndex);
                tempSales.add(newSale);
            }
            int nrNota = remoteOrder.getId();
            RestLogic.getInstance().printSalesNoarch(tempSales, ospatar, locatie, idOrder + "", detaliiNota, null, remoteOrder.isProtocol(), nrNota, numeClient, telefonClient, adresaClient, nif, fullTableName, new Vector<String>(), idPromotion, groupByClientIndex, clientiIndex, "", "");
            this.pool.commit();
            Boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public Boolean printBonMarcaj(Orders remoteOrder, String codLocatie, String fullTableName, Collection<Sales> salesList, String key) {
        try {
            Object lastServire = null;
            Location locatie = RestLogic.getInstance().getLocationByCodNoCommit(codLocatie);
            BonMarcajInterface bmi = new BonMarcajInterface(){

                @Override
                public void productieAction(Sale sale, String detalii, Client client, String currentServireName, int currentPlatouId, User operator, int idSectie) throws SQLException {
                }

                @Override
                public void blockedStockAction(Sale sale) throws SQLException {
                }

                @Override
                public String getBonName(Bon bon) throws SQLException {
                    return "Nr " + bon.getNrBon();
                }
            };
            long now = System.currentTimeMillis();
            Hashtable nonEmptySectii = new Hashtable();
            for (Sales remoteSale : salesList) {
                Produs remoteProduct = remoteSale.getId_produs();
                ro.deversoft.android.foodtablet.dao.Sectie remoteSectie = remoteProduct.getId_categorie().getId_sectie();
                Sectie localSectie = NomeclaturaLogic.getInstance().getSectieByIdNoCommit(remoteSectie.getId());
                Vector<Sale> tempSales = (Vector<Sale>)nonEmptySectii.get(localSectie);
                if (tempSales == null) {
                    tempSales = new Vector<Sale>();
                    nonEmptySectii.put(localSectie, tempSales);
                }
                double q = remoteSale.getQuantity();
                int idPlatou = remoteSale.getPlatouNr();
                double price = remoteSale.getPret_original();
                String cod = remoteProduct.getCod_extern();
                Product product = NomeclaturaLogic.getInstance().getProductByCodNoCommit(Integer.parseInt(cod));
                String preparare = remoteSale.getMod_preparare();
                int idServire = -1;
                if (remoteSale.getId_servire() != null) {
                    idServire = remoteSale.getId_servire().getId();
                }
                Sale ts = RestLogic.getInstance().buildSaleNoCommit(product, 0.0, q, preparare, -1, idPlatou, -1, -1, idServire, now, price, "", 0);
                tempSales.add(ts);
            }
            int i = 1;
            int max = new Vector(nonEmptySectii.keySet()).size();
            for (Sectie sectie : nonEmptySectii.keySet()) {
                Vector tempSales = (Vector)nonEmptySectii.get(sectie);
                boolean cutter = i == max;
                RestLogic.getInstance().printBonMarcajNoCommit(tempSales, remoteOrder.getId_user().getId(), "", fullTableName, sectie, locatie, null, cutter, remoteOrder.isProtocol(), bmi, new String[]{"", "", ""}, null);
                ++i;
            }
            this.pool.commit();
            Boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            Boolean bl = false;
            return bl;
        }
        finally {
            this.pool.releaseConnection();
        }
    }
}

