/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import ro.deversoft.drivers.datecs.gen3.noarch.Bon;
import ro.deversoft.drivers.datecs.gen3.noarch.LogerInterface;
import ro.deversoft.drivers.datecs.gen3.noarch.QueBoonAbstract;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.display.ClearDisplay;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.display.DisplayHourAndDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.display.DisplayOnLowerLine;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.display.DisplayOnUpperLine;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.display.ShowTextOnDisplay;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.DiagnosticInformation;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.InformationOnSumsAccumulated;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingLastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingStatus;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingTaxRegistration;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.initialization.SettingOperatorName;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.initialization.SettingOperatorPassword;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.DrawerKickout;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.PrintingDiagnosticInformation;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.SeparatorLine;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.SoundSignal;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.DetailFiscalMemoryByClosureDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.DetailFiscalMemoryByClosureNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.ItemsReport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.OperatorReport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.ShortFiscalMemoryByClosureDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.ShortFiscalMemoryByClosureNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports.TaxRatesDuringPeriod;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.CancelReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.ClosingFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.DuplicateReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.OpenFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.PrintFreeFiscalText;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Sale;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Subtotal;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Total;

public abstract class OldProtocolThread
extends Thread {
    private Vector<Command> outQueue = new Vector();
    private boolean conected = true;
    protected boolean mustRun = true;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    private int sequence;
    private Bon currentBon;
    protected String serie;
    private boolean demoMode = false;
    protected LogerInterface logerInterface;
    private QueBoonAbstract bonsQueue;
    protected boolean licensed = true;

    public abstract boolean restartSocket();

    public abstract void licenceDriver();

    public void stopRunning() {
        this.setConnected(false);
        this.mustRun = false;
    }

    private void setConnected(boolean newValue) {
        this.logerInterface.addLog("SET CONNECTED TO : " + newValue);
        this.conected = newValue;
        this.logerInterface.connected(this.conected);
    }

    private boolean isConected() {
        return this.conected;
    }

    private void clearOutQueue() {
        this.outQueue.clear();
        this.logerInterface.addLog("Empty in-memory queue");
    }

    public synchronized void cancelReceipt() {
        CancelReceipt command = new CancelReceipt();
        this.outQueue.add(command);
    }

    public synchronized void printInformationOnSumAccumulated() {
        InformationOnSumsAccumulated command = new InformationOnSumsAccumulated();
        this.outQueue.add(command);
    }

    public synchronized void readingLastDocumentPrinted() {
        ReadingLastDocumentPrinted command = new ReadingLastDocumentPrinted();
        this.outQueue.add(command);
    }

    public synchronized void readingStatus(byte option) {
        ReadingStatus command = new ReadingStatus(option);
        this.outQueue.add(command);
    }

    public synchronized void readingTaxRegistration() {
        ReadingTaxRegistration command = new ReadingTaxRegistration();
        this.outQueue.add(command);
    }

    public synchronized void setOperatorName(int operatorCode, int operatorPassword, String operatorName) {
        SettingOperatorName command = new SettingOperatorName(operatorCode, operatorPassword, operatorName);
        this.outQueue.add(command);
    }

    public synchronized void setOperatorPassword(int operatorCode, int oldPassword, int newPassword) {
        SettingOperatorPassword command = new SettingOperatorPassword(operatorCode, oldPassword, newPassword);
        this.outQueue.add(command);
    }

    public synchronized void drawerKickout() {
        int millisec = 500;
        DrawerKickout command = new DrawerKickout(millisec);
        this.outQueue.add(command);
    }

    public synchronized void printDiagnosticalInformation() {
        PrintingDiagnosticInformation command = new PrintingDiagnosticInformation();
        this.outQueue.add(command);
    }

    public synchronized void soundSignal(int mills, int mHz) {
        SoundSignal command = new SoundSignal(mills, mHz);
        this.outQueue.add(command);
    }

    public synchronized void printDetailFiscalMemoryByClosureDate(Date start, Date end) {
        DetailFiscalMemoryByClosureDate command = new DetailFiscalMemoryByClosureDate(start, end);
        this.outQueue.add(command);
    }

    public synchronized void printDetailFiscalMemoryByClosureNumber(int start, int end) {
        DetailFiscalMemoryByClosureNumber command = new DetailFiscalMemoryByClosureNumber(start, end);
        this.outQueue.add(command);
    }

    public synchronized void printItemsReport(char option, int nrFirstArticle, int nrLastArticle, byte group) {
        ItemsReport command = new ItemsReport(option, nrFirstArticle, nrLastArticle, group);
        this.outQueue.add(command);
    }

    public synchronized void printOperatorsReport() {
        OperatorReport command = new OperatorReport();
        this.outQueue.add(command);
    }

    public synchronized void printShortFiscalMemoryByClosureDate(Date start, Date end) {
        ShortFiscalMemoryByClosureDate command = new ShortFiscalMemoryByClosureDate(start, end);
        this.outQueue.add(command);
    }

    public synchronized void printShortFiscalMemoryByClosureNumber(int startNumber, int endNumber) {
        ShortFiscalMemoryByClosureNumber command = new ShortFiscalMemoryByClosureNumber(startNumber, endNumber);
        this.outQueue.add(command);
    }

    public synchronized void printTaxRatesDruinPeriod(Date start, Date end) {
        TaxRatesDuringPeriod command = new TaxRatesDuringPeriod(start, end);
        this.outQueue.add(command);
    }

    public synchronized void printDuplicateReceipt() {
        DuplicateReceipt command = new DuplicateReceipt(49);
        this.outQueue.add(command);
    }

    public synchronized void showTextOnLowerLine(String text) {
        DisplayOnLowerLine command = new DisplayOnLowerLine(text);
        this.outQueue.add(command);
    }

    public synchronized void showTextOnUpperLine(String text) {
        DisplayOnUpperLine displayOnUpperLine = new DisplayOnUpperLine(text);
        this.outQueue.add(displayOnUpperLine);
    }

    public synchronized void showDateHour() {
        DisplayHourAndDate command = new DisplayHourAndDate();
        this.outQueue.add(command);
    }

    public synchronized void showTextOnDisplay(String text) {
        ShowTextOnDisplay command = new ShowTextOnDisplay(text);
        this.outQueue.add(command);
    }

    public synchronized void clearDisplay() {
        ClearDisplay command = new ClearDisplay();
        this.outQueue.add(command);
    }

    public synchronized void getDate() {
        ReadingDate command = new ReadingDate();
        this.outQueue.add(command);
    }

    public synchronized void getDisgnosticReport() {
        DiagnosticInformation command = new DiagnosticInformation();
        this.outQueue.add(0, command);
    }

    public synchronized void platesteRestTotal() {
        Total totalCommand = new Total(null, null, 'P', null);
        this.outQueue.add(totalCommand);
        this.outQueue.add(new ClosingFiscalReceipt());
    }

    private boolean verificareBonFiscal(Vector<Sale> salesVector) {
        boolean bonCorect = true;
        for (Sale sale : salesVector) {
            double totalValue;
            double pret = sale.getPrice();
            Double redObject = sale.getReducereAbs();
            Double cantitateObject = sale.getQuantity();
            if (redObject == null) continue;
            double reducere = redObject * -1.0;
            double cantitate = 1.0;
            if (cantitateObject != null) {
                cantitate = cantitateObject;
            }
            if (!((totalValue = pret * cantitate) <= reducere)) continue;
            bonCorect = false;
            break;
        }
        return bonCorect;
    }

    public void setDemoMode(boolean demoMode) {
        this.demoMode = demoMode;
    }

    public LogerInterface getLogerInterface() {
        return this.logerInterface;
    }

    public void setLogerInterface(LogerInterface logerInterface) {
        this.logerInterface = logerInterface;
    }

    public synchronized void printFiscalReceipt(Vector<Sale> saleVector, Vector<PrintFreeFiscalText> textVector, Vector<Total> paymentVector, Vector<Subtotal> subtotal, int operatorCode, String operatorPassword, int nrPointOfSale, boolean printInvoice) {
        boolean bonToLong;
        boolean bonCorect = this.verificareBonFiscal(saleVector);
        if (!bonCorect) {
            this.logerInterface.addLog("<Un produs are valoarea mai mica ca reducerea. Bon refuzat!!!");
        }
        if (saleVector != null && saleVector.size() > 0 && saleVector.size() < 360) {
            bonToLong = false;
        } else {
            bonToLong = true;
            this.logerInterface.addLog("<Bonul are mai mult de 360 de produse. Bon refuzat !!!");
        }
        if (!bonToLong && bonCorect) {
            OpenFiscalReceipt openfiscal = new OpenFiscalReceipt(operatorCode, operatorPassword, nrPointOfSale, printInvoice);
            this.outQueue.add(openfiscal);
            ReadingDate getDate = new ReadingDate();
            this.outQueue.add(getDate);
            this.outQueue.addAll(saleVector);
            SeparatorLine command = new SeparatorLine('1');
            this.outQueue.add(command);
            if (subtotal != null && subtotal.size() > 0) {
                this.outQueue.addAll(subtotal);
            }
            if (paymentVector != null && paymentVector.size() > 0) {
                this.outQueue.addAll(paymentVector);
            }
            if (textVector != null && textVector.size() > 0) {
                this.outQueue.addAll(textVector);
            }
            ClosingFiscalReceipt closeFiscal = new ClosingFiscalReceipt();
            this.outQueue.add(closeFiscal);
        }
    }
}

