/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import ro.deversoft.drivers.datecs.gen3.noarch.Bon;
import ro.deversoft.drivers.datecs.gen3.noarch.LogerInterface;
import ro.deversoft.drivers.datecs.gen3.noarch.QueBoonAbstract;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Response;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.dailyClosure.RaportX;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.dailyClosure.RaportZ;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.DiagnosticInformation;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingDate;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.informationToHost.ReadingLastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.CloseNonFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.InternalDebitingCrediting;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.OpenNonFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.PrintNonFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.others.SeparatorLine;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.CancelReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.ClosingFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.DuplicateReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.OpenFiscalReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales.Total;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.dailyClosure.Raport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.DiagnosticResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.InfoCurentReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.LastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.ReadingDateResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.TaxRegistrationNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.CloseNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.DebetingCrediting;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.OpenNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.ItemReportResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.TaxRatesDruingPeriodResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.ClosingFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.OpeningFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.SubtotalResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.TotalResponse;

public abstract class ProtocolThread
extends Thread {
    protected int PERMANENT_ERROR_BON_RETRIES = 1;
    protected int PERMANENT_ERROR_COMMAND_RETRIES = 1;
    private Vector<Command> outQueue1 = new Vector();
    protected boolean mustRun = true;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected QueBoonAbstract bonsQueue;
    protected LogerInterface logerInterface;
    private int sequence = 0;
    private long cleanPipeMillis = 1000L;
    private Bon currentBon;
    private STATE currentState = STATE.MUST_CONNECT;
    public static final SimpleDateFormat ecrDateFormat = new SimpleDateFormat("dd-MM-yy HH:mm:ss");
    private boolean ecrSerieDetected = false;

    public abstract boolean restartSocket();

    public abstract boolean licenceDriver(String var1);

    public void stopRunning() {
        this.setConnected(false);
        this.mustRun = false;
    }

    private void setConnected(boolean newValue) {
        this.logWithState("SET CONNECTED TO : " + newValue);
        this.logerInterface.connected(newValue);
    }

    private STATE checkEcr() {
        Response response = null;
        try {
            this.writeCommand(new DiagnosticInformation(), this.getNextSequence());
            response = this.readResponse();
            if (response != null && response.isTimeout()) {
                return STATE.CONNECTION_LOST;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return STATE.CONNECTION_LOST;
        }
        if (response == null) {
            return STATE.MUST_CLEAN_PIPE;
        }
        if (response.isNakResponse()) {
            this.logWithState("NACK !!");
        } else if (response.isCorectResponse()) {
            Vector<String> allErrors;
            Vector<String> allWarnings;
            boolean cmdNotAllowed = false;
            boolean noPaperNow = false;
            boolean fiscalReceiptOpen = false;
            Vector<String> allInfos = response.getInfos();
            if (allInfos.size() > 0) {
                for (String message : allInfos) {
                    this.logWithState("INFO : " + message);
                    fiscalReceiptOpen = message.equalsIgnoreCase("(INFO) A fiscal receipt is open.") || fiscalReceiptOpen;
                }
            }
            if ((allWarnings = response.getWarnings()).size() > 0) {
                for (String message : allWarnings) {
                    this.logWithState("WARNING : " + message);
                }
            }
            if ((allErrors = response.getErrors()).size() > 0) {
                for (String message : allErrors) {
                    this.logWithState("ERROR/WARNING : " + message);
                    cmdNotAllowed = message.equalsIgnoreCase("Command cannot be performed in current fiscal mode") || cmdNotAllowed;
                    noPaperNow = message.equalsIgnoreCase("No paper.") || noPaperNow;
                }
            }
            if (cmdNotAllowed || noPaperNow || fiscalReceiptOpen) {
                if (noPaperNow) {
                    return STATE.RECEIVED_NO_PAPER_ERR;
                }
                if (fiscalReceiptOpen) {
                    this.outQueue1.clear();
                    if (this.currentBon != null) {
                        this.currentBon.increaseErrCount();
                    }
                    this.currentBon = null;
                    return STATE.MUST_UNLOCK_ECR;
                }
                if (cmdNotAllowed) {
                    return STATE.RECEIVED_CMD_NOT_ALLOWED_ERR;
                }
            } else {
                this.logWithState("NO ERRORS :) ");
                Object object = Response.buildResponse(response.getData());
                if (object != null) {
                    this.callHandlersForResponse(response, object, null);
                }
            }
        } else {
            this.logWithState("Unknown state : start clean");
            return STATE.MUST_CLEAN_PIPE;
        }
        if (this.ecrSerieDetected) {
            return STATE.WAITING_FOR_COMMANDS;
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return STATE.MUST_CHECK_ECR;
    }

    public void printNonFiscal(Vector<String> lines) {
        Bon bon = new Bon("Nefiscal " + new Date(), "Comanda");
        OpenNonFiscalReceipt openNonFiscal = new OpenNonFiscalReceipt();
        bon.addCommand(openNonFiscal);
        for (String s : lines) {
            PrintNonFiscalReceipt textPrint = new PrintNonFiscalReceipt(s);
            bon.addCommand(textPrint);
        }
        SeparatorLine command = new SeparatorLine('1');
        bon.addCommand(command);
        CloseNonFiscalReceipt closeNonFiscal = new CloseNonFiscalReceipt();
        closeNonFiscal.setLast(true);
        bon.addCommand(closeNonFiscal);
        this.bonsQueue.addBon(bon);
    }

    private STATE sendCommandsFromQueue() {
        if (this.outQueue1.size() > 0) {
            Command currentCommand = this.outQueue1.get(0);
            if (currentCommand.getErrCount() >= this.PERMANENT_ERROR_COMMAND_RETRIES) {
                this.outQueue1.clear();
                return STATE.WAITING_FOR_COMMANDS;
            }
            Response response = null;
            try {
                this.writeCommand(currentCommand, this.getNextSequence());
                response = this.readResponse();
                if (response != null && response.isTimeout()) {
                    return STATE.CONNECTION_LOST;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return STATE.CONNECTION_LOST;
            }
            if (response == null) {
                return STATE.MUST_CLEAN_PIPE;
            }
            if (response.isNakResponse()) {
                this.logWithState("NACK !!");
            } else if (response.isCorectResponse()) {
                Vector<String> allErrors;
                Vector<String> allWarnings;
                boolean cmdNotAllowed = false;
                boolean receiptOpen = false;
                boolean noPaperNow = false;
                Vector<String> allInfos = response.getInfos();
                if (allInfos.size() > 0) {
                    for (String message : allInfos) {
                        this.logWithState("INFO : " + message);
                        receiptOpen = message.equalsIgnoreCase("(INFO) A fiscal receipt is open.") || receiptOpen;
                    }
                }
                if ((allWarnings = response.getWarnings()).size() > 0) {
                    for (String message : allWarnings) {
                        this.logWithState("WARNING : " + message);
                    }
                }
                if ((allErrors = response.getErrors()).size() > 0) {
                    for (String message : allErrors) {
                        this.logWithState("ERROR : " + message);
                        cmdNotAllowed = message.equalsIgnoreCase("Command cannot be performed in current fiscal mode") || cmdNotAllowed;
                        noPaperNow = message.equalsIgnoreCase("No paper.") || noPaperNow;
                    }
                    if (noPaperNow) {
                        return STATE.RECEIVED_NO_PAPER_ERR;
                    }
                    if (cmdNotAllowed) {
                        if (receiptOpen) {
                            this.logWithState("CMD NOT ALLOWED AND RECEIPT OPEN !!");
                        }
                        if (this.currentBon != null) {
                            this.currentBon.increaseErrCount();
                            currentCommand.increaseErrCount();
                            if (this.isBonPermanentError(this.currentBon)) {
                                this.removeBonFromQueue(this.currentBon, "Too many errors !");
                                this.currentBon = null;
                            }
                        }
                        return STATE.RECEIVED_CMD_NOT_ALLOWED_ERR;
                    }
                } else {
                    Object object;
                    this.logWithState("NO ERRORS :) ");
                    this.outQueue1.remove(0);
                    Bon notifyBon = this.currentBon;
                    if (this.currentBon != null && currentCommand.isLast()) {
                        this.removeBonFromQueue(this.currentBon, null);
                        this.currentBon = null;
                    }
                    if ((object = Response.buildResponse(response.getData())) != null) {
                        this.callHandlersForResponse(response, object, notifyBon);
                    } else {
                        this.logWithState("ACK OR UNKNOWN RESPONSE ");
                    }
                }
            } else {
                this.logWithState("NOT A CORRECT RESPONSE ");
            }
            return STATE.SENDING;
        }
        return STATE.WAITING_FOR_COMMANDS;
    }

    private boolean removeBonFromQueue(Bon currentBon, String errorReason) {
        if (errorReason != null) {
            if (!this.logerInterface.addLogAndASKUser("BONUL ARE DEJA " + this.PERMANENT_ERROR_BON_RETRIES + " INCERCARI DE TIPARIRE . VREI SA MAI INCERC (daca apesi NU voi sari peste acest bon) ")) {
                this.logWithState("Bonul s-a sters din fisierul 'outQue'.  Reason : " + errorReason + " . Bon follows " + currentBon + " \n");
                new Exception().printStackTrace();
                this.bonsQueue.removeBon(currentBon);
                return true;
            }
            this.logerInterface.addLogAndNotifyUser("REMEDIAZA CAUZA SI APASA OK . DACA PROBLEMA PERSISTA SARI PESTE BON ");
            currentBon.clearErrors();
            this.bonsQueue.syncMemoryQueueToDisk();
            return false;
        }
        this.logWithState("Bonul s-a sters din fisierul 'outQue'.  Reason : normal operation. Bon follows " + currentBon + "\n");
        this.bonsQueue.removeBon(currentBon);
        return true;
    }

    private void logWithState(String message) {
        this.logerInterface.addLog((Object)((Object)this.currentState) + ": " + message);
    }

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        this.currentState = STATE.MUST_CONNECT;
        while (this.mustRun) {
            switch (this.currentState) {
                case MUST_CONNECT: {
                    boolean status = this.restartSocket();
                    this.setConnected(status);
                    if (status) {
                        this.currentState = STATE.MUST_CLEAN_PIPE;
                        this.logWithState("Connected !");
                        break;
                    }
                    this.logerInterface.addLogAndNotifyUser("CONFIGURARE ERONATA PORT SAU PORT INDISPONIBIL ! Remediati si apasati OK !");
                    this.currentState = STATE.MUST_CONNECT;
                    break;
                }
                case MUST_CLEAN_PIPE: {
                    this.currentState = this.cleanPipe();
                    break;
                }
                case MUST_CHECK_ECR: {
                    this.currentState = this.checkEcr();
                    break;
                }
                case RECEIVED_NO_PAPER_ERR: {
                    this.logerInterface.addLogAndNotifyUser("Lipsa hartie Casa marcat. Apasa OK dupa ce schimbi hartia !");
                    this.currentState = STATE.MUST_CHECK_ECR;
                    break;
                }
                case RECEIVED_CMD_NOT_ALLOWED_ERR: {
                    this.logWithState("CMD NOT ALLOWED : MOD FISCAL INCORECT sau GENERAL ERROR !!");
                    this.logerInterface.addLogAndNotifyUser("Comanda nepermisa - DEPASIRE 24h ( Z nescos ) sau MOD FISCAL INCORECT sau EROARE DE COMANDA !");
                    this.currentState = STATE.MUST_UNLOCK_ECR;
                    break;
                }
                case RECEIVED_FISCAL_RECEIPT_OPEN_ERR: {
                    this.currentState = STATE.MUST_UNLOCK_ECR;
                    break;
                }
                case MUST_UNLOCK_ECR: {
                    this.currentState = this.unlockEcr();
                    break;
                }
                case CONNECTION_LOST: {
                    this.logWithState(" > CONNECTION LOST ");
                    this.logerInterface.addLogAndNotifyUser("Casa de marcat NECONECTATA sau INCORECT CONFIGURATA ! Remediati si apasati OK !");
                    this.currentState = STATE.MUST_CONNECT;
                    break;
                }
                case WAITING_FOR_COMMANDS: {
                    this.currentState = this.scheduleNextBon();
                    break;
                }
                case SENDING: {
                    this.currentState = this.sendCommandsFromQueue();
                }
            }
        }
        System.out.println("Stopping thread : " + this.getName());
    }

    private STATE scheduleNextBon() {
        if (this.outQueue1.size() <= 0) {
            while (this.bonsQueue.getQueBoonSize() > 0) {
                Bon currentBon = (Bon)this.bonsQueue.getBon();
                if (currentBon == null || this.isBonPermanentError(currentBon) && this.removeBonFromQueue(currentBon, "BON IN COADA CU EROARE PERMANENTA !")) continue;
                this.outQueue1.addAll(currentBon.getBonVector());
                this.currentBon = currentBon;
                return STATE.SENDING;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return STATE.WAITING_FOR_COMMANDS;
        }
        return STATE.SENDING;
    }

    private boolean isBonPermanentError(Bon currentBon) {
        return currentBon.getErrorCount() >= this.PERMANENT_ERROR_BON_RETRIES;
    }

    public synchronized STATE unlockEcr() {
        this.logWithState("Incepem procedura de anulare");
        try {
            this.writeCommand(new CancelReceipt(), this.getNextSequence());
            Response response = this.readResponse();
            if (response != null && response.isTimeout()) {
                return STATE.CONNECTION_LOST;
            }
            boolean cancelReceiptOk = this.isUnlockCommandSuccessfull(response);
            if (cancelReceiptOk) {
                this.outQueue1.clear();
                return STATE.MUST_CHECK_ECR;
            }
            this.writeCommand(new ClosingFiscalReceipt(), this.getNextSequence());
            response = this.readResponse();
            if (response != null && response.isTimeout()) {
                return STATE.CONNECTION_LOST;
            }
            boolean closeOk = this.isUnlockCommandSuccessfull(response);
            if (closeOk) {
                this.outQueue1.clear();
                this.currentBon = null;
                return STATE.MUST_CHECK_ECR;
            }
            Total totalCommand = new Total(null, null, 'P', null);
            this.writeCommand(totalCommand, this.getNextSequence());
            response = this.readResponse();
            if (response != null && response.isTimeout()) {
                return STATE.CONNECTION_LOST;
            }
            boolean totalSucceded = this.isUnlockCommandSuccessfull(response);
            if (totalSucceded) {
                this.writeCommand(new ClosingFiscalReceipt(), this.getNextSequence());
                response = this.readResponse();
                if (response != null && response.isTimeout()) {
                    return STATE.CONNECTION_LOST;
                }
                closeOk = this.isUnlockCommandSuccessfull(response);
                if (closeOk) {
                    Object object;
                    Command currentCommand = null;
                    if (this.outQueue1.size() > 0) {
                        currentCommand = this.outQueue1.remove(0);
                    }
                    Bon notifyBon = this.currentBon;
                    if (this.currentBon != null) {
                        this.removeBonFromQueue(this.currentBon, null);
                        this.currentBon = null;
                    }
                    if ((object = Response.buildResponse(response.getData())) != null) {
                        this.callHandlersForResponse(response, object, notifyBon);
                    } else {
                        this.logWithState("ACK OR UNKNOWN RESPONSE ");
                    }
                    return STATE.MUST_CHECK_ECR;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return STATE.CONNECTION_LOST;
        }
        return STATE.MUST_CHECK_ECR;
    }

    private boolean isUnlockCommandSuccessfull(Response response) {
        Vector<String> allErrors;
        Vector<String> allWarnings;
        boolean cmdNotAllowed = false;
        boolean receiptOpen = false;
        Vector<String> allInfos = response.getInfos();
        if (allInfos.size() > 0) {
            for (String message : allInfos) {
                this.logWithState("INFO : " + message);
                receiptOpen = message.equalsIgnoreCase("(INFO) A fiscal receipt is open.") || receiptOpen;
            }
        }
        if ((allWarnings = response.getWarnings()).size() > 0) {
            for (String message : allWarnings) {
                this.logWithState("WARNING : " + message);
            }
        }
        if ((allErrors = response.getErrors()).size() > 0) {
            for (String message : allErrors) {
                this.logWithState("ERROR : " + message);
                cmdNotAllowed = message.equalsIgnoreCase("Command cannot be performed in current fiscal mode") || cmdNotAllowed;
            }
            if (cmdNotAllowed && receiptOpen) {
                this.logWithState("CMD NOT ALLOWED AND RECEIPT OPEN !!");
                return false;
            }
        }
        return true;
    }

    private STATE cleanPipe() {
        StringBuilder pipeCleanedLog = new StringBuilder();
        try {
            long lastRead = System.currentTimeMillis();
            while (lastRead + this.cleanPipeMillis > System.currentTimeMillis()) {
                int bytesReady = this.inputStream.available();
                if (bytesReady <= 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                lastRead = System.currentTimeMillis();
                byte[] data = new byte[bytesReady];
                int actuallyRead = this.inputStream.read(data);
                for (int i = 0; i < actuallyRead; ++i) {
                    pipeCleanedLog.append(Integer.toHexString(data[i])).append(" ");
                }
            }
            this.logWithState("PipeCleaned [" + pipeCleanedLog.toString() + " ]");
        }
        catch (Exception e) {
            this.logWithState(e.getMessage());
            e.printStackTrace();
            return STATE.MUST_CONNECT;
        }
        return STATE.MUST_CHECK_ECR;
    }

    private synchronized int getNextSequence() {
        ++this.sequence;
        if (this.sequence >= 128) {
            this.sequence = 1;
        }
        return this.sequence;
    }

    private synchronized int getCurrentSequence() {
        return this.sequence;
    }

    private void writeCommand(Command command, int sequence) throws IOException {
        byte[] bytes = command.getBytes(sequence);
        byte[] dataUtil = new byte[bytes.length - 10];
        System.arraycopy(bytes, 4, dataUtil, 0, dataUtil.length);
        StringBuilder stringBuilder = new StringBuilder();
        String dataStream = Utils.getStringFromAscii(dataUtil);
        stringBuilder.append("(send cmd) >> " + command.getClass().getSimpleName() + " " + "(parameters send) > " + dataStream + " [");
        for (byte aByte : bytes) {
            stringBuilder.append(Integer.toHexString(aByte)).append(" ");
        }
        stringBuilder.append("]\n\n");
        this.logWithState(stringBuilder.toString());
        this.outputStream.write(bytes, 0, bytes.length);
        this.outputStream.flush();
    }

    private int waitUntilAllBytesAppearOrTimeout(InputStream inputStream, int howManyBytes, long timeoutInMillis) throws IOException {
        int bytesReady = -1;
        long lastRead = System.currentTimeMillis();
        while (lastRead + timeoutInMillis > System.currentTimeMillis() && (bytesReady = inputStream.available()) < howManyBytes) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return bytesReady;
    }

    /*
     * Unable to fully structure code
     */
    private Response readResponse() throws IOException {
        response = null;
        receivedSyn = false;
        do {
            block15: {
                block14: {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(" (response) << ");
                    receivedSyn = false;
                    bytesExpected = 1;
                    bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                    if (bytesReady >= bytesExpected) break block14;
                    this.logWithState("TIMEOUT FIRST BYTE : Expected to read " + bytesExpected + " but found " + bytesReady);
                    response = new Response();
                    response.setTimeout(true);
                    break block15;
                }
                b = this.inputStream.read();
                switch (b) {
                    case 21: {
                        stringBuilder.append(" NAK ");
                        response = new Response();
                        response.setNakResponse(true);
                        break;
                    }
                    case 22: {
                        receivedSyn = true;
                        break;
                    }
                    case 1: {
                        str = Integer.toHexString(1);
                        stringBuilder.append(str).append(" ");
                        length = this.inputStream.read();
                        stringBuilder.append(Integer.toHexString(length)).append(" ");
                        sequence = this.inputStream.read() - 32;
                        stringBuilder.append(Integer.toHexString(sequence + 32)).append(" ");
                        expectedSequence = this.getCurrentSequence();
                        if (sequence != expectedSequence) {
                            data = "OUT OF SEQUENCE !!! ( our sequence : " + expectedSequence + " ecr sequence : " + sequence;
                            this.logWithState((String)data);
                        }
                        if ((bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected = length - 32 - 10, 10000L)) >= bytesExpected) ** GOTO lbl46
                        this.logWithState("TIMEOUT PACKAGE BYTES : Expected to read " + bytesExpected + " but found " + bytesReady);
                        response = new Response();
                        response.setTimeout(true);
                        ** GOTO lbl125
lbl46:
                        // 1 sources

                        data = new byte[bytesExpected];
                        this.inputStream.read((byte[])data);
                        for (Object b1 : data) {
                            stringBuilder.append(Integer.toHexString((int)b1)).append(" ");
                        }
                        bytesExpected = 1;
                        bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                        if (bytesReady >= bytesExpected) ** GOTO lbl60
                        this.logWithState("TIMEOUT SEPARATOR : Expected to read " + bytesExpected + " but found " + bytesReady);
                        response = new Response();
                        response.setTimeout(true);
                        ** GOTO lbl125
lbl60:
                        // 1 sources

                        separator = this.inputStream.read();
                        if (separator != 4) {
                            this.logWithState("SEPARATOR : Expected to read 4 but found " + separator);
                        }
                        stringBuilder.append(Integer.toHexString(separator)).append(" ");
                        bytesExpected = 6;
                        bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                        if (bytesReady >= bytesExpected) ** GOTO lbl72
                        this.logWithState("TIMEOUT STATUS BYTES : Expected to read " + bytesExpected + " but found " + bytesReady);
                        response = new Response();
                        response.setTimeout(true);
                        ** GOTO lbl125
lbl72:
                        // 1 sources

                        status = new byte[bytesExpected];
                        this.inputStream.read(status, 0, status.length);
                        for (byte statu : status) {
                            stringBuilder.append(Integer.toHexString(statu));
                            stringBuilder.delete(stringBuilder.length() - 8, stringBuilder.length() - 2);
                            stringBuilder.append(" ");
                        }
                        bytesExpected = 1;
                        bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                        if (bytesReady >= bytesExpected) ** GOTO lbl90
                        this.logWithState("TIMEOUT POSTAMBLE : Expected to read " + bytesExpected + " but found " + bytesReady);
                        response = new Response();
                        response.setTimeout(true);
                        ** GOTO lbl125
lbl90:
                        // 1 sources

                        postamble = this.inputStream.read();
                        if (postamble != 5) {
                            this.logWithState("POSTAMBLE : Expected to read 5 but found " + postamble);
                        }
                        stringBuilder.append(Integer.toHexString(postamble)).append(" ");
                        bytesExpected = 4;
                        bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                        if (bytesReady >= bytesExpected) ** GOTO lbl102
                        this.logWithState("TIMEOUT CRC BYTES : Expected to read " + bytesExpected + " but found " + bytesReady);
                        response = new Response();
                        response.setTimeout(true);
                        ** GOTO lbl125
lbl102:
                        // 1 sources

                        crc = new byte[bytesExpected];
                        this.inputStream.read(crc);
                        for (byte b1 : crc) {
                            stringBuilder.append(Integer.toHexString(b1)).append(" ");
                        }
                        bytesExpected = 1;
                        bytesReady = this.waitUntilAllBytesAppearOrTimeout(this.inputStream, bytesExpected, 10000L);
                        if (bytesReady < bytesExpected) {
                            this.logWithState("TIMEOUT END SEPARATOR : Expected to read " + bytesExpected + " but found " + bytesReady);
                            response = new Response();
                            response.setTimeout(true);
                        } else {
                            endSeparator = this.inputStream.read();
                            stringBuilder.append(Integer.toHexString(endSeparator));
                            response = new Response((byte[])data, status);
                            newCrc = response.getCrc(sequence);
                            equal = Utils.verifyByteArray(newCrc, crc);
                            if (equal) break;
                            this.logWithState("WARNING : CRC ERROR");
                            break;
                        }
                    }
lbl125:
                    // 7 sources

                    default: {
                        response = null;
                    }
                }
            }
            stringBuilder.append("\n");
            if (receivedSyn) continue;
            this.logWithState(stringBuilder.toString());
        } while (receivedSyn);
        return response;
    }

    private void callHandlersForResponse(Response response, Object object, Bon currentBon) {
        switch (response.getTipRaspuns()) {
            case 15: {
                DiagnosticResponse diagnosticResponse = (DiagnosticResponse)object;
                String registrationNumber = diagnosticResponse.getNumberFiscalModule();
                if (registrationNumber != null) {
                    String serie = registrationNumber.substring(registrationNumber.length() - 6);
                    this.logerInterface.translateDiagnostic(diagnosticResponse);
                    if (!this.licenceDriver(serie)) break;
                    this.ecrSerieDetected = true;
                    break;
                }
                this.logWithState("REGISTRATION NUMBER IS NULL !!");
                break;
            }
            case 1: {
                Raport raport = (Raport)object;
                this.logerInterface.translateRaportRaspuns(raport);
                break;
            }
            case 2: {
                InfoCurentReceipt infoCurentReceipt = (InfoCurentReceipt)object;
                this.logerInterface.translateInfoCurentReceipt(infoCurentReceipt);
                break;
            }
            case 3: {
                LastDocumentPrinted lastDocumentPrinted = (LastDocumentPrinted)object;
                String key = null;
                if (currentBon != null) {
                    key = currentBon.getKey();
                }
                boolean lastBon = this.bonsQueue.getQueBoonSize() <= 0;
                this.logerInterface.translateLastDocumentPrint(lastDocumentPrinted, key, lastBon);
                break;
            }
            case 4: {
                TaxRegistrationNumber taxRegistrationNumber = (TaxRegistrationNumber)object;
                this.logerInterface.translateTaxRegistrationNumber(taxRegistrationNumber);
                break;
            }
            case 5: {
                CloseNonFiscalReceiptResponse closeNonFiscalReceiptResponse = (CloseNonFiscalReceiptResponse)object;
                this.logerInterface.translateCloseNonFiscalReceipt(closeNonFiscalReceiptResponse);
                break;
            }
            case 14: {
                ReadingDateResponse getDateResponse = (ReadingDateResponse)object;
                this.logerInterface.translateGetDateRaspuns(getDateResponse);
                break;
            }
            case 6: {
                DebetingCrediting debetingCrediting = (DebetingCrediting)object;
                this.logerInterface.translateDebitingCrediting(debetingCrediting);
                break;
            }
            case 7: {
                OpenNonFiscalReceiptResponse openNonFiscalReceiptResponse = (OpenNonFiscalReceiptResponse)object;
                this.logerInterface.translateOpenNonFiscalReceipt(openNonFiscalReceiptResponse);
                break;
            }
            case 8: {
                ItemReportResponse itemReportResponse = (ItemReportResponse)object;
                this.logerInterface.translateItemReport(itemReportResponse);
                break;
            }
            case 9: {
                TaxRatesDruingPeriodResponse taxRatesDruingPeriodResponse = (TaxRatesDruingPeriodResponse)object;
                this.logerInterface.translateTaxRateDruingPeriod(taxRatesDruingPeriodResponse);
                break;
            }
            case 10: {
                ClosingFiscalReceiptResponse closingFiscalReceiptResponse = (ClosingFiscalReceiptResponse)object;
                this.logerInterface.translateClosingFiscalReceipt(closingFiscalReceiptResponse);
                break;
            }
            case 11: {
                OpeningFiscalReceiptResponse openingFiscalReceiptResponse = (OpeningFiscalReceiptResponse)object;
                this.logerInterface.translateOpeningFiscalReceipt(openingFiscalReceiptResponse);
                break;
            }
            case 12: {
                SubtotalResponse subtotalResponse = (SubtotalResponse)object;
                this.logerInterface.translateSubtotal(subtotalResponse);
                break;
            }
            case 13: {
                TotalResponse total = (TotalResponse)object;
                this.logerInterface.translateTotal(total);
            }
        }
    }

    public synchronized void addBon(Vector<Command> content, String key) {
        Bon bon1 = new Bon(key, "Comanda");
        OpenFiscalReceipt command = new OpenFiscalReceipt(1, "1", 1, false);
        bon1.addCommand(command);
        ReadingDate getDate = new ReadingDate();
        bon1.addCommand(getDate);
        for (Command command1 : content) {
            bon1.addCommand(command1);
        }
        ClosingFiscalReceipt close = new ClosingFiscalReceipt();
        close.setLast(true);
        bon1.addCommand(close);
        this.bonsQueue.addBon(bon1);
        Bon bon2 = new Bon(key, "Feedback");
        ReadingLastDocumentPrinted getNrBon = new ReadingLastDocumentPrinted();
        getNrBon.setLast(true);
        bon2.addCommand(getNrBon);
        this.bonsQueue.addBon(bon2);
    }

    public Bon prepareRaportX() {
        RaportX raportX = new RaportX();
        Bon b = new Bon("X_" + new Date(), "Comanda");
        b.addCommand(raportX);
        raportX.setLast(true);
        return b;
    }

    public Bon prepareRaportZ() {
        RaportZ raportZ = new RaportZ();
        Bon b = new Bon("Z_" + new Date(), "Comanda");
        b.addCommand(raportZ);
        raportZ.setLast(true);
        return b;
    }

    public Bon prepareDebitingCrediting(double amount) {
        InternalDebitingCrediting command = new InternalDebitingCrediting(amount);
        Bon b = new Bon("Credit/Debit " + amount + " " + new Date(), "Comanda");
        b.addCommand(command);
        command.setLast(true);
        return b;
    }

    public Bon prepareDuplicat() {
        Bon b = new Bon("Duplicat_" + new Date(), "Comanda");
        DuplicateReceipt command = new DuplicateReceipt(49);
        b.addCommand(command);
        command.setLast(true);
        return b;
    }

    public synchronized void printAuxiliaryBon(Bon b) {
        this.bonsQueue.addBon(b);
    }

    public int getUnprintedBons() {
        return this.bonsQueue.getQueBoonSize();
    }

    private static enum STATE {
        MUST_CHECK_ECR,
        MUST_CLEAN_PIPE,
        MUST_CONNECT,
        CONNECTION_LOST,
        WAITING_FOR_COMMANDS,
        SENDING,
        RECEIVED_SYN,
        RECEIVED_NO_PAPER_ERR,
        RECEIVED_FISCAL_RECEIPT_OPEN_ERR,
        RECEIVED_CMD_NOT_ALLOWED_ERR,
        MUST_UNLOCK_ECR;

    }
}

