/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.deversoft.drivers.datecs.gen3.noarch.Enums;

public class Utils {
    public static final DecimalFormat PRICE_FORMAT = new DecimalFormat("###0.##");
    public static final DecimalFormat QUANTITY_FORMAT = new DecimalFormat("###0.###");
    public static final SimpleDateFormat DATA_FORMAT = new SimpleDateFormat("ddMMyy");
    public static final double ZERO_VALUES = 1.0E-4;

    public static boolean isValueZero(double value) {
        return value > -1.0E-4 && value < 1.0E-4;
    }

    public static byte[] getAsciiCod(String line) {
        byte[] data = new byte[line.length()];
        for (int i = 0; i < line.length(); ++i) {
            byte asciiCod;
            char c = line.charAt(i);
            data[i] = asciiCod = (byte)c;
        }
        return data;
    }

    public static String getStringFromAscii(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            char c = (char)aByte;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static byte[] calcCRC(byte[] bytes) {
        int i;
        byte[] crc = new byte[]{48, 48, 48, 48};
        int sum = 0;
        for (i = 1; i < bytes.length - 5; ++i) {
            System.out.print(bytes[i] + " ");
            if (bytes[i] < 0) {
                sum += bytes[i] + 256;
                continue;
            }
            sum += bytes[i];
        }
        sum %= 65536;
        i = crc.length - 1;
        while (sum > 0) {
            byte digit = (byte)(sum % 16);
            crc[i] = (byte)(digit + 48);
            sum /= 16;
            --i;
        }
        return crc;
    }

    public static byte[] getBinary(int nr) {
        byte[] binary = new byte[8];
        int i = 0;
        while (nr > 0) {
            byte digit;
            binary[i] = digit = (byte)(nr % 2);
            nr /= 2;
            ++i;
        }
        return binary;
    }

    public static boolean verifyByteArray(byte[] byteArray1, byte[] bytesArray2) {
        boolean equal = true;
        int i = 0;
        for (byte byte1 : byteArray1) {
            if (byte1 != bytesArray2[i]) {
                equal = false;
                break;
            }
            ++i;
        }
        return equal;
    }

    public static char[] getAllTaxType() {
        char[] taxList = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H'};
        return taxList;
    }

    public static Date convertStringtoDate(String string) {
        Date returnDate = null;
        try {
            returnDate = new SimpleDateFormat("ddMMyyyy", Locale.ROOT).parse(string);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return returnDate;
    }

    public static boolean isOn(int bytE, int poz) {
        boolean on = false;
        byte[] binary = Utils.getBinary(256 + bytE);
        if (binary[poz] == 1) {
            on = true;
        }
        return on;
    }

    public static String[] cutTextForLength(int length, String text) {
        int textLength = text.length();
        int stringArrayLength = textLength / length;
        if (textLength % length > 0) {
            ++stringArrayLength;
        }
        String[] textArray = new String[stringArrayLength];
        for (int i = 0; i < stringArrayLength; ++i) {
            int indexText = i * length;
            int indexTextBreak = text.substring(indexText).length() < length ? indexText + text.substring(indexText).length() : indexText + length;
            textArray[i] = text.substring(indexText, indexTextBreak);
        }
        return textArray;
    }

    public static String getStackTrace(Throwable aThrowable) {
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        aThrowable.printStackTrace(printWriter);
        return ((Object)result).toString();
    }

    public static char selectPayMode(String tipPlata_s) {
        char c = 'P';
        if (tipPlata_s.equalsIgnoreCase(Enums.tipPlata.Coupon.getName())) {
            c = 'J';
        }
        if (tipPlata_s.equalsIgnoreCase(Enums.tipPlata.Check.getName())) {
            c = 'D';
        }
        if (tipPlata_s.equalsIgnoreCase(Enums.tipPlata.Voucher.getName())) {
            c = 'I';
        }
        if (tipPlata_s.equalsIgnoreCase(Enums.tipPlata.CreditCard.getName())) {
            c = 'N';
        }
        if (tipPlata_s.equalsIgnoreCase(Enums.tipPlata.DebitCard.getName())) {
            c = 'C';
        }
        System.out.println("TEST PayMOde" + tipPlata_s + " : " + c);
        return c;
    }

    public static Vector<String> splitString(String toSplit, char separator) {
        StringTokenizer token = new StringTokenizer(toSplit, "" + separator);
        Vector<String> result = new Vector<String>();
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            result.add(s);
        }
        return result;
    }
}

