/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch;

import java.text.ParseException;
import ro.deversoft.utils.noarch.Formatters;

public class Validators {
    public static boolean correctString(String s) {
        return s != null && s.length() > 0;
    }

    public static boolean correctDouble(String toCheck) {
        if (Validators.correctString(toCheck)) {
            try {
                Double.parseDouble(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static boolean correctInteger(String toCheck) {
        if (Validators.correctString(toCheck)) {
            try {
                Validators.parseIntNoThousandSeparator(toCheck);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static int parseIntNoThousandSeparator(String toCheck) throws NumberFormatException {
        try {
            return Formatters.NUMBER_0DECIMALS.parse(toCheck).intValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }
}

