/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands;

import java.io.Serializable;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;

public abstract class Command
implements Serializable {
    private int errCount = 0;
    private static final byte SENT_CMD_LENGTH = 9;
    private byte[] crc;
    protected static final long serialVersionUID = -1436793500034970879L;
    private boolean isLast;

    protected Command() {
    }

    public byte[] getBytes(int sequence) {
        byte[] data = this.buildData();
        byte[] bytes = new byte[9 + data.length];
        bytes[0] = 1;
        bytes[1] = (byte)(32 + (bytes.length - 6));
        bytes[2] = (byte)(32 + sequence);
        System.arraycopy(data, 0, bytes, 3, data.length);
        bytes[bytes.length - 6] = 5;
        byte[] crc = Utils.calcCRC(bytes);
        this.crc = crc;
        System.arraycopy(crc, 0, bytes, bytes.length - 5, crc.length);
        bytes[bytes.length - 1] = 3;
        return bytes;
    }

    public byte[] getCrc(int sequence) {
        this.getBytes(sequence);
        return this.crc;
    }

    protected abstract byte[] buildData();

    public void increaseErrCount() {
        ++this.errCount;
    }

    public int getErrCount() {
        return this.errCount;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void setLast(boolean last) {
        this.isLast = last;
    }

    public void clearErrors() {
        this.errCount = 0;
    }
}

