/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands.request.reports;

import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;

public class ItemsReport
extends Command {
    private static byte CMD = (byte)111;
    private char option;
    private int start;
    private int end;
    private Byte group;

    public ItemsReport(char option, int start, int end, Byte group) {
        this.option = option;
        this.start = start;
        this.end = end;
        this.group = group;
        this.getBytes(0);
    }

    @Override
    protected byte[] buildData() {
        int lengthOfData = 3;
        byte[] startAscii = Utils.getAsciiCod(String.valueOf(this.start));
        byte[] endAscii = Utils.getAsciiCod(String.valueOf(this.end));
        if (startAscii.length > 0) {
            lengthOfData += startAscii.length;
            ++lengthOfData;
            lengthOfData += endAscii.length;
        }
        byte[] groupAscii = null;
        if (this.group != null) {
            groupAscii = Utils.getAsciiCod(String.valueOf(this.group));
            if (endAscii.length > 0) {
                lengthOfData += endAscii.length;
            }
        }
        byte[] data = new byte[lengthOfData];
        data[0] = CMD;
        data[1] = (byte)this.option;
        System.arraycopy(startAscii, 0, data, 2, startAscii.length);
        data[startAscii.length + 2] = 44;
        System.arraycopy(endAscii, 0, data, startAscii.length + 3, endAscii.length);
        if (this.group != null) {
            data[startAscii.length + endAscii.length + 3] = 44;
            System.arraycopy(groupAscii, 0, data, data.length - groupAscii.length, groupAscii.length);
        }
        return data;
    }
}

