/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales;

import java.io.Serializable;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;

public class Sale
extends Command
implements Serializable {
    private static final long serialVersionUID = 2872825453895697865L;
    private static byte CMD = (byte)49;
    private String productLine1;
    private String productLine2;
    private char taxCD;
    private double price;
    private double quantity;
    private Double reducereAbs;
    private Double reducerePercent;

    public Sale(String productLine1, String productLine2, char taxCD, double price, Double quantity, Double reducereAbs) {
        this(productLine1, productLine2, taxCD, price, quantity, reducereAbs, null);
    }

    public Sale(String productLine1, String productLine2, char taxCD, double price, Double quantity, Double reducereAbs, Double reducerePercent) {
        this.productLine1 = productLine1;
        this.productLine2 = productLine2;
        this.taxCD = taxCD;
        this.price = price;
        this.quantity = quantity;
        if (quantity < 0.0) {
            this.price = -price;
            this.quantity = -quantity.doubleValue();
        }
        this.reducereAbs = reducereAbs == null || reducereAbs == 0.0 ? null : reducereAbs;
        this.reducerePercent = reducerePercent == null || reducerePercent == 0.0 ? null : reducerePercent;
        this.getBytes(0);
    }

    public void setReducereAbs(Double reducereAbs) {
        this.reducereAbs = reducereAbs;
        this.getBytes(0);
    }

    public void setReducerePercent(Double reducerePercent) {
        this.reducerePercent = reducerePercent;
        this.getBytes(0);
    }

    @Override
    protected byte[] buildData() {
        int lenghtOfData = this.productLine1.length();
        if (this.productLine2 != null) {
            lenghtOfData = lenghtOfData + this.productLine2.length() + 1;
        }
        String formatPrice = Utils.PRICE_FORMAT.format(this.price);
        byte[] price_ascii = Utils.getAsciiCod(formatPrice);
        byte[] reducere_ascii = null;
        if (this.reducereAbs != null) {
            String formatReducere = Utils.PRICE_FORMAT.format(this.reducereAbs);
            reducere_ascii = Utils.getAsciiCod(formatReducere);
        }
        byte[] reducerePercent_ascii = null;
        if (this.reducerePercent != null) {
            String formatReducere = Utils.PRICE_FORMAT.format(this.reducerePercent);
            reducerePercent_ascii = Utils.getAsciiCod(formatReducere);
        }
        String formatQuantity = Utils.QUANTITY_FORMAT.format(this.quantity);
        byte[] quantity_ascii = Utils.getAsciiCod(formatQuantity);
        lenghtOfData += quantity_ascii.length + 1;
        lenghtOfData += price_ascii.length;
        if (this.reducereAbs != null) {
            lenghtOfData += reducere_ascii.length + 1;
        } else if (this.reducerePercent != null) {
            lenghtOfData += reducerePercent_ascii.length + 1;
        }
        byte[] data = new byte[lenghtOfData += 3];
        data[0] = CMD;
        byte[] line1_ascii = Utils.getAsciiCod(this.productLine1);
        System.arraycopy(line1_ascii, 0, data, 1, line1_ascii.length);
        int indexTab = line1_ascii.length + 1;
        if (this.productLine2 != null) {
            data[line1_ascii.length + 1] = 10;
            byte[] line2_ascii = Utils.getAsciiCod(this.productLine2);
            System.arraycopy(line2_ascii, 0, data, line1_ascii.length + 2, line2_ascii.length);
            indexTab += line2_ascii.length + 1;
        }
        data[indexTab] = 9;
        data[indexTab + 1] = (byte)this.taxCD;
        System.arraycopy(price_ascii, 0, data, indexTab + 2, price_ascii.length);
        data[indexTab + 2 + price_ascii.length] = 42;
        System.arraycopy(quantity_ascii, 0, data, indexTab + 3 + price_ascii.length, quantity_ascii.length);
        if (this.reducereAbs != null) {
            data[lenghtOfData - reducere_ascii.length - 1] = 59;
            System.arraycopy(reducere_ascii, 0, data, lenghtOfData - reducere_ascii.length, reducere_ascii.length);
        } else if (this.reducerePercent != null) {
            data[lenghtOfData - reducerePercent_ascii.length - 1] = 44;
            System.arraycopy(reducerePercent_ascii, 0, data, lenghtOfData - reducerePercent_ascii.length, reducerePercent_ascii.length);
        }
        return data;
    }

    public String getProductLine1() {
        return this.productLine1;
    }

    public String getProductLine2() {
        return this.productLine2;
    }

    public char getTaxCD() {
        return this.taxCD;
    }

    public double getPrice() {
        return this.price;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public Double getReducereAbs() {
        return this.reducereAbs;
    }

    public String toString() {
        return this.productLine1 + " " + this.productLine2 + " tax " + this.taxCD + " price " + this.price + " qty " + this.quantity + " reducereAbs " + this.reducereAbs + " reducereProcent " + this.reducerePercent;
    }
}

