/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales;

import java.io.Serializable;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;

public class Total
extends Command
implements Serializable {
    private static byte CMD = (byte)53;
    private String productLine1;
    private String productLine2;
    private char payMode;
    private Double sumAmount;

    public Total(String productLine1, String productLine2, char payMode, Double sumAmount) {
        this.productLine1 = productLine1;
        this.productLine2 = productLine2;
        this.payMode = payMode;
        this.sumAmount = sumAmount;
        this.getBytes(0);
    }

    @Override
    protected byte[] buildData() {
        int lenghtOfData = 2;
        int indexTab = 1;
        if (this.productLine1 != null) {
            lenghtOfData += this.productLine1.length();
            indexTab += this.productLine1.length();
        }
        if (this.productLine2 != null) {
            lenghtOfData = lenghtOfData + this.productLine2.length() + 1;
            indexTab = indexTab + this.productLine2.length() + 1;
        }
        byte[] sumAmountAscii = null;
        if (this.sumAmount != null) {
            ++lenghtOfData;
            String formatSumAmount = Utils.PRICE_FORMAT.format(this.sumAmount);
            sumAmountAscii = Utils.getAsciiCod(formatSumAmount);
            lenghtOfData += sumAmountAscii.length;
        }
        byte[] data = new byte[lenghtOfData];
        data[0] = CMD;
        if (this.productLine1 != null) {
            byte[] productLine1Ascii = Utils.getAsciiCod(this.productLine1);
            System.arraycopy(productLine1Ascii, 0, data, 1, productLine1Ascii.length);
        }
        if (this.productLine2 != null) {
            data[this.productLine1.length() + 1] = 10;
            byte[] productLine2Ascii = Utils.getAsciiCod(this.productLine2);
            System.arraycopy(productLine2Ascii, 0, data, this.productLine1.length() + 2, productLine2Ascii.length);
        }
        data[indexTab] = 9;
        if (sumAmountAscii != null) {
            System.arraycopy(sumAmountAscii, 0, data, lenghtOfData - sumAmountAscii.length, sumAmountAscii.length);
            data[indexTab + 1] = (byte)this.payMode;
        }
        return data;
    }
}

