/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import eu.memshare.export.dao.MemshareFile;
import eu.memshare.export.dao.MemshareNode;
import eu.memshare.export.dao.NodeFilter;
import eu.memshare.export.main.MemshareClient;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.DecryptUtils;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.licensing.LicenseVerifier;
import ro.atreides.utils.multilang.LangRoAll;
import ro.deversoft.licensing.ExportConstants;
import ro.deversoft.licensing.ExportEnums;
import ro.deversoft.licensing.ExportLicenseInterface;
import ro.deversoft.licensing.ExportUtils;
import ro.deversoft.licensing.JsonLicenseVerifier;
import ro.deversoft.licensing.LicenseBean;
import ro.deversoft.licensing.LicenseBeanInterface;
import ro.deversoft.licensing.LicensingMemshareKey;
import ro.deversoft.licensing.ResellerKey;

public class ExportLicense {
    private MemshareClient memClient = MemshareClient.getInstance();
    private static ExportLicense singleInstance;
    private static final String TAG;
    public static final String FALSE_STRING = "false";
    private LicensingMemshareKey licensingMemshareKey;
    public static final String licensingMemshareFileKey = "licensing_memshare_key.bin";

    private ExportLicense() {
        try {
            Gson gson = new Gson();
            String fileContent = ExportLicense.getDecriptedFileContent(licensingMemshareFileKey);
            this.licensingMemshareKey = gson.fromJson(fileContent, LicensingMemshareKey.class);
            String stringForChecksum = JsonLicenseVerifier.generateStringForCheckSum(this.licensingMemshareKey, LicensingMemshareKey.class.getDeclaredFields());
            String checksum = LicenseVerifier.computeChecksum(stringForChecksum);
            if (!this.licensingMemshareKey.getChecksum().equals(checksum)) {
                DialogUtils.errorDialog(GuiUtils.currentFrame, "Fisier licensing_memshare_key.bin corupt !!", "Programul se va inchide");
                Utils.systemExit();
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static ExportLicense getInstance() {
        if (singleInstance == null) {
            singleInstance = new ExportLicense();
        }
        return singleInstance;
    }

    public static final String getDecriptedFileContent(String filename) {
        try {
            String password = "RqEPI8owa0";
            byte[] salt = "wVaxU7TkYg".getBytes("UTF-8");
            File file = new File(filename);
            byte[] fromDisk = org.apache.commons.io.FileUtils.readFileToByteArray((File)file);
            byte[] decripted = DecryptUtils.decrypt1(password, salt, fromDisk);
            String plaintext = new String(decripted, "UTF-8");
            return plaintext;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidParameterSpecException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    private boolean login() {
        boolean connected = false;
        try {
            connected = this.memClient.loginAndConnect(this.licensingMemshareKey.getUrl(), this.licensingMemshareKey.getUser(), this.licensingMemshareKey.getPassword(), this.licensingMemshareKey.getAccount());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connected;
    }

    public long exportJson(File jsonFile, LicenseBean bean, String clientName, String _name, String bdName, int days, ResellerKey resellerKey) {
        if (!this.login()) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu ma pot conecta la Memshare! Verificati conexiunea la Internet sau contactati adminul.", LangRoAll.eroare);
            return -1L;
        }
        Long bdNodeId = this.createUpperTree(clientName, bdName, resellerKey);
        if (bdNodeId == null || bdNodeId == -1L) {
            System.err.println(TAG + "Something went wrong and the upper tree was not created in Memshare!");
            return -1L;
        }
        String expireDate = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.data_expirare.name());
        Date eDate = null;
        try {
            eDate = Formatters.DATE_FORMAT.parse(expireDate);
        }
        catch (ParseException e) {
            System.err.println(TAG + "Error while parsing date from JSON : " + expireDate);
            e.printStackTrace();
        }
        Date newDate = DateUtils.addDaysToDate(eDate, days);
        expireDate = Formatters.DATE_FORMAT.format(newDate);
        ArrayList<Map<String, String>> commonAttr = new ArrayList<Map<String, String>>();
        commonAttr.add(bean.getCommonAttr());
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        map.put(ExportEnums.LicenseMicrosheet.Licenta_Attr_Comune.name(), commonAttr);
        this.addMicrosheets(bdNodeId, map);
        String titleDate = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
        String nodeTitle = String.format("%s - %s", bean.getPcName(), titleDate);
        Long newNodeId = this.createNewNode(bdNodeId, nodeTitle);
        if (newNodeId == null || newNodeId == -1L) {
            System.err.println(TAG + "Something went wrong and the license node was not created in Memshare!");
            return -1L;
        }
        this.addMicrosheets(newNodeId, bean.getAttributes());
        String tmp = FileUtils.getTempDir();
        File newFile = new File(tmp + File.separator + "original_" + Utils.localComputerName);
        jsonFile.renameTo(newFile);
        this.addFile(newNodeId, newFile);
        HashMap<String, List<String>> licenseTags = new HashMap<String, List<String>>();
        licenseTags.put("hdd", new ArrayList());
        ArrayList<String> tagValues = new ArrayList<String>();
        tagValues.add("extend");
        licenseTags.put("license", tagValues);
        boolean sentTags = this.addTags(newNodeId, licenseTags);
        if (!sentTags) {
            System.err.println(TAG + "Something went wrong while sending the tags!");
        }
        return newNodeId;
    }

    private Long createUpperTree(String clientName, String bdName, ResellerKey resellerKey) {
        Long requestsNodeID;
        Long bdNodeId;
        Long clientNodeId;
        Long licenseParent = this.createNewNode(null, resellerKey.getRootEntityLicensingNode());
        if (licenseParent == null) {
            return null;
        }
        Long partnerNodeId = this.createNewNode(licenseParent, resellerKey.getResellerLicensingNode());
        if (partnerNodeId == null) {
            return null;
        }
        HashMap<String, List<String>> partnerTagsMap = new HashMap<String, List<String>>();
        partnerTagsMap.put("partner", new ArrayList());
        if (!this.addTags(partnerNodeId, partnerTagsMap)) {
            System.err.println(TAG + " Tag :" + "partner" + " was not added.");
        }
        if ((clientNodeId = this.createNewNode(partnerNodeId, clientName)) == null) {
            return null;
        }
        HashMap<String, List<String>> clientTagsMap = new HashMap<String, List<String>>();
        clientTagsMap.put("client", new ArrayList());
        if (!this.addTags(clientNodeId, clientTagsMap)) {
            System.err.println(TAG + " Tag :" + "client" + " was not added.");
        }
        if ((bdNodeId = this.createNewNode(clientNodeId, bdName)) == null) {
            return null;
        }
        HashMap<String, List<String>> bdTagsMap = new HashMap<String, List<String>>();
        bdTagsMap.put("bd", new ArrayList());
        if (!this.addTags(bdNodeId, bdTagsMap)) {
            System.err.println(TAG + " Tag :" + "bd" + " was not added.");
        }
        if ((requestsNodeID = this.createNewNode(clientNodeId, "Cereri")) == null) {
            return null;
        }
        HashMap<String, List<String>> reqTagMap = new HashMap<String, List<String>>();
        reqTagMap.put("requests", new ArrayList());
        if (!this.addTags(requestsNodeID, reqTagMap)) {
            System.err.println(TAG + " Tag :" + "requests" + " was not added.");
        }
        return bdNodeId;
    }

    private boolean addTags(Long nodeId, Map<String, List<String>> tagsMap) {
        boolean result = true;
        System.out.println(TAG + "Adding tags to node : parent_id : " + nodeId + " ; tags : " + tagsMap);
        if (!this.attemptConnection()) {
            return false;
        }
        Boolean tagsAdded = this.memClient.saveMemshareTags(nodeId, tagsMap, true);
        if (tagsAdded == null || !tagsAdded.booleanValue()) {
            result = false;
            System.err.println(TAG + "Tags: '" + tagsMap + "' were not added to node with id:" + nodeId);
        }
        return result;
    }

    private boolean addFile(Long nodeId, File xmlFile) {
        boolean result = true;
        System.out.println(TAG + "Adding file to node with id : " + nodeId);
        if (!this.attemptConnection()) {
            return false;
        }
        Boolean fileSaved = null;
        try {
            fileSaved = this.memClient.saveMemshareFile(nodeId, xmlFile, this.getFileTransferListener());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (fileSaved == null || !fileSaved.booleanValue()) {
            result = false;
            System.err.println(TAG + "File: '" + xmlFile.getName() + "' was not added to node with id:" + nodeId);
        }
        return result;
    }

    private boolean addMicrosheets(Long nodeId, Map<String, List<Map<String, String>>> microsheets) {
        if (!this.attemptConnection()) {
            System.err.println(TAG + "Adding microsheets for node with id: " + nodeId + " failed.");
            return false;
        }
        Boolean microsheetsAdded = this.memClient.saveMemshareMicrosheet(nodeId, microsheets, true);
        if (microsheetsAdded == null || !microsheetsAdded.booleanValue()) {
            System.err.println(TAG + "Microsheets were not added to node with id:" + nodeId);
            return false;
        }
        System.out.println(TAG + "Microsheet added to node with id= " + nodeId + "\n" + microsheets);
        return true;
    }

    private boolean attemptConnection() {
        boolean result = false;
        if (this.memClient == null || !this.memClient.connected()) {
            for (int i = 0; i < 10; ++i) {
                if (this.login()) {
                    result = true;
                    break;
                }
                result = false;
            }
        } else {
            result = true;
        }
        if (!result) {
            System.err.print(TAG + "Can't connect to Memshare!");
        }
        return result;
    }

    private Long createNewNode(Long parentId, String nodeTitle) {
        Long nodeId = null;
        System.out.println(TAG + "Adding node : parent_id : " + parentId + " ; node_title : " + nodeTitle);
        if (!this.attemptConnection()) {
            System.err.println(TAG + "Node " + nodeTitle + " was not added!");
            return null;
        }
        nodeId = this.memClient.saveMemshareNode(parentId, nodeTitle);
        return nodeId;
    }

    private boolean findAndGetLicenseFile(String pcName, Long bdID, File licenseDestinationFile) {
        Long licenseNodeID = this.getLicenseNodeId(pcName, bdID);
        if (licenseNodeID == null) {
            return false;
        }
        if (!this.attemptConnection()) {
            return false;
        }
        List licenseFiles = this.memClient.getMemshareFiles(licenseNodeID);
        MemshareFile licenseFile = null;
        for (MemshareFile file : licenseFiles) {
            String fileName = file.getName();
            if (!fileName.contains("original")) continue;
            licenseFile = file;
        }
        if (licenseFile == null) {
            return false;
        }
        if (!this.attemptConnection()) {
            return false;
        }
        try {
            this.memClient.downloadMemshareFile(licenseFile, licenseDestinationFile, this.getFileTransferListener());
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private Long getLicenseNodeId(String pcName, Long bdID) {
        if (!this.attemptConnection()) {
            return null;
        }
        NodeFilter noFinishedNodeFilter = new NodeFilter();
        HashMap tagsAndTagValues = new HashMap();
        tagsAndTagValues.put("Finished", new ArrayList());
        tagsAndTagValues.put("license", new ArrayList());
        noFinishedNodeFilter.setExcludeTags(tagsAndTagValues);
        tagsAndTagValues = new HashMap();
        tagsAndTagValues.put("hdd", new ArrayList());
        List childrenNodes = this.memClient.getChildrenNodes(bdID, noFinishedNodeFilter);
        if (childrenNodes == null || childrenNodes.isEmpty()) {
            System.err.println(TAG + "No file received for the node with id :" + bdID);
            return null;
        }
        Long licenseNodeID = null;
        for (MemshareNode node : childrenNodes) {
            String title = node.getTitle();
            if (!title.contains(pcName)) continue;
            licenseNodeID = node.getId();
            break;
        }
        if (licenseNodeID == null) {
            System.err.println(TAG + "Could not find a license file!");
            return null;
        }
        return licenseNodeID;
    }

    public FileTransferStatusListener getFileTransferListener() {
        FileTransferStatusListener listener = new FileTransferStatusListener(){

            public void bytesReceived(long bytesReceiver, long totalBytes) {
                System.out.println("Uploaded : " + bytesReceiver / totalBytes * 100L + "%");
            }

            public void interrupted() {
                System.out.println("Transfer intrerupt");
            }

            public void completed() {
                System.out.println("Transfer complet");
            }

            public void error(String explain) {
                System.out.println("Eroare la transmisie : " + explain);
            }
        };
        return listener;
    }

    private long requestNewLicense(LicenseBean newLicense, ResellerKey resellerKey) {
        boolean sentMicrosheets;
        if (!this.login()) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu ma pot conecta la Memshare! Verificati conexiunea la Internet sau contactati adminul.", LangRoAll.eroare);
            return -1L;
        }
        Long bdNodeId = this.createUpperTree(newLicense.getClientName(), newLicense.getBdID(), resellerKey);
        if (bdNodeId == null || bdNodeId == -1L) {
            System.err.println(TAG + "Something went wrong and the upper tree was not created in Memshare!");
            return -1L;
        }
        HashMap<String, List<Map<String, String>>> bdMicrosheets = new HashMap<String, List<Map<String, String>>>();
        ArrayList<Map<String, String>> bdMicroShRows = new ArrayList<Map<String, String>>();
        bdMicroShRows.add(newLicense.getCommonAttr());
        bdMicrosheets.put(ExportEnums.LicenseMicrosheet.Licenta_Attr_Comune.name(), bdMicroShRows);
        this.addMicrosheets(bdNodeId, bdMicrosheets);
        String titleDate = Formatters.DATE_AND_TIME_FORMAT.format(new Date());
        String nodeTitle = String.format("%s - %s", newLicense.getPcName(), titleDate);
        Long licenseNodeId = this.createNewNode(bdNodeId, nodeTitle);
        if (licenseNodeId == null || licenseNodeId == -1L) {
            System.err.println(TAG + "Something went wrong and the license node was not added in Memshare!");
            return -1L;
        }
        HashMap<String, List<String>> licenseTags = new HashMap<String, List<String>>();
        licenseTags.put("hdd", new ArrayList());
        ArrayList<String> tagValues = new ArrayList<String>();
        tagValues.add("new");
        licenseTags.put("license", tagValues);
        boolean sentTags = this.addTags(licenseNodeId, licenseTags);
        if (!sentTags) {
            System.err.println(TAG + "Something went wrong while sending the tags!");
        }
        if (!(sentMicrosheets = this.addMicrosheets(licenseNodeId, newLicense.getAttributes()))) {
            System.err.println(TAG + "Something went wrong while sending the microsheets!");
        }
        return licenseNodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String downloadFileContentUrl(String urlString) {
        String fileContents = "";
        try {
            URL url = new URL(urlString);
            Scanner streamScanner = new Scanner(url.openStream());
            if (streamScanner == null) {
                return null;
            }
            String lineSeparator = "\n";
            try {
                while (streamScanner.hasNextLine()) {
                    fileContents = fileContents + streamScanner.nextLine() + lineSeparator;
                }
            }
            finally {
                streamScanner.close();
            }
        }
        catch (IOException ex) {
            System.err.println(TAG + ex.getMessage());
        }
        return fileContents;
    }

    public static Vector<String> parseFileFromUrl(String url) {
        if (url == null) {
            return new Vector<String>();
        }
        String fileContent = ExportLicense.downloadFileContentUrl(url);
        if (!Validators.correctString(fileContent)) {
            System.err.println(TAG + "Empty file returned from from : " + url);
            return new Vector<String>();
        }
        String[] parsedString = fileContent.split("\\r?\\n");
        if (parsedString.length <= 0) {
            System.err.println(TAG + "Error parsing file from : " + url);
            return new Vector<String>();
        }
        return new Vector<String>(Arrays.asList(parsedString));
    }

    public void requestNewLicense(LicenseBean newLicense, ExportLicenseInterface licenseInterface, ResellerKey resellerKey) {
        licenseInterface.checkGlobalConfigs();
        if (!licenseInterface.canAddLicenseRequest()) {
            licenseInterface.showErrorDialog("Deja exista o cerere in curs de procesare!", LangRoAll.actiuni);
            return;
        }
        long l = ExportLicense.getInstance().requestNewLicense(newLicense, resellerKey);
        licenseInterface.registerLicenseRequest(RequestType.newLicense, l);
        if (l >= 0L) {
            licenseInterface.showOkDialog("Cerere inregistrata cu succes!", LangRoAll.succes);
            Map<String, List<Map<String, String>>> atts = newLicense.getAttributes();
            List<Map<String, String>> licentaAppRows = atts.get(ExportEnums.LicenseMicrosheet.Licenta_App.name());
            Map<String, String> licentaApp = licentaAppRows.get(0);
            String tipApp = licentaApp.get(ExportEnums.Licenta_App.tip_aplicatie.name());
            String hddId = licentaApp.get(ExportEnums.Licenta_App.hdd_id.name());
            String urls = resellerKey.getOnlineOrderUrl();
            Vector splitted = Utils.splitString(urls, ',');
            for (String urlMap : splitted) {
                String s;
                char nullChar;
                Vector tokens = Utils.splitStringKeepStructure(urlMap, '=', nullChar = '\u0002');
                if (tokens.size() <= 1) continue;
                String appName = (String)tokens.get(0);
                String url = (String)tokens.get(1);
                String idProduct = "";
                if (tokens.size() > 2 && !(s = (String)tokens.get(2)).equalsIgnoreCase(nullChar + "")) {
                    idProduct = s;
                }
                if (!appName.equalsIgnoreCase(tipApp) || !Validators.correctString(url)) continue;
                try {
                    url = url.replace("%%rid%%", URLEncoder.encode(l + "---" + hddId, "UTF-8"));
                    url = url.replace("%%pid%%", idProduct);
                    licenseInterface.openOnlineShopUrl(url);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("TipApp = " + tipApp);
        }
    }

    public static LicenseBean composeNewLicenseBean(LicenseBeanInterface licenseInterface) {
        LicenseBean newLicense = new LicenseBean();
        newLicense.setPcName(licenseInterface.getPCName());
        newLicense.setBdID(licenseInterface.getDBId());
        newLicense.setClientName(licenseInterface.getClientName());
        HashMap<String, String> commonAttr = new HashMap<String, String>();
        commonAttr.put(ExportEnums.Licenta_Attr_Comune.brand.name(), licenseInterface.getBrand());
        commonAttr.put(ExportEnums.Licenta_Attr_Comune.societate.name(), licenseInterface.getSocietate());
        commonAttr.put(ExportEnums.Licenta_Attr_Comune.cui.name(), licenseInterface.getCui());
        newLicense.setCommonAttr(commonAttr);
        HashMap<String, String> licentaApp = new HashMap<String, String>();
        licentaApp.put(ExportEnums.Licenta_App.hdd_id.name(), licenseInterface.getHDDId());
        licentaApp.put(ExportEnums.Licenta_App.sequence.name(), licenseInterface.getCurrentSequence() + 1 + "");
        licentaApp.put(ExportEnums.Licenta_App.data_expirare.name(), ExportConstants.DATE_FORMAT.format(licenseInterface.getExpireDate()));
        String majorVersionDb = licenseInterface.getMajorVersion();
        licentaApp.put(ExportEnums.Licenta_App.main_version.name(), majorVersionDb);
        licentaApp.put(ExportEnums.Licenta_App.name.name(), licenseInterface.getPCName());
        licentaApp.put(ExportEnums.Licenta_App.tip_aplicatie.name(), licenseInterface.getChosenApp());
        HashMap<String, List<Map<String, String>>> attributes = new HashMap<String, List<Map<String, String>>>();
        ArrayList<HashMap<String, String>> licentaAppRows = new ArrayList<HashMap<String, String>>();
        licentaAppRows.add(licentaApp);
        attributes.put(ExportEnums.LicenseMicrosheet.Licenta_App.name(), licentaAppRows);
        ArrayList licentaModulesRows = new ArrayList();
        for (String module : licenseInterface.getChosenModules()) {
            HashMap<String, String> modulePair = new HashMap<String, String>();
            modulePair.put(ExportEnums.Licenta_Module.nume.name(), module);
            modulePair.put(ExportEnums.Licenta_Module.exclude.name(), FALSE_STRING);
            licentaModulesRows.add(modulePair);
        }
        attributes.put(ExportEnums.LicenseMicrosheet.Licenta_Module.name(), licentaModulesRows);
        ArrayList dateContact = new ArrayList();
        HashMap<String, String> pair1 = new HashMap<String, String>();
        pair1.put(ExportEnums.DateContact.tip.name(), ExportEnums.DateContact_Tip.Email.name());
        pair1.put(ExportEnums.DateContact.valoare.name(), licenseInterface.getEmailAddress());
        dateContact.add(pair1);
        HashMap<String, String> pair2 = new HashMap<String, String>();
        pair2.put(ExportEnums.DateContact.tip.name(), ExportEnums.DateContact_Tip.Tel.name());
        pair2.put(ExportEnums.DateContact.valoare.name(), licenseInterface.getMobileNumber());
        dateContact.add(pair2);
        attributes.put(ExportEnums.LicenseMicrosheet.DateContact.name(), dateContact);
        newLicense.setAttributes(attributes);
        return newLicense;
    }

    public Long exportXMLFile(File xmlFile, String clientName, String bdName, Map<String, List<Map<String, String>>> bdMicrosheets, String pcNodeTitle, Map<String, List<Map<String, String>>> licenseMicrosheets, ResellerKey resellerKey) {
        if (!this.login()) {
            DialogUtils.errorDialog(GuiUtils.currentFrame, "Nu ma pot conecta la Memshare! Verificati conexiunea la Internet sau contactati adminul.", LangRoAll.eroare);
            return -1L;
        }
        Long bdId = this.createUpperTree(clientName, bdName, resellerKey);
        if (bdId == null) {
            System.err.println(TAG + "Node with parent_id : '" + bdId + "' was not added!");
            return null;
        }
        ExportLicense.getInstance().addMicrosheets(bdId, bdMicrosheets);
        if (pcNodeTitle == null || pcNodeTitle.isEmpty()) {
            return null;
        }
        Long pcNodeId = this.memClient.saveMemshareNode(bdId, pcNodeTitle);
        if (pcNodeId == null) {
            System.err.println(TAG + "Node with id : '" + pcNodeId + "' and title : '" + pcNodeTitle + "was not added!");
            return null;
        }
        this.addMicrosheets(pcNodeId, licenseMicrosheets);
        this.addFile(pcNodeId, xmlFile);
        HashMap<String, List<String>> pcNodeTagsMap = new HashMap<String, List<String>>();
        pcNodeTagsMap.put("license", Arrays.asList("migrate"));
        pcNodeTagsMap.put("hdd", new ArrayList());
        ExportLicense.getInstance().addTags(pcNodeId, pcNodeTagsMap);
        return pcNodeId;
    }

    static {
        TAG = ExportLicense.class.getSimpleName() + " : ";
    }

    public static enum RequestType {
        migrate,
        extend,
        newLicense;

    }
}

