/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.licensing.LicenseBean;

public class ExportUtils {
    private static final String TAG = ExportUtils.class.getSimpleName();

    public static Date getDateFromString(String format, String stringDate) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date = null;
        try {
            date = sdf.parse(stringDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public static String getLicense(String allLicenceStrings) {
        try {
            if (allLicenceStrings == null || allLicenceStrings.length() < 1) {
                return null;
            }
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            allLicenceStrings = allLicenceStrings + "jkdf8hgj2dfhg7k345d1hfu53j4h5jhg4asb5ndh";
            encryptor.update(allLicenceStrings.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            return hex.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Boolean verifyJSONChecksum(File jsonFile) {
        boolean result = false;
        String fileContent = ExportUtils.readFile(jsonFile);
        if (fileContent == null || fileContent.isEmpty()) {
            System.err.println(TAG + "File is empty or not readable");
            return false;
        }
        LicenseBean licenseBeanFromJson = ExportUtils.getLicenseBeanFromJson(fileContent);
        String stringForChecksum = ExportUtils.generateStringForCheckSum(licenseBeanFromJson);
        String checkSum = ExportUtils.getLicense(stringForChecksum);
        String beanChecksum = licenseBeanFromJson.getChecksum();
        if (checkSum == null || checkSum.isEmpty()) {
            System.err.println(TAG + "Generated checksum is null or empty!");
            return false;
        }
        if (beanChecksum == null || beanChecksum.isEmpty()) {
            System.err.println(TAG + "Checksum from bean is null or empty!");
            return false;
        }
        if (checkSum.equals(beanChecksum)) {
            result = true;
        }
        return result;
    }

    public static String generateStringForCheckSum(LicenseBean bean) {
        Field[] fields;
        StringBuilder buffer = new StringBuilder();
        for (Field f : fields = LicenseBean.class.getDeclaredFields()) {
            f.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = f.get(bean);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (fieldValue == null) continue;
            if (fieldValue instanceof String) {
                String stringField = ((String)fieldValue).trim();
                buffer.append(stringField);
                continue;
            }
            if (fieldValue instanceof Integer) {
                Integer integerField = (Integer)fieldValue;
                buffer.append(integerField);
                continue;
            }
            if (!(fieldValue instanceof Map)) continue;
            Map oldMap = (Map)fieldValue;
            for (String key : oldMap.keySet()) {
                List rowList;
                Object mapValue = oldMap.get(key);
                if (mapValue instanceof String) {
                    String stringValue = ((String)mapValue).trim();
                    buffer.append(key);
                    buffer.append(stringValue);
                }
                if (!(mapValue instanceof List) || (rowList = (List)mapValue).isEmpty()) continue;
                for (Map map : rowList) {
                    for (String columnName : map.keySet()) {
                        String rowValue = (String)map.get(columnName);
                        if (rowValue == null || rowValue.isEmpty()) continue;
                        buffer.append(columnName);
                        buffer.append(rowValue);
                    }
                }
            }
        }
        return buffer.toString();
    }

    public static LicenseBean getLicenseBeanFromJson(String fileContent) {
        LicenseBean bean = null;
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            bean = gson.fromJson(fileContent, LicenseBean.class);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) {
        StringBuilder fileContents = new StringBuilder();
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        if (scanner == null) {
            return null;
        }
        String lineSeparator = "\n";
        try {
            fileContents = new StringBuilder((int)file.length());
            while (scanner.hasNextLine()) {
                fileContents.append(scanner.nextLine()).append(lineSeparator);
            }
        }
        finally {
            scanner.close();
        }
        return fileContents.toString();
    }

    public static File createNewFile(String path) {
        File newFile = new File(path);
        newFile.getParentFile().mkdirs();
        try {
            newFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!newFile.exists() || !newFile.isFile()) {
            return null;
        }
        return newFile;
    }

    public static String getPropertyFromAttributes(LicenseBean bean, String microsheetName, String columnName) {
        String hddID = null;
        if (bean == null || bean.getAttributes() == null || bean.getAttributes().isEmpty()) {
            return null;
        }
        Map<String, List<Map<String, String>>> customForms = bean.getAttributes();
        if (customForms.isEmpty()) {
            return null;
        }
        List<Map<String, String>> rows = customForms.get(microsheetName);
        if (ExportUtils.isNullOrEmpty(rows)) {
            return null;
        }
        Map<String, String> firstRow = rows.get(0);
        if (ExportUtils.isNullOrEmpty(firstRow)) {
            return null;
        }
        String resultValue = firstRow.get(columnName);
        if (Validators.correctString(resultValue)) {
            hddID = resultValue;
        }
        return hddID;
    }

    private static boolean isNullOrEmpty(List list) {
        return list == null || list.isEmpty();
    }

    private static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }
}

