/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.licensing.LicenseVerifier;
import ro.deversoft.licensing.ExportEnums;
import ro.deversoft.licensing.ExportUtils;
import ro.deversoft.licensing.LicenseBean;

public class JsonLicenseVerifier {
    private static final String TAG = JsonLicenseVerifier.class.getSimpleName() + " : ";

    public static boolean verifyChecksum(File licenseFile, StringBuffer buffer, String localComputerName) {
        boolean result = false;
        if (licenseFile == null) {
            System.err.println(TAG + "File is empty or not readable");
            return false;
        }
        String fileContent = ExportUtils.readFile(licenseFile);
        LicenseBean bean = JsonLicenseVerifier.getLicenseBeanFromJson(fileContent);
        if (bean == null) {
            return false;
        }
        String pcNameNoDate = bean.getPcNameNoDate();
        if (!pcNameNoDate.equalsIgnoreCase(localComputerName)) {
            return false;
        }
        String stringForChecksum = JsonLicenseVerifier.generateStringForCheckSum(bean, LicenseBean.class.getDeclaredFields());
        String checkSum = LicenseVerifier.computeChecksum(stringForChecksum);
        if (!Validators.correctString(checkSum)) {
            System.err.println(TAG + "Generated checksum is null or empty!");
            return false;
        }
        String beanChecksum = bean.getChecksum();
        if (!Validators.correctString(beanChecksum)) {
            System.err.println(TAG + "Checksum from bean is null or empty!");
            return false;
        }
        if (!checkSum.equals(beanChecksum)) {
            return false;
        }
        result = true;
        String sequence = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.sequence.name());
        if (!Validators.correctInteger(sequence)) {
            System.err.println(TAG + "Invalid sequence no.!");
            return false;
        }
        buffer.append(sequence);
        result = true;
        return result;
    }

    public static LicenseBean getLicenseBeanFromJson(String fileContent) {
        LicenseBean bean = null;
        try {
            Gson gson = new Gson();
            bean = gson.fromJson(fileContent, LicenseBean.class);
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public static String generateStringForCheckSum(Object bean, Field[] fields) {
        StringBuilder buffer = new StringBuilder();
        for (Field f : fields) {
            f.setAccessible(true);
            Object fieldValue = null;
            try {
                fieldValue = f.get(bean);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            if (fieldValue == null) continue;
            if (fieldValue instanceof String) {
                if (f.getName().equalsIgnoreCase("checksum")) continue;
                String stringField = ((String)fieldValue).trim();
                buffer.append(stringField);
                continue;
            }
            if (!(fieldValue instanceof Map)) continue;
            Map oldMap = (Map)fieldValue;
            for (String key : oldMap.keySet()) {
                List rowList;
                Object mapValue = oldMap.get(key);
                if (mapValue instanceof String) {
                    String stringValue = ((String)mapValue).trim();
                    buffer.append(key);
                    buffer.append(stringValue);
                }
                if (!(mapValue instanceof List) || (rowList = (List)mapValue).isEmpty()) continue;
                for (Map map : rowList) {
                    for (String columnName : map.keySet()) {
                        String rowValue = (String)map.get(columnName);
                        if (rowValue == null || rowValue.isEmpty()) continue;
                        buffer.append(columnName);
                        buffer.append(rowValue);
                    }
                }
            }
        }
        return buffer.toString();
    }
}

