/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.licensing.ExportEnums;
import ro.deversoft.licensing.ExportUtils;
import ro.deversoft.licensing.JsonLicenseVerifier;
import ro.deversoft.licensing.LicenseBean;
import ro.deversoft.licensing.LicensingBean;
import ro.deversoft.licensing.LicensingInterface;
import ro.deversoft.licensing.LicensingJsonHandlerInterface;

public class LicensingJsonHandler
implements LicensingInterface {
    private static final String TAG = LicensingJsonHandler.class.getSimpleName() + " : ";
    private Vector<LicensingBean> applications = new Vector();
    private Vector<LicensingBean> modules = new Vector();
    private Vector<LicensingBean> systemProperties = new Vector();
    private Vector<LicensingBean> clientProperties = new Vector();
    private String generatedAt = "";
    private Date expireDate = null;
    private int days = -1;
    private String licenceFileId = "";
    private String sequence = "";
    private String hddId = "";
    private String checksum = "";
    private Integer majorVersion = null;
    private LicensingJsonHandlerInterface handlerInterface;

    public LicensingJsonHandler(LicensingJsonHandlerInterface handlerInterface) {
        this.handlerInterface = handlerInterface;
    }

    @Override
    public void load(String filepath) throws IOException {
        String fileContent;
        File licenseFile = new File(filepath);
        if (!licenseFile.exists() || licenseFile.isDirectory()) {
            this.handlerInterface.notifyUserError("Cale catre fisierul de licenta invalida", "Atentie!");
        }
        if (!Validators.correctString(fileContent = ExportUtils.readFile(licenseFile))) {
            this.handlerInterface.notifyUserError("Fisier de licenta gol!", "Atentie!");
        }
        LicenseBean bean = null;
        if (!JsonLicenseVerifier.verifyChecksum(licenseFile, new StringBuffer(), this.handlerInterface.getLocalComputerName())) {
            this.handlerInterface.notifyUserError("Checksum incorect! Fisier cu continut invalid!", "Atentie!");
        }
        if ((bean = ExportUtils.getLicenseBeanFromJson(fileContent)) == null) {
            String s = "Fisier licenta corupt. Eroare fatala!";
            this.handlerInterface.notifyUserErrorAndRecord(s, "Contactati distribuitorul!");
            return;
        }
        String expDate = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.data_expirare.name());
        Date eDate = null;
        try {
            eDate = Formatters.DATE_FORMAT.parse(expDate);
        }
        catch (ParseException e) {
            System.err.println(TAG + "Error while parsing date from JSON : " + expDate);
            e.printStackTrace();
        }
        if (eDate != null) {
            this.expireDate = eDate;
            Date currentDate = new Date();
            this.generatedAt = Formatters.DATE_AND_TIME_FORMAT.format(currentDate);
            this.days = (int)ModuleUtils.getDateDiff(currentDate, eDate, TimeUnit.DAYS);
        }
        this.parseCommonAttributes(bean.getCommonAttr());
        this.parseAttributes(bean.getAttributes());
        this.checksum = bean.getChecksum();
        this.sequence = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.sequence.name());
        this.licenceFileId = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.name.name());
        String version = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.main_version.name());
        this.hddId = ExportUtils.getPropertyFromAttributes(bean, ExportEnums.LicenseMicrosheet.Licenta_App.name(), ExportEnums.Licenta_App.hdd_id.name());
        if (Validators.correctInteger(version)) {
            this.majorVersion = Integer.valueOf(version);
        } else {
            this.handlerInterface.notifyUserError("Fisier de licenta incorect! Lipseste majorVersion!", "Contactati distribuitorul!");
        }
    }

    private void parseAttributes(Map<String, List<Map<String, String>>> attributes) {
        for (String attributeSetName : attributes.keySet()) {
            List<Map<String, String>> attributeSet = attributes.get(attributeSetName);
            if (attributeSetName.equalsIgnoreCase(ExportEnums.LicenseMicrosheet.Licenta_App.name())) {
                String hddIdName = ExportEnums.Licenta_App.hdd_id.name();
                Map<String, String> firstEntry = attributeSet.get(0);
                String hddId = firstEntry.get(hddIdName);
                this.systemProperties.add(new LicensingBean("hdd1SerNumber", hddId));
                String appName = firstEntry.get(ExportEnums.Licenta_App.tip_aplicatie.name());
                if (!Validators.correctString(appName)) {
                    System.err.println(TAG + "Client name null or empty!");
                    continue;
                }
                this.applications.add(new LicensingBean(appName, this.days + ""));
                continue;
            }
            if (!attributeSetName.equalsIgnoreCase(ExportEnums.LicenseMicrosheet.Licenta_Module.name())) continue;
            for (Map<String, String> entry : attributeSet) {
                String moduleName = entry.get(ExportEnums.Licenta_Module.nume.name());
                String exclude = entry.get(ExportEnums.Licenta_Module.exclude.name());
                if (Validators.correctString(moduleName) || Validators.correctString(exclude)) {
                    System.err.println(TAG + "Invalid module! (" + entry + ")");
                    continue;
                }
                if (!Validators.correctBoolean(exclude)) {
                    System.err.println(TAG + "Invalid module exclude value! (" + moduleName + ")");
                    continue;
                }
                String className = ModuleUtils.getClassName(moduleName);
                if (Validators.correctString(className)) {
                    System.err.println(TAG + "Unknown module with name='" + moduleName + "' !!!");
                    continue;
                }
                this.modules.add(new LicensingBean(className, this.days + ""));
            }
        }
    }

    private void parseCommonAttributes(Map<String, String> commonAttr) {
        for (String key : commonAttr.keySet()) {
            String value = commonAttr.get(key);
            this.clientProperties.add(new LicensingBean(key, value));
        }
    }

    @Override
    public Vector<LicensingBean> getApplications() {
        return this.applications;
    }

    @Override
    public Vector<LicensingBean> getModules() {
        return this.modules;
    }

    @Override
    public Vector<LicensingBean> getClientProperties() {
        return this.clientProperties;
    }

    @Override
    public Vector<LicensingBean> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public String getGeneratedAt() {
        return this.generatedAt;
    }

    @Override
    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public String getLicenceFileId() {
        return this.licenceFileId;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    public Date getExpireDate() {
        return this.expireDate;
    }

    public String getHddId() {
        return this.hddId;
    }

    public static class ModuleUtils {
        private static Map<String, String> moduleNamesAndClassnames = new HashMap<String, String>();

        public static String getClassName(String moduleName) {
            return moduleNamesAndClassnames.get(moduleName);
        }

        public static long getDateDiff(Date date1, Date date2, TimeUnit timeUnit) {
            long diffInMillies = date2.getTime() - date1.getTime();
            return timeUnit.convert(diffInMillies, TimeUnit.MILLISECONDS);
        }

        static {
            moduleNamesAndClassnames.put("actiuni", "?");
            moduleNamesAndClassnames.put("achizitii", "?");
            moduleNamesAndClassnames.put("administrare", "ro.atreides.restaurant.gui.AdminPanel");
            moduleNamesAndClassnames.put("afisaj_client", "ro.atreides.restaurant.modules.afisajclient.gui.AfisajClientPanel");
            moduleNamesAndClassnames.put("afisajClient", "ro.atreides.restaurant.modules.afisajclient.gui.AfisajClientPanel");
            moduleNamesAndClassnames.put("bucatarie_complex", "ro.atreides.productie.gui.ProductieMainComplex");
            moduleNamesAndClassnames.put("bucatarie_complex1", "ro.atreides.productie.gui.ProductieMain");
            moduleNamesAndClassnames.put("bucatarie_complex2", "ro.atreides.productie.gui.ProductieMainComplex");
            moduleNamesAndClassnames.put("bucatarie_livrari", "ro.atreides.productie.gui.quick.QuickProductiePanel");
            moduleNamesAndClassnames.put("bucatarie_quick", "ro.atreides.productie.gui.quick.QuickProductieMain");
            moduleNamesAndClassnames.put("bucatarie_simple", "ro.atreides.productie.gui.SimpleProductieMain");
            moduleNamesAndClassnames.put("catering_old", "ro.atreides.restaurant.gui.touch8.TouchMain8");
            moduleNamesAndClassnames.put("comenzi_furnizori_simple", "ro.atreides.restaurant.gui.reports.ComenziReportPanel");
            moduleNamesAndClassnames.put("contabilitate", "ro.atreides.contabilitate.gui.NirPanel");
            moduleNamesAndClassnames.put("erp", "ro.atreides.restaurant.gui.erpsales.ErpSalesMainPanel");
            moduleNamesAndClassnames.put("facturare", "?");
            moduleNamesAndClassnames.put("fastfood", "ro.atreides.restaurant.gui.touch6.TouchMain6");
            moduleNamesAndClassnames.put("fastfood_classic", "?");
            moduleNamesAndClassnames.put("fastfood_credit", "ro.atreides.restaurant.gui.touch9.TouchMain9");
            moduleNamesAndClassnames.put("fidelitate_carduri", "?");
            moduleNamesAndClassnames.put("fidelitate_premii_instant", "?");
            moduleNamesAndClassnames.put("fidelitate_promotii", "?");
            moduleNamesAndClassnames.put("financiar", "ro.atreides.contabilitate.gui.FinanciarPanel");
            moduleNamesAndClassnames.put("financiar_avansat", "ro.atreides.contabilitate.gui.FinanciarAdvancedPanel");
            moduleNamesAndClassnames.put("fitness_backoffice", "?");
            moduleNamesAndClassnames.put("fitness_frontoffice", "?");
            moduleNamesAndClassnames.put("fitness_intrari", "?");
            moduleNamesAndClassnames.put("gestionar", "ro.atreides.restaurant.gui.reports.GestionarPanel");
            moduleNamesAndClassnames.put("jocuri_backoffice", "ro.atreides.jocuri.gui.JocuriEditTable");
            moduleNamesAndClassnames.put("jocuri", "ro.atreides.jocuri.gui.MeseGui");
            moduleNamesAndClassnames.put("jocuri_frontoffice", "ro.atreides.jocuri.gui.MeseGui");
            moduleNamesAndClassnames.put("livrari", "ro.atreides.restaurant.gui.livrari.LivrariMainPanel");
            moduleNamesAndClassnames.put("meniuri", "ro.atreides.restaurant.gui.admin.meniuri.MeniuriHolderPanel");
            moduleNamesAndClassnames.put("modificari", "ro.atreides.restaurant.gui.ModificationsPanel");
            moduleNamesAndClassnames.put("parteneri", "?");
            moduleNamesAndClassnames.put("pontaj_backoffice", "ro.atreides.pontaj.gui.RapoartePontaj");
            moduleNamesAndClassnames.put("pontaj", "ro.atreides.pontaj.gui.PontajPanel");
            moduleNamesAndClassnames.put("pontaj_frontoffice", "ro.atreides.pontaj.gui.PontajPanel");
            moduleNamesAndClassnames.put("productie", "ro.atreides.productie.gui.ProductieMain");
            moduleNamesAndClassnames.put("productie_backoffice", "ro.atreides.restaurant.gui.ProductiePanel");
            moduleNamesAndClassnames.put("productieComplex", "ro.atreides.productie.gui.ProductieMainComplex");
            moduleNamesAndClassnames.put("productie_cu_marcaj", "ro.atreides.restaurant.gui.touch7.TouchMain7");
            moduleNamesAndClassnames.put("productie_frontoffice", "ro.atreides.restaurant.gui.touch7.TouchMain7");
            moduleNamesAndClassnames.put("productieQuick", "ro.atreides.productie.gui.quick.QuickProductieMain");
            moduleNamesAndClassnames.put("productieQuickSmall", "o.atreides.productie.gui.QuickSmallProductiePanel");
            moduleNamesAndClassnames.put("productieSimple", "ro.atreides.productie.gui.SimpleProductieMain");
            moduleNamesAndClassnames.put("retetar", "ro.atreides.restaurant.gui.admin.recipe.RetetarPanel");
            moduleNamesAndClassnames.put("restaurant", "ro.atreides.restaurant.gui.restaurant.RestaurantMain");
            moduleNamesAndClassnames.put("restaurant_new", "ro.atreides.restaurant.gui.restaurant.RestaurantMain");
            moduleNamesAndClassnames.put("restaurant_vechi", "ro.atreides.restaurant.gui.touch2.TouchMain2");
            moduleNamesAndClassnames.put("rezervari", "ro.atreides.restaurant.modules.rezervari.RezervariPanel");
            moduleNamesAndClassnames.put("shop_frontoffice", "ro.atreides.restaurant.gui.orders.KeysTouchMain");
            moduleNamesAndClassnames.put("stocuri_complex", "ro.atreides.stocks.gui.StocuriPanel");
            moduleNamesAndClassnames.put("stocuri_simple", "ro.atreides.simplestocks.gui.SimpleStocksPanel");
        }
    }
}

