/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.licensing;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Date;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.licensing.LicenseVerifier;
import ro.deversoft.licensing.JsonLicenseVerifier;

public class ResellerKey
implements Serializable {
    private String rootEntityLicensingNode;
    private String resellerLicensingNode;
    private String email;
    private String tel;
    private String numePartener;
    private String www;
    private String altele;
    private String backupContact;
    private String resellerContractNumber;
    private String rootEntityContractNumber;
    private String onlineOrderUrl;
    private Date resellerContractExpire;
    private Date rootEntityContractExpire;
    private String checksum;

    public String getAltele() {
        return this.altele;
    }

    public void setAltele(String altele) {
        this.altele = altele;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNumePartener() {
        return this.numePartener;
    }

    public void setNumePartener(String numePartener) {
        this.numePartener = numePartener;
    }

    public Date getResellerContractExpire() {
        return this.resellerContractExpire;
    }

    public void setResellerContractExpire(Date resellerContractExpire) {
        this.resellerContractExpire = resellerContractExpire;
    }

    public String getResellerContractNumber() {
        return this.resellerContractNumber;
    }

    public void setResellerContractNumber(String resellerContractNumber) {
        this.resellerContractNumber = resellerContractNumber;
    }

    public String getResellerLicensingNode() {
        return this.resellerLicensingNode;
    }

    public void setResellerLicensingNode(String resellerLicensingNode) {
        this.resellerLicensingNode = resellerLicensingNode;
    }

    public Date getRootEntityContractExpire() {
        return this.rootEntityContractExpire;
    }

    public void setRootEntityContractExpire(Date rootEntityContractExpire) {
        this.rootEntityContractExpire = rootEntityContractExpire;
    }

    public String getRootEntityContractNumber() {
        return this.rootEntityContractNumber;
    }

    public void setRootEntityContractNumber(String rootEntityContractNumber) {
        this.rootEntityContractNumber = rootEntityContractNumber;
    }

    public String getRootEntityLicensingNode() {
        return this.rootEntityLicensingNode;
    }

    public void setRootEntityLicensingNode(String rootEntityLicensingNode) {
        this.rootEntityLicensingNode = rootEntityLicensingNode;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getWww() {
        return this.www;
    }

    public void setWww(String www) {
        this.www = www;
    }

    public String getBackupContact() {
        return this.backupContact;
    }

    public void setBackupContact(String backupContact) {
        this.backupContact = backupContact;
    }

    public static ResellerKey getResellerKeyFromFile(String fileName) {
        ResellerKey bean = null;
        try {
            Gson gson = new Gson();
            String fileContent = FileUtils.readFileToString(fileName);
            bean = gson.fromJson(fileContent, ResellerKey.class);
        }
        catch (JsonSyntaxException | IOException e) {
            Logger.logException(ResellerKey.class.getName(), e);
        }
        return bean;
    }

    public static final void main(String[] args) {
        try {
            ResellerKey resellerKey = new ResellerKey();
            String root = Utils.getCmdlineValue("-root", args);
            resellerKey.setRootEntityLicensingNode(root);
            String reseller = Utils.getCmdlineValue("-reseller", args);
            resellerKey.setResellerLicensingNode(reseller);
            String email = Utils.getCmdlineValue("-email", args);
            resellerKey.setEmail(email);
            String tel = Utils.getCmdlineValue("-tel", args);
            resellerKey.setTel(tel);
            String numePartener = Utils.getCmdlineValue("-partner", args);
            resellerKey.setNumePartener(numePartener);
            String www = Utils.getCmdlineValue("-www", args);
            resellerKey.setWww(www);
            resellerKey.setAltele("");
            resellerKey.setBackupContact("0723190126");
            String resellerContractNumber = Utils.getCmdlineValue("-resellercontractnumber", args);
            resellerKey.setResellerContractNumber(resellerContractNumber);
            String rootContractNumber = Utils.getCmdlineValue("-rootcontractnumber", args);
            resellerKey.setRootEntityContractNumber(rootContractNumber);
            String resellerContractExpire = Utils.getCmdlineValue("-resellercontractexpire", args);
            resellerKey.setResellerContractExpire(Formatters.CIEL_NIR_IMPORT_FORMAT.parse(resellerContractExpire));
            String rootContractExpire = Utils.getCmdlineValue("-rootcontractexpire", args);
            resellerKey.setRootEntityContractExpire(Formatters.CIEL_NIR_IMPORT_FORMAT.parse(rootContractExpire));
            String onlineOrderUrl = Utils.getCmdlineValue("-onlineorderurl", args);
            resellerKey.setOnlineOrderUrl(onlineOrderUrl);
            String stringForChecksum = JsonLicenseVerifier.generateStringForCheckSum(resellerKey, ResellerKey.class.getDeclaredFields());
            String checksum = LicenseVerifier.computeChecksum(stringForChecksum);
            resellerKey.setChecksum(checksum);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String fileContent = gson.toJson(resellerKey);
            FileUtils.writeTextToFile("reseller_key.json", fileContent);
        }
        catch (IOException | ParseException e) {
            e.printStackTrace();
        }
    }

    public boolean verifyChecksum() {
        String stringForChecksum = JsonLicenseVerifier.generateStringForCheckSum(this, ResellerKey.class.getDeclaredFields());
        String checksumComputed = LicenseVerifier.computeChecksum(stringForChecksum);
        String checksumDeclared = this.checksum;
        return checksumComputed.equals(checksumDeclared);
    }

    public String getOnlineOrderUrl() {
        return this.onlineOrderUrl;
    }

    public void setOnlineOrderUrl(String onlineOrderUrl) {
        this.onlineOrderUrl = onlineOrderUrl;
    }
}

