/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.utils.noarch;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.deversoft.utils.noarch.Logger;

public class FileUtils {
    public static final String TEMP_DIR = "tmp";
    private static final Pattern NON_DIGIT = Pattern.compile("(([^0-9]*))");
    private static final Pattern WORDS = Pattern.compile("(\\s*(\\S+)\\s*)");

    public static boolean moveFileToDir(File source, File destDir) {
        return FileUtils.moveFileToDir(source, destDir, true);
    }

    public static boolean moveFileToDir(File source, File destDir, boolean overwrite) {
        return source != null && FileUtils.moveFileToDir(source, destDir, source.getName(), overwrite);
    }

    public static boolean moveFileToDir(File source, File destDir, String newName, boolean overwrite) {
        if (source == null || destDir == null || !source.exists() || destDir.isFile()) {
            return false;
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            return false;
        }
        File destFile = new File(destDir, newName);
        if (destFile.equals(source)) {
            return true;
        }
        if (overwrite && destFile.exists()) {
            destFile.delete();
        }
        try {
            return source.renameTo(destFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static int moveFilesToDir(File[] files, File destDir, boolean overwrite) {
        int moved = 0;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (!FileUtils.moveFileToDir(file, destDir, overwrite)) continue;
            ++moved;
        }
        return moved;
    }

    public static void copyFiles(String sourceDirectory, String destDirectory) throws IOException {
        File s = new File(sourceDirectory);
        File[] files = s.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                File newDir = new File(destDirectory + File.separator + files[i].getName());
                newDir.mkdirs();
                FileUtils.copyFiles(sourceDirectory + File.separator + files[i].getName(), destDirectory + File.separator + files[i].getName());
                continue;
            }
            FileInputStream in = new FileInputStream(files[i]);
            FileOutputStream out = new FileOutputStream(destDirectory + File.separator + files[i].getName());
            FileUtils.copyFiles(in, out);
            out.close();
            ((InputStream)in).close();
        }
    }

    public static void copySingleFile(String sourceFile, String destinationDir) throws IOException {
        File f = new File(sourceFile);
        FileInputStream in = new FileInputStream(f);
        FileOutputStream out = new FileOutputStream(destinationDir + File.separator + f.getName());
        FileUtils.copyFiles(in, out);
        out.close();
        ((InputStream)in).close();
    }

    public static void copyFiles(InputStream in, OutputStream out) throws IOException {
        int bufferSize = 65536;
        byte[] buffer = new byte[bufferSize];
        boolean done = false;
        while (!done) {
            int read = in.read(buffer);
            if (read != -1) {
                out.write(buffer, 0, read);
                out.flush();
            }
            done = read == -1;
        }
    }

    public static File[] listFiles(String root, final String prefix, final String suffix) {
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(prefix) && name.endsWith(suffix);
            }
        };
        return new File(root).listFiles(ff);
    }

    public static String readFileToString(String filename) throws IOException {
        return FileUtils.readFileToString(filename, Charset.defaultCharset());
    }

    public static String readFileToString(String filename, String charset) throws IOException {
        if (charset == null) {
            return FileUtils.readFileToString(filename, Charset.defaultCharset());
        }
        Charset cs = Charset.forName(charset);
        return FileUtils.readFileToString(filename, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String filename, Charset charset) throws IOException {
        FileInputStream stream = new FileInputStream(filename);
        LineNumberReader reader = new LineNumberReader(new InputStreamReader((InputStream)stream, charset));
        String read = reader.readLine();
        String result = "";
        while (read != null) {
            try {
                result = result + read + "\n";
            }
            catch (Exception ex) {
                Logger.logException("FileUtils", ex);
            }
            finally {
                read = reader.readLine();
            }
        }
        reader.close();
        return result;
    }

    public static String getCurrentDir() {
        return System.getProperty("user.dir");
    }

    public static File getCurrentDirAsFile() {
        String s = System.getProperty("user.dir");
        return new File(s);
    }

    public static String buildCurrentDataDir(String relPath) {
        File f = new File(FileUtils.getCurrentDir() + File.separator + "data" + File.separator + relPath);
        f.mkdirs();
        return f.getAbsolutePath();
    }

    public static void writeTextToFile(String file, String text) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(text);
        fw.flush();
        fw.close();
    }

    public static void writeTextToFile(String file, String text, String encoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(text.getBytes(encoding));
        fos.flush();
        fos.close();
    }

    public static boolean appendTextToFileWithLocking(String file, String text) throws IOException {
        FileOutputStream fos = new FileOutputStream(file, true);
        FileLock fl = null;
        long retries = 300000L;
        while (fl == null && retries > 0L) {
            fl = fos.getChannel().tryLock();
            if (fl != null) continue;
            try {
                Thread.sleep(100L);
                retries -= 100L;
            }
            catch (InterruptedException e) {}
        }
        if (fl == null) {
            return false;
        }
        fos.write(text.getBytes());
        fos.flush();
        fl.release();
        fos.close();
        return true;
    }

    public static String getTempDir() {
        String tempDir = FileUtils.getCurrentDir() + File.separator + TEMP_DIR;
        return tempDir;
    }

    public static final boolean buildTempDir() {
        File f = new File(FileUtils.getTempDir());
        return f.mkdirs();
    }

    public static final boolean buildDir(String parent, String name) {
        File f = new File(parent + File.separator + name);
        return f.mkdirs();
    }

    public static final boolean buildDir(String name) {
        return FileUtils.buildDir(FileUtils.getCurrentDir(), name);
    }

    public static void removeFileRecurse(File f) {
        if (f.isDirectory()) {
            File[] content = f.listFiles();
            for (int i = 0; i < content.length; ++i) {
                FileUtils.removeFileRecurse(content[i]);
            }
        }
        f.delete();
    }

    public static long getFreeSpace(File file) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.indexOf("Windows") != -1) {
                return FileUtils.freeSpaceWindow(file);
            }
            if (osName.equals("Linux")) {
                return FileUtils.freeSpaceUnix(file);
            }
            System.err.println("Unknown os=" + osName);
            return FileUtils.freeSpaceUnix(file);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            return -1L;
        }
    }

    private static long freeSpaceUnix(File file) throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec("df");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Vector<String> allLines = new Vector<String>();
        while ((line = reader.readLine()) != null) {
            if (line.charAt(0) != '/') continue;
            allLines.add(line);
        }
        for (int i = allLines.size() - 1; i >= 0; --i) {
            String s = (String)allLines.elementAt(i);
            StringTokenizer token = new StringTokenizer(s);
            String dev = token.nextToken();
            String totalS = token.nextToken();
            String usedS = token.nextToken();
            String freeS = token.nextToken();
            String percentS = token.nextToken();
            String mount = token.nextToken();
            if (!file.getAbsolutePath().startsWith(mount)) continue;
            long free = Long.parseLong(freeS);
            return free;
        }
        return 0L;
    }

    public static Vector getUnixPartitions() throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec("df");
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Vector<String> allLines = new Vector<String>();
        while ((line = reader.readLine()) != null) {
            if (line.charAt(0) != '/') continue;
            StringTokenizer token = new StringTokenizer(line);
            String dev = token.nextToken();
            String totalS = token.nextToken();
            String usedS = token.nextToken();
            String freeS = token.nextToken();
            String percentS = token.nextToken();
            String mount = token.nextToken();
            allLines.add(mount);
        }
        return allLines;
    }

    private static long freeSpaceWindow(File file) throws IOException {
        String line;
        Process process = Runtime.getRuntime().exec("cmd /c dir /-c " + file.getAbsolutePath());
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null && !line.endsWith("libres") && !line.endsWith("free")) {
        }
        if (line == null) {
            return -1L;
        }
        line = line.substring(line.lastIndexOf(")") + 1);
        Matcher matcher = NON_DIGIT.matcher(line);
        line = matcher.replaceAll("");
        return Long.parseLong(line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(String file) {
        FileInputStream bufIn = null;
        try {
            bufIn = new FileInputStream(file);
            byte[] buffer = new byte[0x800000];
            int charsRead = bufIn.read(buffer);
            byte[] result = new byte[charsRead];
            System.arraycopy(buffer, 0, result, 0, charsRead);
            byte[] byArray = result;
            return byArray;
        }
        catch (IOException e) {
            Logger.logException("FileUtils", (Exception)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (bufIn != null) {
                try {
                    bufIn.close();
                }
                catch (IOException e) {
                    Logger.logException("FileUtils", (Exception)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObjectFrom(String file, String callerClass) {
        Object result = null;
        ObjectInput input = null;
        try {
            input = new ObjectInputStream(new FileInputStream(file));
            result = input.readObject();
        }
        catch (Exception e) {
            Logger.logException(callerClass, e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObjectTo(Object o, String file, String callerClass) {
        ObjectOutput output = null;
        try {
            output = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            output.writeObject(o);
        }
        catch (Exception e) {
            Logger.logException(callerClass, e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static boolean deleteFile(String filePath) {
        File file = new File(filePath);
        boolean delete = file.delete();
        return delete;
    }
}

