/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.utils.noarch;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.deversoft.utils.noarch.Formatters;
import ro.deversoft.utils.noarch.Logger;
import ro.deversoft.utils.noarch.QRCodeTextException;

public class UtilsNoarch {
    public static boolean numbersUseThousandsSeparator = false;

    public static String getQRCodeTextContentForTable(String appName, String entityName, String tablename) {
        String checksumBase = appName + entityName + tablename;
        String checksum = UtilsNoarch.computeChecksum(checksumBase);
        String text = appName + "|" + entityName + "|" + tablename + "|" + checksum + "|   soft by www.deversoft.ro   ";
        return text;
    }

    public static Vector<String> readQRCodeContentForTable(String fromScannerText, String expectedApp) throws QRCodeTextException {
        String computedSumBase;
        String computedSum;
        Vector result = UtilsNoarch.splitString(fromScannerText, '|');
        if (result.size() < 4) {
            throw new QRCodeTextException("Invalid format (message = " + fromScannerText + " , tokens = " + result.size() + ")");
        }
        String appName = (String)result.get(0);
        if (!appName.equals(expectedApp)) {
            throw new QRCodeTextException("Invalid APP (expected= " + expectedApp + " , found = " + appName + ")");
        }
        String entity = (String)result.get(1);
        String tablename = (String)result.get(2);
        String declaredSum = (String)result.get(3);
        if (!declaredSum.equals(computedSum = UtilsNoarch.computeChecksum(computedSumBase = appName + entity + tablename))) {
            throw new QRCodeTextException("Incorrect checksum (declared=" + declaredSum + " , calculated = " + computedSum + ")");
        }
        Vector<String> result2 = new Vector<String>();
        result2.add(appName);
        result2.add(entity);
        Vector tableDef = UtilsNoarch.splitString(tablename, ';');
        if (tableDef.size() < 2) {
            throw new QRCodeTextException("Incorrect table def : " + tablename);
        }
        result2.add((String)tableDef.get(0));
        result2.add((String)tableDef.get(1));
        return result2;
    }

    public static final void systemExit() {
        System.exit(0);
    }

    public static Vector splitString(String toSplit, char separator) {
        StringTokenizer token = new StringTokenizer(toSplit, "" + separator);
        Vector<String> result = new Vector<String>();
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            result.add(s);
        }
        return result;
    }

    public static Vector splitStringKeepStructure(String toSplit, char separator, char nullChar) {
        StringTokenizer token = new StringTokenizer(toSplit, "" + separator, true);
        Vector<String> result = new Vector<String>();
        boolean lastStringisSeparator = false;
        while (token.hasMoreTokens()) {
            String s = token.nextToken();
            if (s.equalsIgnoreCase("" + separator)) {
                if (lastStringisSeparator) {
                    result.add("" + nullChar);
                }
                lastStringisSeparator = true;
                continue;
            }
            lastStringisSeparator = false;
            result.add(s);
        }
        return result;
    }

    public static String joinString(String separator, List<String> items) {
        String result = "";
        for (String item : items) {
            result = result + item + separator;
        }
        if (result.length() > 0) {
            result = result.substring(0, result.length() - separator.length());
        }
        return result;
    }

    public static String joinString(String separator, String ... items) {
        ArrayList<String> result = new ArrayList<String>();
        for (String item : items) {
            result.add(item);
        }
        return UtilsNoarch.joinString(separator, result);
    }

    public static String computeChecksum(String allLicenceStrings) {
        try {
            if (allLicenceStrings == null || allLicenceStrings.length() < 1) {
                return null;
            }
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            allLicenceStrings = allLicenceStrings + "jkdf8hgj2dfhg7k345d1hfu53j4h5jhg4asb5ndh";
            encryptor.update(allLicenceStrings.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            return hex.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void processCsvFile(String filename, Map<Integer, String> headerResult, Vector<Map<String, String>> itemsResult, char separator, char nullChar) throws IOException {
        LineNumberReader reader = new LineNumberReader(new FileReader(filename));
        boolean isHeader = true;
        String line = reader.readLine();
        while (line != null) {
            Vector items = UtilsNoarch.splitStringKeepStructure(line, separator, nullChar);
            int column = 0;
            Map<String, String> resultLine = Collections.synchronizedMap(new LinkedHashMap());
            for (String item : items) {
                if (isHeader) {
                    headerResult.put(column, item);
                } else {
                    String columnName = headerResult.get(column);
                    resultLine.put(columnName, item);
                }
                ++column;
            }
            if (!isHeader) {
                itemsResult.add(resultLine);
            }
            isHeader = false;
            line = reader.readLine();
        }
    }

    public static String getDoubleWithDecimalPoint(String doubleWithoutDecimalPoint, int nrOfDecimalsAfterPoint) {
        String parteaIntreaga;
        String completeString = doubleWithoutDecimalPoint;
        if (doubleWithoutDecimalPoint.length() < nrOfDecimalsAfterPoint) {
            completeString = UtilsNoarch.getStringMaxSize(nrOfDecimalsAfterPoint, doubleWithoutDecimalPoint, Character.valueOf('0'), true);
        }
        if ((parteaIntreaga = completeString.substring(0, completeString.length() - nrOfDecimalsAfterPoint)).equals("")) {
            parteaIntreaga = "0";
        }
        String parteaFractionara = completeString.substring(completeString.length() - nrOfDecimalsAfterPoint, completeString.length());
        String result = parteaIntreaga + "." + parteaFractionara;
        return result;
    }

    public static String getStringMaxSize(int totalDigits, String toConvert, Character fillChar, boolean before) {
        if (toConvert == null) {
            toConvert = "";
        }
        if (toConvert.length() > totalDigits) {
            return toConvert.substring(0, totalDigits);
        }
        if (toConvert.length() < totalDigits) {
            String result = toConvert;
            if (fillChar != null) {
                for (int i = toConvert.length(); i < totalDigits; ++i) {
                    result = before ? fillChar.charValue() + result : result + fillChar.charValue();
                }
            }
            return result;
        }
        return toConvert;
    }

    public static InputStream executeGrabOutput(String directory, String ... exec) throws Throwable {
        String commandForDebug = "";
        for (String s : exec) {
            commandForDebug = commandForDebug + s + " ";
        }
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        if (directory != null) {
            File dir = new File(directory);
            String debugLine = "Execut \"" + commandForDebug + "\" din directorul \"" + dir.getAbsolutePath() + "\"";
            System.out.println(debugLine);
            pb.directory(dir);
        } else {
            String debugLine = "Execut \"" + commandForDebug + "\" din directorul default";
            System.out.println(debugLine);
        }
        pb.command(exec);
        pb.redirectErrorStream(true);
        Process onlineProcess = pb.start();
        return onlineProcess.getInputStream();
    }

    public static OS_TYPE detectOS() {
        OS_TYPE result = null;
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.startsWith("linux")) {
            result = OS_TYPE.LINUX;
        } else if (osname.startsWith("windows")) {
            result = OS_TYPE.WINDOWS;
        } else if (osname.startsWith("mac")) {
            result = OS_TYPE.MAC;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesFromClasspath(String filename, Class callerClass) {
        Properties properties = new Properties();
        InputStream stream = null;
        try {
            stream = callerClass.getResourceAsStream(filename);
            properties.load(stream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Properties properties3 = null;
            return properties3;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static int parseInt(String toParse) throws NumberFormatException {
        if (numbersUseThousandsSeparator) {
            try {
                Number num = Formatters.NUMBER_0DECIMALS_THOUSANDS.parse(toParse);
                return num.intValue();
            }
            catch (ParseException e) {
                throw new NumberFormatException(e.getMessage());
            }
        }
        try {
            return Formatters.NUMBER_0DECIMALS.parse(toParse).intValue();
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getMessage());
        }
    }

    public static Field[] sortFields(Field[] unknownOrder, final Map<String, Double> forcedOrder) {
        Vector<Field> sorted = new Vector<Field>();
        for (int i = 0; i < unknownOrder.length; ++i) {
            sorted.add(unknownOrder[i]);
        }
        Collections.sort(sorted, new Comparator<Field>(){

            @Override
            public int compare(Field field1, Field field2) {
                double d2;
                double d1 = (Double)forcedOrder.get(field1.getName());
                if (d1 < (d2 = ((Double)forcedOrder.get(field2.getName())).doubleValue())) {
                    return -1;
                }
                if (d2 < d1) {
                    return 1;
                }
                return 0;
            }
        });
        Field[] sortedFields = new Field[sorted.size()];
        int i = 0;
        for (Field field : sorted) {
            sortedFields[i++] = field;
        }
        return sortedFields;
    }

    public static boolean isValidEmailAddress(String email) {
        String ePattern = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern p = Pattern.compile(ePattern);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static String getSqlInSequenceForIdFields(Collection objectWithGetIdMethod) {
        try {
            Vector<Integer> ids = new Vector<Integer>();
            if (objectWithGetIdMethod != null) {
                for (Object o : objectWithGetIdMethod) {
                    Method[] allMethods;
                    Class<?> c = o.getClass();
                    for (Method method : allMethods = c.getMethods()) {
                        String methodName = method.getName();
                        if (!methodName.equals("getId")) continue;
                        int id = (Integer)method.invoke(o, new Object[0]);
                        ids.add(id);
                    }
                }
                return UtilsNoarch.getSqlInSequence(ids);
            }
        }
        catch (IllegalAccessException e) {
            Logger.logException(UtilsNoarch.class, (Exception)e);
        }
        catch (InvocationTargetException e) {
            Logger.logException(UtilsNoarch.class, (Exception)e);
        }
        return "";
    }

    public static String getSqlInSequence(Vector elements) {
        return UtilsNoarch.getSqlInSequence(elements, false);
    }

    public static String getSqlInSequence(Vector elements, boolean spaced) {
        return UtilsNoarch.getSqlInSequence(elements, spaced, ',');
    }

    public static String getSqlInSequence(Vector elements, boolean spaced, char separator) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < elements.size(); ++i) {
            Object id = elements.elementAt(i);
            sb.append(id);
            if (i >= elements.size() - 1) continue;
            sb.append(separator);
            if (!spaced) continue;
            sb.append(' ');
        }
        sb.append(")");
        return sb.toString();
    }

    public static enum OS_TYPE {
        WINDOWS,
        LINUX,
        MAC;

    }

    public static enum QRCODES_APP_NAMES {
        deverFoodPdaScanTable;

    }
}

