/*
 * Decompiled with CFR 0.152.
 */
package nu.xom;

import nu.xom.Element;
import nu.xom.IllegalDataException;
import nu.xom.IllegalNameException;
import nu.xom.NamespaceConflictException;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import nu.xom.Verifier;

public class Attribute
extends Node {
    private String localName;
    private String prefix;
    private String URI;
    private String value = "";
    private Type type;

    public Attribute(String localName, String value) {
        this(localName, "", value, Type.UNDECLARED);
    }

    public Attribute(String localName, String value, Type type) {
        this(localName, "", value, type);
    }

    public Attribute(String name, String URI, String value) {
        this(name, URI, value, Type.UNDECLARED);
    }

    public Attribute(String name, String URI, String value, Type type) {
        this.prefix = "";
        String localName = name;
        int prefixPosition = name.indexOf(58);
        if (prefixPosition > 0) {
            this.prefix = name.substring(0, prefixPosition);
            localName = name.substring(prefixPosition + 1);
        }
        try {
            this._setLocalName(localName);
        }
        catch (IllegalNameException ex) {
            ex.setData(name);
            throw ex;
        }
        this._setNamespace(this.prefix, URI);
        this._setValue(value);
        if (this.isXMLID()) {
            this._setType(Type.ID);
        } else {
            this._setType(type);
        }
    }

    public Attribute(Attribute attribute) {
        this.localName = attribute.localName;
        this.prefix = attribute.prefix;
        this.URI = attribute.URI;
        this.value = attribute.value;
        this.type = attribute.type;
    }

    private Attribute() {
    }

    static Attribute build(String qualifiedName, String URI, String value, Type type, String localName) {
        Attribute result = new Attribute();
        String prefix = "";
        int prefixPosition = qualifiedName.indexOf(58);
        if (prefixPosition >= 0) {
            prefix = qualifiedName.substring(0, prefixPosition);
            if ("xml:id".equals(qualifiedName)) {
                type = Type.ID;
                value = Attribute.normalize(value);
            }
        }
        result.localName = localName;
        result.prefix = prefix;
        result.type = type;
        result.URI = URI;
        result.value = value;
        return result;
    }

    private static String normalize(String s) {
        int length = s.length();
        int pos = 0;
        while (pos < length && s.charAt(pos) == ' ') {
            ++pos;
        }
        s = s.substring(pos);
        int end = s.length() - 1;
        while (end > 0 && s.charAt(end) == ' ') {
            --end;
        }
        if ((s = s.substring(0, end + 1)).indexOf("  ") < 0) {
            return s;
        }
        length = s.length();
        StringBuffer sb = new StringBuffer(length);
        boolean wasSpace = false;
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (c == ' ') {
                if (!wasSpace) {
                    sb.append(' ');
                    wasSpace = true;
                }
            } else {
                sb.append(c);
                wasSpace = false;
            }
            ++i;
        }
        return sb.toString();
    }

    public final Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new NullPointerException("Null attribute type");
        }
        if (this.isXMLID() && !Type.ID.equals(type)) {
            throw new IllegalDataException("Can't change type of xml:id attribute to " + type);
        }
        this._setType(type);
    }

    private boolean isXMLID() {
        return "xml".equals(this.prefix) && "id".equals(this.localName);
    }

    private void _setType(Type type) {
        this.type = type;
    }

    public final String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this._setValue(value);
    }

    private void _setValue(String value) {
        Verifier.checkPCDATA(value);
        this.value = value;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        if ("id".equals(localName) && "http://www.w3.org/XML/1998/namespace".equals(this.URI)) {
            Verifier.checkNCName(this.value);
        }
        this._setLocalName(localName);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setLocalName(String localName) {
        Verifier.checkNCName(localName);
        if (localName.equals("xmlns")) {
            throw new IllegalNameException("The Attribute class is not used for namespace declaration attributes.");
        }
        this.localName = localName;
    }

    public final String getQualifiedName() {
        if (this.prefix.length() == 0) {
            return this.localName;
        }
        return String.valueOf(this.prefix) + ":" + this.localName;
    }

    public final String getNamespaceURI() {
        return this.URI;
    }

    public final String getNamespacePrefix() {
        return this.prefix;
    }

    public void setNamespace(String prefix, String URI) {
        this._setNamespace(prefix, URI);
        if (this.isXMLID()) {
            this.setType(Type.ID);
        }
    }

    private void _setNamespace(String prefix, String URI) {
        Element element;
        String currentURI;
        if (URI == null) {
            URI = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        if (prefix.equals("xmlns")) {
            throw new IllegalNameException("Attribute objects are not used to represent  namespace declarations");
        }
        if (prefix.equals("xml") && !URI.equals("http://www.w3.org/XML/1998/namespace")) {
            throw new NamespaceConflictException("Wrong namespace URI for xml prefix: " + URI);
        }
        if (URI.equals("http://www.w3.org/XML/1998/namespace") && !prefix.equals("xml")) {
            throw new NamespaceConflictException("Wrong prefix for the XML namespace: " + prefix);
        }
        if (prefix.length() == 0) {
            if (URI.length() == 0) {
                this.prefix = "";
                this.URI = "";
                return;
            }
            throw new NamespaceConflictException("Unprefixed attribute " + this.localName + " cannot be in default namespace " + URI);
        }
        if (URI.length() == 0) {
            throw new NamespaceConflictException("Attribute prefixes must be declared.");
        }
        ParentNode parent = this.getParent();
        if (parent != null && (currentURI = (element = (Element)parent).getLocalNamespaceURI(prefix)) != null && !currentURI.equals(URI)) {
            throw new NamespaceConflictException("New prefix " + prefix + "conflicts with existing namespace declaration");
        }
        Verifier.checkAbsoluteURIReference(URI);
        Verifier.checkNCName(prefix);
        this.URI = URI;
        this.prefix = prefix;
    }

    public final Node getChild(int position) {
        throw new IndexOutOfBoundsException("Attributes do not have children");
    }

    public final int getChildCount() {
        return 0;
    }

    public Node copy() {
        return new Attribute(this);
    }

    public final String toXML() {
        return String.valueOf(this.getQualifiedName()) + "=\"" + Attribute.escapeText(this.value) + "\"";
    }

    public final String toString() {
        return "[" + this.getClass().getName() + ": " + this.getQualifiedName() + "=\"" + Text.escapeLineBreaksAndTruncate(this.getValue()) + "\"]";
    }

    private static String escapeText(String s) {
        int length = s.length();
        StringBuffer result = new StringBuffer(length + 12);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    result.append("&#x09;");
                    break;
                }
                case '\n': {
                    result.append("&#x0A;");
                    break;
                }
                case '\u000b': {
                    break;
                }
                case '\f': {
                    break;
                }
                case '\r': {
                    result.append("&#x0D;");
                    break;
                }
                case '\u000e': {
                    break;
                }
                case '\u000f': {
                    break;
                }
                case '\u0010': {
                    break;
                }
                case '\u0011': {
                    break;
                }
                case '\u0012': {
                    break;
                }
                case '\u0013': {
                    break;
                }
                case '\u0014': {
                    break;
                }
                case '\u0015': {
                    break;
                }
                case '\u0016': {
                    break;
                }
                case '\u0017': {
                    break;
                }
                case '\u0018': {
                    break;
                }
                case '\u0019': {
                    break;
                }
                case '\u001a': {
                    break;
                }
                case '\u001b': {
                    break;
                }
                case '\u001c': {
                    break;
                }
                case '\u001d': {
                    break;
                }
                case '\u001e': {
                    break;
                }
                case '\u001f': {
                    break;
                }
                case ' ': {
                    result.append(' ');
                    break;
                }
                case '!': {
                    result.append('!');
                    break;
                }
                case '\"': {
                    result.append("&quot;");
                    break;
                }
                case '#': {
                    result.append('#');
                    break;
                }
                case '$': {
                    result.append('$');
                    break;
                }
                case '%': {
                    result.append('%');
                    break;
                }
                case '&': {
                    result.append("&amp;");
                    break;
                }
                case '\'': {
                    result.append('\'');
                    break;
                }
                case '(': {
                    result.append('(');
                    break;
                }
                case ')': {
                    result.append(')');
                    break;
                }
                case '*': {
                    result.append('*');
                    break;
                }
                case '+': {
                    result.append('+');
                    break;
                }
                case ',': {
                    result.append(',');
                    break;
                }
                case '-': {
                    result.append('-');
                    break;
                }
                case '.': {
                    result.append('.');
                    break;
                }
                case '/': {
                    result.append('/');
                    break;
                }
                case '0': {
                    result.append('0');
                    break;
                }
                case '1': {
                    result.append('1');
                    break;
                }
                case '2': {
                    result.append('2');
                    break;
                }
                case '3': {
                    result.append('3');
                    break;
                }
                case '4': {
                    result.append('4');
                    break;
                }
                case '5': {
                    result.append('5');
                    break;
                }
                case '6': {
                    result.append('6');
                    break;
                }
                case '7': {
                    result.append('7');
                    break;
                }
                case '8': {
                    result.append('8');
                    break;
                }
                case '9': {
                    result.append('9');
                    break;
                }
                case ':': {
                    result.append(':');
                    break;
                }
                case ';': {
                    result.append(';');
                    break;
                }
                case '<': {
                    result.append("&lt;");
                    break;
                }
                case '=': {
                    result.append('=');
                    break;
                }
                case '>': {
                    result.append("&gt;");
                    break;
                }
                default: {
                    result.append(c);
                }
            }
            ++i;
        }
        return result.toString();
    }

    boolean isAttribute() {
        return true;
    }

    public static final class Type {
        public static final Type CDATA = new Type(1);
        public static final Type ID = new Type(2);
        public static final Type IDREF = new Type(3);
        public static final Type IDREFS = new Type(4);
        public static final Type NMTOKEN = new Type(5);
        public static final Type NMTOKENS = new Type(6);
        public static final Type NOTATION = new Type(7);
        public static final Type ENTITY = new Type(8);
        public static final Type ENTITIES = new Type(9);
        public static final Type ENUMERATION = new Type(10);
        public static final Type UNDECLARED = new Type(0);
        private final int type;

        public String getName() {
            switch (this.type) {
                case 0: {
                    return "UNDECLARED";
                }
                case 1: {
                    return "CDATA";
                }
                case 2: {
                    return "ID";
                }
                case 3: {
                    return "IDREF";
                }
                case 4: {
                    return "IDREFS";
                }
                case 5: {
                    return "NMTOKEN";
                }
                case 6: {
                    return "NMTOKENS";
                }
                case 7: {
                    return "NOTATION";
                }
                case 8: {
                    return "ENTITY";
                }
                case 9: {
                    return "ENTITIES";
                }
                case 10: {
                    return "ENUMERATION";
                }
            }
            throw new RuntimeException("Bug in XOM: unexpected attribute type: " + this.type);
        }

        private Type(int type) {
            this.type = type;
        }

        public int hashCode() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (this.hashCode() != o.hashCode()) {
                return false;
            }
            return o.getClass().getName().equals("nu.xom.Attribute.Type");
        }

        public String toString() {
            StringBuffer result = new StringBuffer("[Attribute.Type: ");
            result.append(this.getName());
            result.append(']');
            return result.toString();
        }
    }
}

