/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import java.awt.Polygon;
import java.util.BitSet;
import org.tigris.gef.presentation.FigPoly;
import org.tigris.gef.presentation.Handle;

public class FigSpline
extends FigPoly {
    private static final long serialVersionUID = 8105448783671550399L;
    protected int[] _xknots = new int[5];
    protected int[] _yknots = new int[5];
    protected int _nknots;
    protected Polygon _curve;
    protected int _threshold = 5;
    protected int SPLINE_THRESH = 2;
    protected int ARR_WIDTH = 5;
    protected int ARR_HEIGHT = 16;
    protected double _junc_t;
    protected double _delta0;
    protected double _delta1;
    protected double _denom;
    protected double _d_curve_length;
    protected int _juncX;
    protected int _juncY;
    protected int _pattern = -2004318072;
    protected BitSet _style = new BitSet(32);

    public FigSpline() {
    }

    public FigSpline(int x, int y) {
        this.addPoint(x, y);
    }

    public FigSpline(Color line_color) {
        super(line_color);
    }

    public FigSpline(Color line_color, Color fill_color) {
        super(line_color, fill_color);
    }

    public void addPoint(int x, int y) {
        super.addPoint(x, y);
        this.setCount();
        this.setSpline();
    }

    public void appendTwoPoints() {
        super.appendTwoPoints();
        this.setCount();
        this.setSpline();
    }

    public void cleanUp() {
    }

    private double dist(int x0, int y0, int x1, int y1) {
        double dx = x0 - x1;
        double dy = y0 - y1;
        return Math.sqrt(dx * dx + dy * dy);
    }

    protected void growIfNeeded() {
        if (this._npoints >= this._xpoints.length) {
            int[] tmp = new int[this._npoints * 2];
            System.arraycopy(this._xpoints, 0, tmp, 0, this._npoints);
            this._xpoints = tmp;
            tmp = new int[this._npoints * 2];
            System.arraycopy(this._ypoints, 0, tmp, 0, this._npoints);
            this._ypoints = tmp;
            tmp = new int[this._npoints * 4 - 1];
            System.arraycopy(this._xknots, 0, tmp, 0, this._nknots);
            this._xknots = tmp;
            tmp = new int[this._npoints * 4 - 1];
            System.arraycopy(this._yknots, 0, tmp, 0, this._nknots);
            this._yknots = tmp;
        }
    }

    public void insertPoint(int i, int x, int y) {
        super.insertPoint(i, x, y);
        this.setCount();
        this.setSpline();
    }

    public void moveVertex(Handle h, int x, int y, boolean ov) {
        super.moveVertex(h, x, y, ov);
        this.setSpline();
    }

    public void paint(Object g) {
        if (this._npoints == 2) {
            plotter.drawStraight(g, this._lineColor, this._xknots, this._yknots);
        } else {
            plotter.drawCurve(g, this._curve, this._filled, this._fillColor, this._lineColor, this._npoints, this._xknots, this._yknots);
        }
    }

    public void prependTwoPoints() {
        super.prependTwoPoints();
        this.setCount();
        this.setSpline();
    }

    public void removePoint(int i) {
        super.removePoint(i);
        this.setCount();
        this.setSpline();
    }

    protected void setCount() {
        if (this._npoints == 2) {
            this._nknots = 2;
        } else if (this._npoints == 3) {
            this._nknots = 3;
        }
        this._nknots = 2 * this._npoints - 3;
    }

    protected void setJunctionPoint(int p1x, int p1y, int p2x, int p2y, int p3x, int p3y) {
        this._delta0 = this.dist(p1x, p1y, p2x, p2y);
        this._delta1 = this.dist(p2x, p2y, p3x, p3y);
        this._denom = this._delta0 + this._delta1;
        this._junc_t = this._denom <= (double)this._threshold ? 0.0 : this._delta1 / this._denom;
        this._juncX = (int)(this._junc_t * (double)p2x + (1.0 - this._junc_t) * (double)p3x);
        this._juncY = (int)(this._junc_t * (double)p2y + (1.0 - this._junc_t) * (double)p3y);
    }

    protected void setSpline() {
        block4: {
            block3: {
                int i;
                if (this._npoints < 4) break block3;
                this._xknots[0] = this._xpoints[0];
                this._yknots[0] = this._ypoints[0];
                this._xknots[this._nknots - 1] = this._xpoints[this._npoints - 1];
                this._yknots[this._nknots - 1] = this._ypoints[this._npoints - 1];
                for (i = 0; i <= this._npoints - 4; ++i) {
                    this.setJunctionPoint(this._xpoints[i], this._ypoints[i], this._xpoints[i + 1], this._ypoints[i + 1], this._xpoints[i + 2], this._ypoints[i + 2]);
                    this._xknots[2 * (i + 1)] = this._juncX;
                    this._yknots[2 * (i + 1)] = this._juncY;
                }
                for (i = 1; i <= this._npoints - 2; ++i) {
                    this._xknots[2 * i - 1] = this._xpoints[i];
                    this._yknots[2 * i - 1] = this._ypoints[i];
                }
                break block4;
            }
            if (this._npoints >= 4) break block4;
            for (int i = 0; i < this._npoints; ++i) {
                this._xknots[i] = this._xpoints[i];
                this._yknots[i] = this._ypoints[i];
            }
        }
    }

    public void translateImpl(int dx, int dy) {
        super.translateImpl(dx, dy);
        this.setSpline();
    }
}

