/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi;

import com.google.code.gsonrmi.Invoker;
import com.google.code.gsonrmi.ParamValidationException;
import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.annotations.Injected;
import com.google.code.gsonrmi.annotations.ParamType;
import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class DefaultParamProcessor
implements Invoker.ParamProcessor {
    private final Gson paramDeserializer;

    public DefaultParamProcessor(Gson paramDeserializer) {
        this.paramDeserializer = paramDeserializer;
    }

    @Override
    public Object injectParam(Type paramType, Annotation[] paramAnnotations, Object context) throws ParamValidationException {
        return null;
    }

    @Override
    public Object processParam(Parameter param, Type paramType, Annotation[] paramAnnotations, Object context) throws ParamValidationException {
        if (param == null) {
            return null;
        }
        ParamType paramTypeAnnotation = this.findAnnotation(paramAnnotations, ParamType.class);
        if (paramTypeAnnotation != null) {
            paramType = paramTypeAnnotation.value();
        }
        return paramType.equals(Parameter.class) ? param : param.getValue((Type)paramType, this.paramDeserializer);
    }

    @Override
    public boolean isInjectedParam(Annotation[] paramAnnotations) {
        for (Annotation paramAnnotation : paramAnnotations) {
            if (this.findAnnotation(paramAnnotation.annotationType().getAnnotations(), Injected.class) == null) continue;
            return true;
        }
        return false;
    }

    protected <T> T findAnnotation(Annotation[] paramAnnotations, Class<T> type) {
        for (Annotation a : paramAnnotations) {
            if (!type.isInstance(a)) continue;
            return type.cast(a);
        }
        return null;
    }
}

