/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;

public class ExceptionSerializer
implements JsonSerializer<Exception>,
JsonDeserializer<Exception> {
    @Override
    public Exception deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        JsonObject o = json.getAsJsonObject();
        try {
            Class<?> clazz = Class.forName(o.get("class").getAsString());
            Constructor<?> cons = clazz.getConstructor(String.class);
            Exception src = (Exception)cons.newInstance(o.get("message").getAsString());
            StackTraceElement[] stackTrace = (StackTraceElement[])context.deserialize(o.get("stackTrace"), (Type)((Object)StackTraceElement[].class));
            src.setStackTrace(stackTrace);
            return src;
        }
        catch (Exception e) {
            return e;
        }
    }

    @Override
    public JsonElement serialize(Exception src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject o = new JsonObject();
        o.addProperty("class", src.getClass().getName());
        o.addProperty("message", src.getMessage());
        o.add("stackTrace", context.serialize(src.getStackTrace()));
        return o;
    }
}

