/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.AbstractSession;
import com.google.code.gsonrmi.transport.rmi.Callback;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.TimerTask;
import java.util.UUID;

public class Call {
    public final List<Route> targets;
    public final String method;
    public final Parameter[] params;
    public Callback callback;
    long timeSent;
    public static int defaultExpireSec = 60;
    public int expireSec = defaultExpireSec;

    public Call(Route target, String method, Object ... args) {
        this(Arrays.asList(target), method, args);
    }

    public Call(List<Route> targets, String method, Object ... args) {
        this.targets = targets;
        this.method = method;
        this.params = this.toParams(args);
    }

    public Call expire(int sec) {
        this.expireSec = sec;
        return this;
    }

    public boolean isExpired() {
        return this.expireSec > 0 && System.currentTimeMillis() - this.timeSent > (long)(this.expireSec * 1000);
    }

    public Call callback(URI target, String method, Object ... params) {
        return this.callback(new Route(target), method, params);
    }

    public Call callback(Route target, String method, Object ... args) {
        this.callback = new Callback();
        this.callback.target = target;
        this.callback.method = method;
        this.callback.params = this.toParams(args);
        return this;
    }

    public Call session(AbstractSession session) {
        if (this.callback == null) {
            throw new RuntimeException("Callback must be set before session");
        }
        if (session.id == null) {
            session.id = UUID.randomUUID().toString();
        }
        try {
            this.callback.session = session;
            this.callback.target.hops[0] = new URI(this.callback.target.hops[0].getScheme(), this.callback.target.hops[0].getSchemeSpecificPart(), session.id);
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(Transport t) {
        t.send(this.getMessage());
    }

    public TimerTask sendAfter(Transport t, long delay) {
        return t.sendAfter(this.getMessage(), delay);
    }

    public TimerTask sendEvery(Transport t, long delay, long period) {
        return t.sendEvery(this.getMessage(), delay, period);
    }

    private Message getMessage() {
        return new Message(null, Arrays.asList(new Route(URI.create("rmi:service"))), this);
    }

    private Parameter[] toParams(Object[] args) {
        Parameter[] params = new Parameter[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            params[i] = args[i] instanceof Parameter ? (Parameter)args[i] : new Parameter(args[i]);
        }
        return params;
    }
}

