/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.Callback;
import com.google.code.gsonrmi.transport.rmi.RpcHandler;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class DedicatedRpcHandler
implements RpcHandler {
    private final RpcHandler handler;
    private final Transport transport;
    private final Executor executor;

    public DedicatedRpcHandler(RpcHandler handler, Transport transport) {
        this(handler, transport, Executors.newSingleThreadExecutor());
    }

    public DedicatedRpcHandler(RpcHandler handler, Transport transport, Executor executor) {
        this.handler = handler;
        this.transport = transport;
        this.executor = executor;
    }

    public void start() {
    }

    @Override
    public RpcResponse handle(RpcRequest request, Route dest, Route src) {
        this.executor.execute(new RequestHandler(request, dest, src));
        return null;
    }

    @Override
    public void handle(RpcResponse response, Route dest, List<Route> srcs, Callback callback) {
        this.executor.execute(new ResponseHandler(response, dest, srcs, callback));
    }

    @Override
    public void shutdown() {
        this.executor.execute(new ShutdownHandler());
    }

    @Override
    public void periodicCleanup() {
        this.executor.execute(new CleanupHandler());
    }

    protected class CleanupHandler
    implements Runnable {
        protected CleanupHandler() {
        }

        @Override
        public void run() {
            DedicatedRpcHandler.this.handler.periodicCleanup();
        }
    }

    protected class ShutdownHandler
    implements Runnable {
        protected ShutdownHandler() {
        }

        @Override
        public void run() {
            DedicatedRpcHandler.this.handler.shutdown();
        }
    }

    protected class ResponseHandler
    implements Runnable {
        private final RpcResponse response;
        private final Route dest;
        private final List<Route> srcs;
        private final Callback callback;

        public ResponseHandler(RpcResponse response, Route dest, List<Route> srcs, Callback callback) {
            this.response = response;
            this.dest = dest;
            this.srcs = srcs;
            this.callback = callback;
        }

        @Override
        public void run() {
            DedicatedRpcHandler.this.handler.handle(this.response, this.dest, this.srcs, this.callback);
        }
    }

    protected class RequestHandler
    implements Runnable {
        private final RpcRequest request;
        private final Route dest;
        private final Route src;

        public RequestHandler(RpcRequest request, Route dest, Route src) {
            this.request = request;
            this.dest = dest;
            this.src = src;
        }

        @Override
        public void run() {
            RpcResponse response = DedicatedRpcHandler.this.handler.handle(this.request, this.dest, this.src);
            if (response != null) {
                if (response.id != null) {
                    DedicatedRpcHandler.this.transport.send(new Message(this.dest, Arrays.asList(this.src), response));
                } else if (response.error != null) {
                    System.err.println("Notification failed:  " + this.dest.hops[0] + " method " + this.request.method + ", " + response.error);
                    if (response.error.equals(RpcError.INVOCATION_EXCEPTION)) {
                        response.error.data.getValue(Exception.class, null).printStackTrace();
                    }
                }
            }
        }
    }
}

