/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.tcp;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class CompressedBlockInputStream
extends FilterInputStream {
    private byte[] inBuf = null;
    private int inLength = 0;
    private byte[] outBuf = null;
    private int outOffs = 0;
    private int outLength = 0;
    private Inflater inflater = new Inflater();

    public CompressedBlockInputStream(InputStream is) throws IOException {
        super(is);
    }

    private void readAndDecompress() throws IOException {
        int inCount;
        int ch4;
        int ch3;
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.inLength = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read()) | (ch3 = this.in.read()) | (ch4 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.outLength = (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
        if (this.inBuf == null || this.inLength > this.inBuf.length) {
            this.inBuf = new byte[this.inLength];
        }
        if (this.outBuf == null || this.outLength > this.outBuf.length) {
            this.outBuf = new byte[this.outLength];
        }
        for (int inOffs = 0; inOffs < this.inLength; inOffs += inCount) {
            inCount = this.in.read(this.inBuf, inOffs, this.inLength - inOffs);
            if (inCount != -1) continue;
            throw new EOFException();
        }
        this.inflater.setInput(this.inBuf, 0, this.inLength);
        try {
            this.inflater.inflate(this.outBuf);
        }
        catch (DataFormatException dfe) {
            throw new IOException("Data format exception - " + dfe.getMessage());
        }
        this.inflater.reset();
        this.outOffs = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.outOffs >= this.outLength) {
            try {
                this.readAndDecompress();
            }
            catch (EOFException eof) {
                return -1;
            }
        }
        return this.outBuf[this.outOffs++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        int toCopy;
        for (count = 0; count < len; count += toCopy) {
            if (this.outOffs >= this.outLength) {
                try {
                    if (count > 0 && this.in.available() == 0) {
                        return count;
                    }
                    this.readAndDecompress();
                }
                catch (EOFException eof) {
                    if (count == 0) {
                        count = -1;
                    }
                    return count;
                }
            }
            toCopy = Math.min(this.outLength - this.outOffs, len - count);
            System.arraycopy(this.outBuf, this.outOffs, b, off + count, toCopy);
            this.outOffs += toCopy;
        }
        return count;
    }

    @Override
    public int available() throws IOException {
        return this.outLength - this.outOffs + this.in.available();
    }
}

