/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.tcp;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class CompressedBlockOutputStream
extends FilterOutputStream {
    private byte[] inBuf = null;
    private byte[] outBuf = null;
    private int len = 0;
    private Deflater deflater = null;

    public CompressedBlockOutputStream(OutputStream os, int size) throws IOException {
        this(os, size, -1, 0);
    }

    public CompressedBlockOutputStream(OutputStream os, int size, int level, int strategy) throws IOException {
        super(os);
        this.inBuf = new byte[size];
        this.outBuf = new byte[size + 64];
        this.deflater = new Deflater(level);
        this.deflater.setStrategy(strategy);
    }

    protected void compressAndSend() throws IOException {
        if (this.len > 0) {
            this.deflater.setInput(this.inBuf, 0, this.len);
            this.deflater.finish();
            int size = this.deflater.deflate(this.outBuf);
            this.out.write(size >> 24 & 0xFF);
            this.out.write(size >> 16 & 0xFF);
            this.out.write(size >> 8 & 0xFF);
            this.out.write(size >> 0 & 0xFF);
            this.out.write(this.len >> 24 & 0xFF);
            this.out.write(this.len >> 16 & 0xFF);
            this.out.write(this.len >> 8 & 0xFF);
            this.out.write(this.len >> 0 & 0xFF);
            this.out.write(this.outBuf, 0, size);
            this.out.flush();
            this.len = 0;
            this.deflater.reset();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.inBuf[this.len++] = (byte)b;
        if (this.len == this.inBuf.length) {
            this.compressAndSend();
        }
    }

    @Override
    public void write(byte[] b, int boff, int blen) throws IOException {
        while (this.len + blen > this.inBuf.length) {
            int toCopy = this.inBuf.length - this.len;
            System.arraycopy(b, boff, this.inBuf, this.len, toCopy);
            this.len += toCopy;
            this.compressAndSend();
            boff += toCopy;
            blen -= toCopy;
        }
        System.arraycopy(b, boff, this.inBuf, this.len, blen);
        this.len += blen;
    }

    @Override
    public void flush() throws IOException {
        this.compressAndSend();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.compressAndSend();
        this.out.close();
    }
}

