/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.tcp;

import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Proxy;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TcpAccessProxy
extends Proxy {
    private final Listener listener;
    private final Options opts;

    public TcpAccessProxy(List<InetSocketAddress> listeningAddresses, Transport transport, Gson serializer) throws IOException {
        this(listeningAddresses, transport, serializer, new Options());
    }

    public TcpAccessProxy(List<InetSocketAddress> listeningAddresses, Transport transport, Gson serializer, Options options) throws IOException {
        super(transport, serializer, options);
        this.listener = new Listener(listeningAddresses);
        this.listener.start();
        this.opts = options;
    }

    @Override
    protected String getScheme() {
        return "tcpa";
    }

    @Override
    protected Proxy.Connection createConnection(String remoteAuthority) {
        return null;
    }

    @Override
    protected void handle(Transport.Shutdown m) {
        super.handle(m);
        this.listener.shutdown();
    }

    protected void setSocketOptions(SocketChannel sc) throws IOException {
        sc.socket().setKeepAlive(true);
    }

    public static class Options
    extends Proxy.Options {
        public int readBufferSize = 4096;
        public int writeBufferSize = 4096;
        public boolean keepAlive = true;
    }

    private class AccessConnection
    implements Proxy.Connection {
        private final SelectionKey key;
        private final URI remoteAddr;
        private final ByteBuffer readBuffer;
        private final ByteBuffer writeBuffer;
        private final Queue<ByteBuffer> sendQueue;
        private final List<Message> onConnectionClose;

        public AccessConnection(SelectionKey selectionKey, URI remoteAddress) {
            this.key = selectionKey;
            this.remoteAddr = remoteAddress;
            this.readBuffer = ByteBuffer.allocate(((TcpAccessProxy)TcpAccessProxy.this).opts.readBufferSize);
            this.writeBuffer = ByteBuffer.allocate(((TcpAccessProxy)TcpAccessProxy.this).opts.writeBufferSize);
            this.sendQueue = new ConcurrentLinkedQueue<ByteBuffer>();
            this.onConnectionClose = new LinkedList<Message>();
        }

        public void read() {
            block9: {
                SocketChannel sc = (SocketChannel)this.key.channel();
                try {
                    if (!this.readBuffer.hasRemaining()) {
                        throw new IOException("Line too long");
                    }
                    int tail = this.readBuffer.position();
                    int bytes = sc.read(this.readBuffer);
                    if (bytes > 0) {
                        byte[] b = this.readBuffer.array();
                        this.readBuffer.flip();
                        for (int i = tail; i < tail + bytes; ++i) {
                            if (b[i] != 10) continue;
                            String line = new String(b, this.readBuffer.position(), i - this.readBuffer.position());
                            Message m = TcpAccessProxy.this.gson.fromJson(line, Message.class);
                            if (m != null) {
                                TcpAccessProxy.this.transport.send(new Message(m.src.addFirst(this.remoteAddr), m.dests, m.content, m.contentType));
                            }
                            this.readBuffer.position(i + 1);
                        }
                        this.readBuffer.compact();
                        break block9;
                    }
                    if (bytes == -1) {
                        sc.close();
                        this.onClose();
                        break block9;
                    }
                    throw new IOException("Unexpected " + bytes + " bytes read");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        sc.close();
                        this.onClose();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }

        public void write() {
            SocketChannel sc = (SocketChannel)this.key.channel();
            while (this.writeBuffer.hasRemaining() && !this.sendQueue.isEmpty()) {
                ByteBuffer head = this.sendQueue.peek();
                if (head.remaining() <= this.writeBuffer.remaining()) {
                    this.writeBuffer.put(head);
                    this.sendQueue.remove();
                    continue;
                }
                head.limit(head.position() + this.writeBuffer.remaining());
                this.writeBuffer.put(head.slice());
                head.position(head.limit());
                head.limit(head.capacity());
            }
            try {
                this.writeBuffer.flip();
                sc.write(this.writeBuffer);
                this.writeBuffer.compact();
                if (this.writeBuffer.position() == 0 && this.sendQueue.isEmpty()) {
                    this.key.interestOps(this.key.interestOps() & 0xFFFFFFFB);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    sc.close();
                    this.onClose();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String getRemoteAuthority() {
            return this.remoteAddr.getAuthority();
        }

        @Override
        public boolean isAlive() {
            return ((SocketChannel)this.key.channel()).isConnected();
        }

        @Override
        public void send(Message m) {
            if (!m.contentOfType(Proxy.CheckConnection.class)) {
                if (m.contentOfType(Proxy.OnConnectionClosed.class)) {
                    this.onConnectionClose.add(m);
                } else {
                    try {
                        LinkedList<Route> dests = new LinkedList<Route>();
                        for (Route dest : m.dests) {
                            dests.add(dest.removeFirst());
                        }
                        String text = TcpAccessProxy.this.gson.toJson(new Message(m.src, dests, m.content, m.contentType)) + "\n";
                        this.sendQueue.add(ByteBuffer.wrap(text.getBytes("utf-8")));
                        this.key.interestOps(this.key.interestOps() | 4);
                        this.key.selector().wakeup();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    catch (CancelledKeyException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void shutdown() {
            try {
                ((SocketChannel)this.key.channel()).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void onClose() {
            for (Message m : this.onConnectionClose) {
                TcpAccessProxy.this.transport.send(new Message(null, Arrays.asList(m.src), new DeliveryFailure(m)));
            }
        }
    }

    private class Listener
    extends Thread {
        private final Selector selector = Selector.open();
        private boolean shutdown;

        public Listener(List<InetSocketAddress> addresses) throws IOException {
            for (InetSocketAddress address : addresses) {
                ServerSocketChannel channel = ServerSocketChannel.open();
                channel.configureBlocking(false);
                channel.socket().bind(address);
                channel.register(this.selector, 16);
            }
        }

        public void shutdown() {
            this.shutdown = true;
            this.selector.wakeup();
        }

        @Override
        public void run() {
            try {
                while (!this.shutdown) {
                    this.selector.select();
                    Set<SelectionKey> readyKeys = this.selector.selectedKeys();
                    Iterator<SelectionKey> readyItor = readyKeys.iterator();
                    while (readyItor.hasNext()) {
                        SelectionKey key = readyItor.next();
                        readyItor.remove();
                        if (!key.isValid()) continue;
                        if (key.isAcceptable()) {
                            SocketChannel sc = ((ServerSocketChannel)key.channel()).accept();
                            sc.configureBlocking(false);
                            TcpAccessProxy.this.setSocketOptions(sc);
                            SelectionKey k = sc.register(this.selector, 1);
                            InetSocketAddress addr = new InetSocketAddress(sc.socket().getInetAddress(), sc.socket().getPort());
                            AccessConnection con = new AccessConnection(k, new URI(TcpAccessProxy.this.getScheme(), addr.getHostName() + ":" + addr.getPort(), null, "a=1", null));
                            TcpAccessProxy.this.addConnection(con);
                            k.attach(con);
                            continue;
                        }
                        if (key.isReadable()) {
                            ((AccessConnection)key.attachment()).read();
                            continue;
                        }
                        if (!key.isWritable()) continue;
                        ((AccessConnection)key.attachment()).write();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            try {
                this.selector.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

