/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.export.utils;

import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;

public class Utils {
    public static String buildChannelName(String user, int port, String type) {
        return user + "_" + type + "_" + port;
    }

    public static String unescapeForSchema(String s) {
        s = s.replaceAll("__dot__", ".");
        s = s.replaceAll("__at__", "@");
        return s;
    }

    public static String escapeForSchema(String s) {
        s = s.replaceAll("\\.", "__dot__");
        s = s.replaceAll("@", "__at__");
        s = s.toLowerCase();
        return s;
    }

    public static String getSha1Checksum(File datafile) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            FileInputStream fis = new FileInputStream(datafile);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

