/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.filetransfer;

import eu.memshare.export.main.MemshareClient;
import eu.memshare.export.utils.Utils;
import eu.memshare.filetransfer.FileTransferJob;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class FileTransferClient
implements Runnable {
    private static FileTransferClient instance = null;
    private String ipServer;
    private int port = 33332;
    private int maxTimeout = 30000;
    private Vector<FileTransferJob> jobs = new Vector();
    private ExecutorService executor = Executors.newCachedThreadPool();

    private FileTransferClient() {
        this.ipServer = MemshareClient.getIpServer();
        Thread fileTransferThread = new Thread(this);
        fileTransferThread.setName("FileTransferClient");
        fileTransferThread.start();
    }

    public static synchronized FileTransferClient getInstance() {
        if (instance == null) {
            instance = new FileTransferClient();
        }
        return instance;
    }

    public synchronized void addJob(FileTransferJob toAdd) {
        this.jobs.add(toAdd);
    }

    @Override
    public void run() {
        block8: while (true) {
            try {
                while (true) {
                    if (this.jobs.size() > 0) {
                        final FileTransferJob job = this.jobs.remove(0);
                        switch (job.operation) {
                            case UPLOAD_TO_SERVER: {
                                this.executor.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileTransferClient.this.uploadFileToServer(job);
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                break;
                            }
                            case DOWNLOAD_FROM_SERVER: {
                                this.executor.submit(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            FileTransferClient.this.downloadFromServer(job);
                                        }
                                        catch (Throwable e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                            }
                        }
                    }
                    try {
                        Thread.sleep(100L);
                        continue block8;
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable th) {
                th.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void downloadFromServer(FileTransferJob job) throws IOException, ClassNotFoundException {
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
        ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        oos.writeObject((Object)FileTransferJob.CommandType.DOWNLOAD_FROM_SERVER);
        oos.writeObject(job.schema);
        oos.writeObject(job.checksum);
        oos.flush();
        FileOutputStream fileWriter = new FileOutputStream(job.localFilePath);
        byte[] inbuf = new byte[524288];
        long totalReceivedBytes = 0L;
        FileTransferStatusListener.Messages finalFeedback = null;
        long fileSize = ois.readLong();
        if (fileSize > 0L) {
            boolean isError = false;
            while (totalReceivedBytes < fileSize) {
                try {
                    int bytesRead = ois.read(inbuf, 0, inbuf.length);
                    if (bytesRead <= 0) break;
                    fileWriter.write(inbuf, 0, bytesRead);
                    fileWriter.flush();
                    oos.writeObject(totalReceivedBytes += (long)bytesRead);
                    oos.flush();
                    job.statusListener.bytesReceived(totalReceivedBytes, fileSize);
                }
                catch (SocketTimeoutException e) {
                    finalFeedback = FileTransferStatusListener.Messages.Timeout;
                    isError = true;
                    break;
                }
            }
            if (!isError) {
                job.statusListener.completed();
            }
        } else {
            job.statusListener.error(FileTransferStatusListener.Messages.FileNotFound.toString());
        }
        if (finalFeedback == null) {
            String newChecksum = Utils.getSha1Checksum(new File(job.localFilePath));
            finalFeedback = !newChecksum.equals(job.checksum) ? FileTransferStatusListener.Messages.Checksum_differs : FileTransferStatusListener.Messages.Transfer_completed;
        }
        oos.writeObject((Object)finalFeedback);
        oos.flush();
        fileWriter.close();
        oos.close();
        ois.close();
        socket.close();
    }

    private void uploadFileToServer(final FileTransferJob job) throws IOException, ClassNotFoundException {
        final File file = new File(job.localFilePath);
        Socket socket = new Socket(this.ipServer, this.port);
        socket.setSoLinger(false, 0);
        socket.setSoTimeout(this.maxTimeout);
        final ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
        final ObjectInputStream ois = new ObjectInputStream(socket.getInputStream());
        String checksum = Utils.getSha1Checksum(file);
        oos.writeObject((Object)FileTransferJob.CommandType.UPLOAD_TO_SERVER);
        oos.writeObject(job.schema);
        oos.writeObject(checksum);
        oos.writeLong(file.length());
        oos.flush();
        final BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
        final byte[] buf = new byte[0x100000];
        LinkedList<Callable<FileTransferStatusListener.Messages>> jobs = new LinkedList<Callable<FileTransferStatusListener.Messages>>();
        Callable<FileTransferStatusListener.Messages> sendToServer = new Callable<FileTransferStatusListener.Messages>(){

            @Override
            public FileTransferStatusListener.Messages call() throws Exception {
                int bytesReadFromFile;
                while ((bytesReadFromFile = fis.read(buf, 0, buf.length)) > 0) {
                    oos.write(buf, 0, bytesReadFromFile);
                    oos.flush();
                }
                return null;
            }
        };
        jobs.add(sendToServer);
        Callable<FileTransferStatusListener.Messages> receiveFeedback = new Callable<FileTransferStatusListener.Messages>(){

            @Override
            public FileTransferStatusListener.Messages call() throws Exception {
                FileTransferStatusListener.Messages transferResult = null;
                while (transferResult == null) {
                    long bytesReceivedByServer = -1L;
                    Object feedback = FileTransferClient.this.getBytesTransmitted(ois);
                    if (feedback != null) {
                        if (feedback instanceof FileTransferStatusListener.Messages) {
                            FileTransferStatusListener.Messages feed;
                            transferResult = feed = (FileTransferStatusListener.Messages)((Object)feedback);
                        } else {
                            bytesReceivedByServer = (Long)feedback;
                            job.statusListener.bytesReceived(bytesReceivedByServer, file.length());
                        }
                    }
                    if (feedback != null) continue;
                    transferResult = FileTransferStatusListener.Messages.Timeout;
                    break;
                }
                return transferResult;
            }
        };
        jobs.add(receiveFeedback);
        try {
            List results = this.executor.invokeAll(jobs);
            Enum finalResult = null;
            for (Future result : results) {
                if (result == null) continue;
                try {
                    finalResult = (FileTransferStatusListener.Messages)((Object)result.get());
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            if (finalResult != null) {
                switch (5.$SwitchMap$eu$memshare$filetransfer$FileTransferStatusListener$Messages[finalResult.ordinal()]) {
                    case 1: {
                        job.statusListener.completed();
                        break;
                    }
                    default: {
                        job.statusListener.error(finalResult.toString());
                        break;
                    }
                }
            } else {
                job.statusListener.interrupted();
            }
        }
        catch (InterruptedException e) {
            job.statusListener.interrupted();
        }
        fis.close();
        oos.close();
        ois.close();
        socket.close();
    }

    private Object getBytesTransmitted(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object feedback = null;
        try {
            feedback = ois.readObject();
        }
        catch (SocketTimeoutException e) {
            e.printStackTrace();
        }
        return feedback;
    }
}

