/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.presentation;

import java.awt.Color;
import org.tigris.gef.base.Globals;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigLine;

public class AnnotationProperties {
    private boolean fixedOffset = false;
    private boolean fixedRatio = false;
    private int offset = 10;
    private float ratio = 0.5f;
    private int connectingLineVisibilityDuration = 300;
    private FigLine line = new FigLine(0, 0, 0, 0);
    private Color lineColor = Color.red;

    public AnnotationProperties() {
        this(false, 5, false, 0.5f);
    }

    public AnnotationProperties(boolean fixedOffset, int offset, boolean fixedRatio, float ratio) {
        this.offset = offset;
        this.ratio = ratio;
        this.fixedOffset = fixedOffset;
        this.fixedRatio = fixedRatio;
    }

    public AnnotationProperties(int offset, float ratio) {
        this(false, offset, false, ratio);
    }

    public void setLineColor(Color c) {
        this.lineColor = c;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineVisibilityDuration(int millis) {
        this.connectingLineVisibilityDuration = millis;
    }

    public int getLineVisibilityDuration() {
        return this.connectingLineVisibilityDuration;
    }

    public boolean hasFixedRatio() {
        return this.fixedRatio;
    }

    public boolean hasFixedOffset() {
        return this.fixedOffset;
    }

    public float getRatio() {
        return this.ratio;
    }

    public void setRatio(float ratio, boolean fixedRatio) {
        this.ratio = ratio;
        this.fixedRatio = fixedRatio;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset, boolean fixedOffset) {
        this.offset = offset;
        this.fixedOffset = fixedOffset;
    }

    public FigLine getConnectingLine() {
        return this.line;
    }

    protected boolean lineIsVisible(Fig annotation) {
        return this.annotationIsVisible(annotation);
    }

    protected boolean annotationIsVisible(Fig annotation) {
        return true;
    }

    public synchronized void removeLine() {
        if (Globals.curEditor().getLayerManager().getContents().contains(this.line)) {
            this.line.removeFromDiagram();
        }
    }
}

