/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.util;

import java.awt.Toolkit;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Localizer {
    private static Map resourcesByLocale = new HashMap();
    private static Map resourceNames = new HashMap();
    private static Locale defaultLocale = Locale.getDefault();
    private static Map defaultResources = new HashMap();
    private static Log log;
    protected static final String SHORTCUT_MODIFIER = "shortcut";
    static /* synthetic */ Class class$org$tigris$gef$util$Localizer;

    public static boolean containsResource(String resource) {
        return resourceNames.containsValue(resource);
    }

    public static boolean containsLocale(Locale locale) {
        return resourcesByLocale.containsKey(locale);
    }

    public static void addLocale(Locale locale) {
        HashMap<String, ResourceBundle> resources = new HashMap<String, ResourceBundle>();
        Iterator iter = resourceNames.keySet().iterator();
        while (iter.hasNext()) {
            try {
                String binding = (String)iter.next();
                String resourceName = (String)resourceNames.get(binding);
                ResourceBundle bundle = ResourceBundle.getBundle(resourceName, locale);
                if (bundle == null || !(bundle instanceof ResourceBundle)) continue;
                resources.put(binding, bundle);
            }
            catch (MissingResourceException missing) {}
        }
        resourcesByLocale.put(locale, resources);
    }

    public static void switchCurrentLocale(Locale locale) {
        if (!resourcesByLocale.containsKey(locale)) {
            Localizer.addLocale(locale);
        }
        if (!defaultLocale.equals(locale)) {
            defaultLocale = locale;
            defaultResources = (Map)resourcesByLocale.get(locale);
        }
    }

    public static Locale getCurrentLocale() {
        return defaultLocale;
    }

    public static Map getResourcesFor(Locale locale) {
        if (!Localizer.containsLocale(locale)) {
            return null;
        }
        return (Map)resourcesByLocale.get(locale);
    }

    public static synchronized void addResource(String binding, String resourceName) throws MissingResourceException {
        Localizer.addResource(binding, resourceName, (class$org$tigris$gef$util$Localizer == null ? (class$org$tigris$gef$util$Localizer = Localizer.class$("org.tigris.gef.util.Localizer")) : class$org$tigris$gef$util$Localizer).getClassLoader());
    }

    public static synchronized void addResource(String binding, String resourceName, ClassLoader loader) throws MissingResourceException {
        if (Localizer.containsResource(resourceName)) {
            return;
        }
        Iterator iter = resourcesByLocale.keySet().iterator();
        while (iter.hasNext()) {
            Localizer.addResource(binding, resourceName, (Locale)iter.next(), loader);
        }
    }

    public static synchronized void addResource(String binding, String resourceName, Locale locale) throws MissingResourceException {
        Localizer.addResource(binding, resourceName, locale, (class$org$tigris$gef$util$Localizer == null ? (class$org$tigris$gef$util$Localizer = Localizer.class$("org.tigris.gef.util.Localizer")) : class$org$tigris$gef$util$Localizer).getClassLoader());
    }

    public static synchronized void addResource(String binding, String resourceName, Locale locale, ClassLoader loader) throws MissingResourceException {
        ResourceBundle resource = null;
        if (Localizer.containsLocale(locale)) {
            Map resources = (Map)resourcesByLocale.get(locale);
            resource = ResourceBundle.getBundle(resourceName, locale, loader);
            resources.put(binding, resource);
            if (!resourceNames.containsValue(resourceName)) {
                resourceNames.put(binding, resourceName);
            }
        } else {
            throw new MissingResourceException("Locale not found!", locale.toString(), resourceName);
        }
    }

    public static void removeLocale(Locale locale) {
        if (defaultLocale.equals(locale)) {
            Localizer.switchCurrentLocale(Locale.getDefault());
        }
        resourcesByLocale.remove(locale);
    }

    public static void removeResource(String binding) {
        Iterator iter = resourcesByLocale.keySet().iterator();
        while (iter.hasNext()) {
            Locale tmpLocale = (Locale)iter.next();
            ((Map)resourcesByLocale.get(tmpLocale)).remove(binding);
        }
        resourceNames.remove(binding);
    }

    public static String localize(String binding, String key) {
        return Localizer.localize(binding, key, defaultLocale, defaultResources);
    }

    public static String localize(String binding, String key, boolean localize) {
        return Localizer.localize(binding, key, defaultLocale, defaultResources, localize);
    }

    public static String localize(String binding, String key, Locale locale, Map resources, boolean localize) {
        if (localize) {
            return Localizer.localize(binding, key, locale, resources);
        }
        return key;
    }

    public static String localize(String binding, String key, Locale locale, Map resources) {
        boolean showErrors = false;
        if (locale == null || resources == null || !Localizer.containsLocale(locale)) {
            if (showErrors) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    log.warn((Object)("Localization failed for key " + key + " (binding: " + binding + ")"), (Throwable)e);
                }
            }
            return key;
        }
        String localized = null;
        ResourceBundle resource = (ResourceBundle)resources.get(binding);
        if (resource == null) {
            if (showErrors) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    log.warn((Object)("Localization failed for key " + key + " (binding: " + binding + ")"), (Throwable)e);
                }
            }
            return key;
        }
        try {
            localized = resource.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (localized == null) {
            if (showErrors) {
                try {
                    throw new Exception();
                }
                catch (Exception e) {
                    log.warn((Object)("Localization failed for key " + key + " (binding: " + binding + ")"), (Throwable)e);
                }
            }
            localized = key;
        }
        return localized;
    }

    public static boolean containsKey(String binding, String key) {
        return Localizer.containsKey(binding, key, defaultLocale, defaultResources);
    }

    public static boolean containsKey(String binding, String key, Locale locale, Map resources) {
        if (locale == null || resources == null || !Localizer.containsLocale(locale)) {
            return false;
        }
        ResourceBundle resource = (ResourceBundle)resources.get(binding);
        if (resource == null) {
            return false;
        }
        try {
            resource.getObject(key);
            return true;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public static Set getKeys(String binding) {
        Set keys = Localizer.getkeys(binding, defaultLocale, defaultResources);
        return keys;
    }

    private static Set getkeys(String binding, Locale locale, Map resources) {
        if (locale == null || resources == null || !Localizer.containsLocale(locale)) {
            return Collections.EMPTY_SET;
        }
        ResourceBundle resource = (ResourceBundle)resources.get(binding);
        if (resource == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> result = new HashSet<String>();
        Enumeration<String> keys = resource.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            result.add(key);
        }
        return result;
    }

    public static KeyStroke getShortcut(String binding, String key) {
        return Localizer.getShortcut(binding, key, defaultLocale, defaultResources);
    }

    public static KeyStroke getShortcut(String binding, String key, Locale locale, Map resources) {
        if (locale == null || resources == null || !Localizer.containsLocale(locale)) {
            return null;
        }
        KeyStroke stroke = null;
        ResourceBundle resource = (ResourceBundle)resources.get(binding);
        try {
            Object obj = resource.getObject(key);
            if (obj instanceof KeyStroke) {
                stroke = (KeyStroke)obj;
            } else if (obj instanceof String) {
                boolean hasShortcutModifier = false;
                StringBuffer shortcutBuf = new StringBuffer();
                StringTokenizer tokenizer = new StringTokenizer((String)obj);
                while (tokenizer.hasMoreTokens()) {
                    String token = tokenizer.nextToken();
                    if (token.equals(SHORTCUT_MODIFIER)) {
                        hasShortcutModifier = true;
                        continue;
                    }
                    shortcutBuf.append(token);
                    shortcutBuf.append(" ");
                }
                stroke = KeyStroke.getKeyStroke(shortcutBuf.toString());
                int modifiers = stroke.getModifiers() | (hasShortcutModifier ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() : 0);
                int keyCode = stroke.getKeyCode();
                stroke = KeyStroke.getKeyStroke(keyCode, modifiers);
            }
        }
        catch (MissingResourceException e) {
        }
        catch (ClassCastException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        return stroke;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        resourcesByLocale.put(defaultLocale, defaultResources);
        log = LogFactory.getLog((Class)(class$org$tigris$gef$util$Localizer == null ? (class$org$tigris$gef$util$Localizer = Localizer.class$("org.tigris.gef.util.Localizer")) : class$org$tigris$gef$util$Localizer));
    }
}

