/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.odf.microservices.fiscalreceipt;

import java.io.Serializable;
import ro.deversoft.odf.gearbox.common.domain.MeasurementUnitDDD;
import ro.deversoft.odf.microservices.fiscalreceipt.FiscalBodyLine;
import ro.deversoft.odf.microservices.fiscalreceipt.FiscalBodyLineTypeEnum;

public class FiscalProductSaleLine
implements FiscalBodyLine,
Serializable {
    String productName;
    double qty;
    double perUnitOriginalPrice;
    double perUnitDiscountedPrice;
    double perUnitDiscount;
    double valueOriginal;
    double valueDiscounted;
    double discount;
    double tvaValue;
    int tvaPercent;
    MeasurementUnitDDD measurementUnit;

    @Override
    public FiscalBodyLineTypeEnum getType() {
        return FiscalBodyLineTypeEnum.PRODUCT_SALE;
    }

    public static FiscalProductSaleLineBuilder builder() {
        return new FiscalProductSaleLineBuilder();
    }

    public String getProductName() {
        return this.productName;
    }

    public double getQty() {
        return this.qty;
    }

    public double getPerUnitOriginalPrice() {
        return this.perUnitOriginalPrice;
    }

    public double getPerUnitDiscountedPrice() {
        return this.perUnitDiscountedPrice;
    }

    public double getPerUnitDiscount() {
        return this.perUnitDiscount;
    }

    public double getValueOriginal() {
        return this.valueOriginal;
    }

    public double getValueDiscounted() {
        return this.valueDiscounted;
    }

    public double getDiscount() {
        return this.discount;
    }

    public double getTvaValue() {
        return this.tvaValue;
    }

    public int getTvaPercent() {
        return this.tvaPercent;
    }

    public MeasurementUnitDDD getMeasurementUnit() {
        return this.measurementUnit;
    }

    public FiscalProductSaleLine setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    public FiscalProductSaleLine setQty(double qty) {
        this.qty = qty;
        return this;
    }

    public FiscalProductSaleLine setPerUnitOriginalPrice(double perUnitOriginalPrice) {
        this.perUnitOriginalPrice = perUnitOriginalPrice;
        return this;
    }

    public FiscalProductSaleLine setPerUnitDiscountedPrice(double perUnitDiscountedPrice) {
        this.perUnitDiscountedPrice = perUnitDiscountedPrice;
        return this;
    }

    public FiscalProductSaleLine setPerUnitDiscount(double perUnitDiscount) {
        this.perUnitDiscount = perUnitDiscount;
        return this;
    }

    public FiscalProductSaleLine setValueOriginal(double valueOriginal) {
        this.valueOriginal = valueOriginal;
        return this;
    }

    public FiscalProductSaleLine setValueDiscounted(double valueDiscounted) {
        this.valueDiscounted = valueDiscounted;
        return this;
    }

    public FiscalProductSaleLine setDiscount(double discount) {
        this.discount = discount;
        return this;
    }

    public FiscalProductSaleLine setTvaValue(double tvaValue) {
        this.tvaValue = tvaValue;
        return this;
    }

    public FiscalProductSaleLine setTvaPercent(int tvaPercent) {
        this.tvaPercent = tvaPercent;
        return this;
    }

    public FiscalProductSaleLine setMeasurementUnit(MeasurementUnitDDD measurementUnit) {
        this.measurementUnit = measurementUnit;
        return this;
    }

    public FiscalProductSaleLine() {
    }

    public FiscalProductSaleLine(String productName, double qty, double perUnitOriginalPrice, double perUnitDiscountedPrice, double perUnitDiscount, double valueOriginal, double valueDiscounted, double discount, double tvaValue, int tvaPercent, MeasurementUnitDDD measurementUnit) {
        this.productName = productName;
        this.qty = qty;
        this.perUnitOriginalPrice = perUnitOriginalPrice;
        this.perUnitDiscountedPrice = perUnitDiscountedPrice;
        this.perUnitDiscount = perUnitDiscount;
        this.valueOriginal = valueOriginal;
        this.valueDiscounted = valueDiscounted;
        this.discount = discount;
        this.tvaValue = tvaValue;
        this.tvaPercent = tvaPercent;
        this.measurementUnit = measurementUnit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiscalProductSaleLine)) {
            return false;
        }
        FiscalProductSaleLine other = (FiscalProductSaleLine)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getQty(), other.getQty()) != 0) {
            return false;
        }
        if (Double.compare(this.getPerUnitOriginalPrice(), other.getPerUnitOriginalPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getPerUnitDiscountedPrice(), other.getPerUnitDiscountedPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getPerUnitDiscount(), other.getPerUnitDiscount()) != 0) {
            return false;
        }
        if (Double.compare(this.getValueOriginal(), other.getValueOriginal()) != 0) {
            return false;
        }
        if (Double.compare(this.getValueDiscounted(), other.getValueDiscounted()) != 0) {
            return false;
        }
        if (Double.compare(this.getDiscount(), other.getDiscount()) != 0) {
            return false;
        }
        if (Double.compare(this.getTvaValue(), other.getTvaValue()) != 0) {
            return false;
        }
        if (this.getTvaPercent() != other.getTvaPercent()) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        MeasurementUnitDDD this$measurementUnit = this.getMeasurementUnit();
        MeasurementUnitDDD other$measurementUnit = other.getMeasurementUnit();
        return !(this$measurementUnit == null ? other$measurementUnit != null : !this$measurementUnit.equals(other$measurementUnit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FiscalProductSaleLine;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $qty = Double.doubleToLongBits(this.getQty());
        result = result * 59 + (int)($qty >>> 32 ^ $qty);
        long $perUnitOriginalPrice = Double.doubleToLongBits(this.getPerUnitOriginalPrice());
        result = result * 59 + (int)($perUnitOriginalPrice >>> 32 ^ $perUnitOriginalPrice);
        long $perUnitDiscountedPrice = Double.doubleToLongBits(this.getPerUnitDiscountedPrice());
        result = result * 59 + (int)($perUnitDiscountedPrice >>> 32 ^ $perUnitDiscountedPrice);
        long $perUnitDiscount = Double.doubleToLongBits(this.getPerUnitDiscount());
        result = result * 59 + (int)($perUnitDiscount >>> 32 ^ $perUnitDiscount);
        long $valueOriginal = Double.doubleToLongBits(this.getValueOriginal());
        result = result * 59 + (int)($valueOriginal >>> 32 ^ $valueOriginal);
        long $valueDiscounted = Double.doubleToLongBits(this.getValueDiscounted());
        result = result * 59 + (int)($valueDiscounted >>> 32 ^ $valueDiscounted);
        long $discount = Double.doubleToLongBits(this.getDiscount());
        result = result * 59 + (int)($discount >>> 32 ^ $discount);
        long $tvaValue = Double.doubleToLongBits(this.getTvaValue());
        result = result * 59 + (int)($tvaValue >>> 32 ^ $tvaValue);
        result = result * 59 + this.getTvaPercent();
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        MeasurementUnitDDD $measurementUnit = this.getMeasurementUnit();
        result = result * 59 + ($measurementUnit == null ? 43 : $measurementUnit.hashCode());
        return result;
    }

    public String toString() {
        return "FiscalProductSaleLine(productName=" + this.getProductName() + ", qty=" + this.getQty() + ", perUnitOriginalPrice=" + this.getPerUnitOriginalPrice() + ", perUnitDiscountedPrice=" + this.getPerUnitDiscountedPrice() + ", perUnitDiscount=" + this.getPerUnitDiscount() + ", valueOriginal=" + this.getValueOriginal() + ", valueDiscounted=" + this.getValueDiscounted() + ", discount=" + this.getDiscount() + ", tvaValue=" + this.getTvaValue() + ", tvaPercent=" + this.getTvaPercent() + ", measurementUnit=" + this.getMeasurementUnit() + ")";
    }

    public static class FiscalProductSaleLineBuilder {
        private String productName;
        private double qty;
        private double perUnitOriginalPrice;
        private double perUnitDiscountedPrice;
        private double perUnitDiscount;
        private double valueOriginal;
        private double valueDiscounted;
        private double discount;
        private double tvaValue;
        private int tvaPercent;
        private MeasurementUnitDDD measurementUnit;

        FiscalProductSaleLineBuilder() {
        }

        public FiscalProductSaleLineBuilder setProductName(String productName) {
            this.productName = productName;
            return this;
        }

        public FiscalProductSaleLineBuilder setQty(double qty) {
            this.qty = qty;
            return this;
        }

        public FiscalProductSaleLineBuilder setPerUnitOriginalPrice(double perUnitOriginalPrice) {
            this.perUnitOriginalPrice = perUnitOriginalPrice;
            return this;
        }

        public FiscalProductSaleLineBuilder setPerUnitDiscountedPrice(double perUnitDiscountedPrice) {
            this.perUnitDiscountedPrice = perUnitDiscountedPrice;
            return this;
        }

        public FiscalProductSaleLineBuilder setPerUnitDiscount(double perUnitDiscount) {
            this.perUnitDiscount = perUnitDiscount;
            return this;
        }

        public FiscalProductSaleLineBuilder setValueOriginal(double valueOriginal) {
            this.valueOriginal = valueOriginal;
            return this;
        }

        public FiscalProductSaleLineBuilder setValueDiscounted(double valueDiscounted) {
            this.valueDiscounted = valueDiscounted;
            return this;
        }

        public FiscalProductSaleLineBuilder setDiscount(double discount) {
            this.discount = discount;
            return this;
        }

        public FiscalProductSaleLineBuilder setTvaValue(double tvaValue) {
            this.tvaValue = tvaValue;
            return this;
        }

        public FiscalProductSaleLineBuilder setTvaPercent(int tvaPercent) {
            this.tvaPercent = tvaPercent;
            return this;
        }

        public FiscalProductSaleLineBuilder setMeasurementUnit(MeasurementUnitDDD measurementUnit) {
            this.measurementUnit = measurementUnit;
            return this;
        }

        public FiscalProductSaleLine build() {
            return new FiscalProductSaleLine(this.productName, this.qty, this.perUnitOriginalPrice, this.perUnitDiscountedPrice, this.perUnitDiscount, this.valueOriginal, this.valueDiscounted, this.discount, this.tvaValue, this.tvaPercent, this.measurementUnit);
        }

        public String toString() {
            return "FiscalProductSaleLine.FiscalProductSaleLineBuilder(productName=" + this.productName + ", qty=" + this.qty + ", perUnitOriginalPrice=" + this.perUnitOriginalPrice + ", perUnitDiscountedPrice=" + this.perUnitDiscountedPrice + ", perUnitDiscount=" + this.perUnitDiscount + ", valueOriginal=" + this.valueOriginal + ", valueDiscounted=" + this.valueDiscounted + ", discount=" + this.discount + ", tvaValue=" + this.tvaValue + ", tvaPercent=" + this.tvaPercent + ", measurementUnit=" + this.measurementUnit + ")";
        }
    }
}

