/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.Color;
import java.awt.Dimension;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class Header
extends JComponent {
    protected Color[] background;
    protected Color[] foreground;
    boolean opaque = true;
    final String[] fColumnNames = new String[]{"Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"};
    String[] columnNames = new String[this.fColumnNames.length];
    private static final String uiClassID = "HeaderUI";
    private ResourceBundle rb;
    int cols;
    int n;
    public Dimension cellSize = new Dimension(22, 20);

    public Header(int cols) {
        this.cols = cols;
        System.arraycopy(this.fColumnNames, 0, this.columnNames, 0, this.fColumnNames.length);
        this.setFirstDay(1);
        this.setCellSize(this.cellSize);
        this.updateUI();
        this.background = new Color[this.columnNames.length];
        this.foreground = new Color[this.columnNames.length];
    }

    public void updateUI() {
        this.registerUIDelegate();
        this.setOpaque(false);
        this.setUI(UIManager.getUI(this));
    }

    protected void registerUIDelegate() {
        if (UIManager.get(uiClassID) == null) {
            String uiDelegateClassName = "mseries.plaf.basic.BasicHeaderUI";
            String lafName = UIManager.getLookAndFeel().getName();
            if (lafName.equals("Windows")) {
                uiDelegateClassName = "mseries.plaf." + lafName + ".WindowsHeaderUI";
            } else if (lafName.equals("Metal")) {
                uiDelegateClassName = "mseries.plaf." + lafName + ".MetalHeaderUI";
            } else if (lafName.equals("Motif")) {
                uiDelegateClassName = "mseries.plaf." + lafName + ".MotifHeaderUI";
            }
            UIManager.put(uiClassID, uiDelegateClassName);
        }
    }

    public void setTextLocalizer(ResourceBundle rb) {
        this.rb = rb;
    }

    public void setFirstDay(int firstDay) {
        this.shiftColumnNames(firstDay - 1);
    }

    private String getString(String source, String def) {
        String newString;
        if (this.rb == null) {
            return def;
        }
        try {
            newString = this.rb.getString(source);
        }
        catch (MissingResourceException e) {
            newString = def;
        }
        return newString;
    }

    private void shiftColumnNames(int places) {
        this.n = places;
        int i = 0;
        while (i < this.cols) {
            this.columnNames[i] = this.fColumnNames[this.n];
            ++this.n;
            if (this.n == this.cols) {
                this.n = 0;
            }
            ++i;
        }
    }

    public String getColumnName(int columnIndex) {
        return this.getString(this.columnNames[columnIndex], this.columnNames[columnIndex]);
    }

    public int getCols() {
        return this.cols;
    }

    public void setForeground(int day, Color color) {
        this.foreground[day - 1] = color;
    }

    public void setBackground(int day, Color color) {
        this.background[day - 1] = color;
    }

    public void setBackground(Color[] colors) {
        this.background = colors;
    }

    public void setForeground(Color[] colors) {
        this.foreground = colors;
    }

    public Color getBackground(int day) {
        int i = day + this.n;
        i = i > 6 ? i - 7 : i;
        Color c = this.background[i];
        if (c == null) {
            return this.getBackground();
        }
        return c;
    }

    public Color getForeground(int day) {
        int i = day + this.n;
        i = i > 6 ? i - 7 : i;
        Color c = this.foreground[i];
        if (c == null) {
            return this.getForeground();
        }
        return c;
    }

    public boolean isFocusable() {
        return false;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setCellSize(Dimension cellSize) {
        this.cellSize = cellSize;
        Dimension size = new Dimension(1, 1);
        size.width = this.cols * cellSize.width;
        size.height = cellSize.height;
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public Dimension getCellSize() {
        return this.cellSize;
    }
}

