/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr;

import java.awt.Font;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class BasicUtils {
    public static final int CAPITAL_CASE = 1;
    public static final int NON_CAPITAL_CASE = 0;
    public static final String HEX_CHARS = "0123456789ABCDEF";
    static /* synthetic */ Class class$0;

    public static String byte2HexString(byte b, String prefix) {
        return String.valueOf(prefix) + HEX_CHARS.charAt(b >> 4 & 0xF) + HEX_CHARS.charAt(0xF & b);
    }

    public static String bytes2HexString(byte[] bytes) {
        return BasicUtils.bytes2HexString(bytes, " 0x");
    }

    public static String bytes2HexString(byte[] bytes, String separator) {
        if (bytes == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            buffer.append(BasicUtils.byte2HexString(bytes[i], separator));
            ++i;
        }
        return buffer.length() == 0 ? "" : buffer.substring(1);
    }

    public static String changeCase(String src, int newCase) {
        String s = new String(src);
        if (src.length() == 0) {
            return src;
        }
        switch (newCase) {
            case 0: {
                return String.valueOf(s.substring(0, 1).toLowerCase()) + s.substring(1);
            }
            case 1: {
                return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
            }
        }
        return s;
    }

    public static void replaceChars(char[] array, char replaceable, char replacement) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == replaceable) {
                array[i] = replacement;
            }
            ++i;
        }
    }

    public static String encodeFont(Font f) {
        StringBuffer bf = new StringBuffer();
        bf.append(f.getFamily());
        bf.append("-");
        bf.append(f.isBold() ? "BOLD" : "");
        bf.append(f.isItalic() ? "ITALIC" : "");
        bf.append("-");
        bf.append(f.getSize());
        return bf.toString();
    }

    public static byte[] hexString2bytes(String src) {
        return BasicUtils.hexString2bytes(src, " ");
    }

    public static byte[] hexString2bytes(String src, String delimiter) {
        if (src == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(BasicUtils.replaceString(src, "0x", ""), delimiter, false);
        byte[] result = new byte[st.countTokens()];
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)Integer.parseInt(st.nextToken(), 16);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        byte[] b = new byte[256];
        String[] unp = BasicUtils.removeBlanks(BasicUtils.unpack(";core/remote admin service", ';'));
        String[] trm = BasicUtils.removeBlanks(new String[]{"abc", "abc", "xxxx", "", "xyz", "zzzzz", "", "", "qtf", "abur"});
        int i = 0;
        while (i < unp.length) {
            System.out.println("[" + unp[i] + "]");
            ++i;
        }
    }

    public static int max(int[] elements) {
        if (elements.length < 1) {
            throw new Error("there is no maximum for less than one element");
        }
        int max = elements[0];
        int i = 0;
        while (i < elements.length) {
            max = Math.max(max, elements[i]);
            ++i;
        }
        return max;
    }

    public static ArrayList asList(Object[] array) {
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static Object[] mergeArrays(Object[] a) {
        int ln = 0;
        int i = 0;
        while (i < a.length) {
            ln += ((Object[])a[i]).length;
            ++i;
        }
        Object[] c = new String[ln];
        int i2 = 0;
        int index = 0;
        while (i2 < a.length) {
            System.arraycopy(a[i2], 0, c, index, ((Object[])a[i2]).length);
            index += ((Object[])a[i2]).length;
            ++i2;
        }
        return c;
    }

    public static int min(int[] elements) {
        if (elements.length < 1) {
            throw new Error("there is no minimum for less than one element");
        }
        int min = elements[0];
        int i = 0;
        while (i < elements.length) {
            min = Math.min(min, elements[i]);
            ++i;
        }
        return min;
    }

    public static String pack(Object[] args, String separator) {
        StringBuffer result = new StringBuffer();
        String varMarker = separator.equals("$") ? "&" : "$";
        int i = 0;
        while (i < args.length) {
            if (args[i] == null) {
                result.append(String.valueOf(varMarker) + "{null}");
            } else {
                result.append(BasicUtils.replaceString(args[i].toString(), separator, String.valueOf(varMarker) + "{separator}"));
                if (i < args.length - 1) {
                    result.append(separator);
                }
            }
            ++i;
        }
        return result.toString();
    }

    public static String smartReplaceString(String src, String replaceable, String replacement) {
        int startPos = 0;
        int cPos = src.indexOf(replaceable);
        int nextPos = -1;
        int indent = 0;
        if (cPos == -1) {
            return src;
        }
        StringBuffer sb = new StringBuffer();
        String indentedReplacement = replacement;
        while (cPos < src.length()) {
            indent = src.lastIndexOf(10, cPos);
            if (indent != -1) {
                char[] characters = (char[])Array.newInstance(Character.TYPE, cPos - indent - 1);
                Arrays.fill(characters, ' ');
                indentedReplacement = BasicUtils.replaceString(replacement, "\n", "\n" + String.valueOf(characters));
            }
            sb.append(src.substring(startPos, cPos));
            sb.append(indentedReplacement);
            startPos = cPos + replaceable.length();
            cPos = src.indexOf(replaceable, startPos);
            if (cPos != -1) continue;
            cPos = src.length();
            sb.append(src.substring(startPos, cPos));
        }
        return sb.toString();
    }

    public static String[] removeBlanks(String[] arg) {
        int blankCount = 0;
        int i = 0;
        while (i < arg.length) {
            if (arg[i] == null || arg[i].length() == 0) {
                ++blankCount;
            }
            ++i;
        }
        String[] result = new String[arg.length - blankCount];
        int i2 = 0;
        int k = 0;
        while (i2 < arg.length) {
            if (arg[i2] != null && arg[i2].length() != 0) {
                result[k++] = arg[i2];
            }
            ++i2;
        }
        return result;
    }

    public static Vector stringToVector(String s) {
        Vector<String> result = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, ";", false);
        while (st.hasMoreTokens()) {
            result.addElement(st.nextToken());
        }
        return result;
    }

    public static String[] unpack(String arg, char separator) {
        return BasicUtils.unpack(arg, separator, false);
    }

    public static long upRound(double d) {
        return (long)d + (long)(d % (double)((long)d) != 0.0 ? 1 : 0);
    }

    public static int upRound(float f) {
        return (int)BasicUtils.upRound((double)f);
    }

    public static String vectorToString(Vector v) {
        String data = "";
        int i = 0;
        while (i < v.size()) {
            data = String.valueOf(data) + v.elementAt(i).toString() + ";";
            ++i;
        }
        return data;
    }

    public static String[] unpack(String arg, char separator, boolean trimSpaces) {
        int tokenCount = 1;
        int indexBefore = 0;
        char varMarker = separator == '$' ? (char)'&' : '$';
        int i = 0;
        while (i < arg.length()) {
            if (arg.charAt(i) == separator) {
                ++tokenCount;
            }
            ++i;
        }
        String[] values = new String[tokenCount];
        int i2 = 0;
        int k = 0;
        while (k < values.length) {
            if (i2 >= arg.length() - 1 || arg.charAt(i2) == separator) {
                if (indexBefore == i2) {
                    values[k] = new String();
                } else {
                    values[k] = arg.substring(indexBefore, i2 >= arg.length() - 1 ? i2 + 1 : i2);
                    if (trimSpaces) {
                        values[k] = values[k].trim();
                    }
                    values[k] = BasicUtils.replaceString(values[k], " {separator}".replace(' ', varMarker), "" + separator);
                    if (values[k].equals(" {null}".replace(' ', varMarker))) {
                        values[k] = null;
                    }
                }
                indexBefore = i2 + 1;
                ++k;
            }
            ++i2;
        }
        return values;
    }

    public static int findInArray(Object array, Object element) {
        int index = 0;
        while (index < Array.getLength(array)) {
            if (Array.get(array, index) == element) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static Object removeFromArray(Object array, Object element) {
        int index = BasicUtils.findInArray(array, element);
        if (index != -1) {
            return BasicUtils.removeFromArray(array, index);
        }
        return array;
    }

    public static Object removeFromArray(Object array, int index) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), ((Object[])array).length - 1);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index + 1, newArray, index, ((Object[])array).length - index - 1);
        return newArray;
    }

    public static Object insertIntoArray(Object array, Object object, int index) {
        Object newArray = Array.newInstance(array.getClass().getComponentType(), ((Object[])array).length + 1);
        System.arraycopy(array, 0, newArray, 0, index);
        System.arraycopy(array, index, newArray, index + 1, ((Object[])array).length - index);
        Array.set(newArray, index, object);
        return newArray;
    }

    public static String replaceString(String src, String replaceable, String replacement) {
        int startPos = 0;
        int cPos = src.indexOf(replaceable);
        int nextPos = -1;
        if (cPos == -1) {
            return src;
        }
        StringBuffer sb = new StringBuffer();
        while (cPos < src.length()) {
            sb.append(src.substring(startPos, cPos));
            sb.append(replacement);
            startPos = cPos + replaceable.length();
            cPos = src.indexOf(replaceable, startPos);
            if (cPos != -1) continue;
            cPos = src.length();
            sb.append(src.substring(startPos, cPos));
        }
        return sb.toString();
    }

    public static String buildMessage(Throwable exception) {
        StringBuffer buffer = new StringBuffer();
        while (exception != null) {
            buffer.append(exception.toString());
            exception = exception.getCause();
            if (exception == null) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

