/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.io;

import com.shfarr.DevUtils;
import com.shfarr.beans.ObjectDecoder;
import com.shfarr.beans.ObjectEncoder;
import com.shfarr.beans.XMLDecoder;
import com.shfarr.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.PropertyResourceBundle;

public class IOUtils {
    public static Object bytes2Object(byte[] src, boolean xml) {
        return IOUtils.bytes2Object(src, null, xml);
    }

    public static Object bytes2Object(byte[] src, ObjectDecoder decoder, boolean xml) {
        Object loadedObj;
        block10: {
            loadedObj = null;
            ObjectInputStream oStream = null;
            ByteArrayInputStream bStream = new ByteArrayInputStream(src);
            try {
                try {
                    if (!xml) {
                        oStream = new ObjectInputStream(bStream);
                        loadedObj = oStream.readObject();
                        oStream.close();
                        break block10;
                    }
                    XMLDecoder xmlDecoder = new XMLDecoder(bStream, decoder);
                    loadedObj = xmlDecoder.readObject();
                    xmlDecoder.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    bStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return loadedObj;
    }

    public static Object file2Object(String path) {
        return IOUtils.file2Object(path, null);
    }

    public static Object file2Object(String path, ObjectDecoder decoder) {
        Object loadedObj = null;
        FileInputStream fis = null;
        boolean xml = path.toLowerCase().endsWith(".xml");
        try {
            try {
                fis = new FileInputStream(path);
                byte[] data = new byte[fis.available()];
                fis.read(data, 0, data.length);
                loadedObj = IOUtils.bytes2Object(data, decoder, xml);
            }
            catch (Exception e) {
                if (DevUtils.debuging("io")) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return loadedObj;
    }

    public static Object xml2Object(URL url, ObjectDecoder decoder) throws IOException {
        return IOUtils.bytes2Object(IOUtils.load(url), decoder, true);
    }

    public static void save(byte[] data, String path) {
        try {
            FileOutputStream fos = new FileOutputStream(path);
            fos.write(data);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] load(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        InputStream stream = url.openStream();
        return IOUtils.load(stream);
    }

    public static byte[] load(InputStream stream) throws IOException {
        byte[] buffer = new byte[]{};
        int amount = -1;
        do {
            byte[] bytes;
            if ((amount = stream.read(bytes = new byte[1024])) == -1) continue;
            byte[] newBuffer = new byte[buffer.length + amount];
            System.arraycopy(buffer, 0, newBuffer, newBuffer.length - amount - buffer.length, buffer.length);
            System.arraycopy(bytes, 0, newBuffer, newBuffer.length - amount, amount);
            buffer = newBuffer;
        } while (amount != -1);
        stream.close();
        return buffer;
    }

    public static byte[] object2Bytes(Object obj, boolean xml) {
        return IOUtils.object2Bytes(obj, null, xml);
    }

    public static byte[] object2Bytes(Object obj, ObjectEncoder encoder, boolean xml) {
        ByteArrayOutputStream bStream;
        block11: {
            ObjectOutputStream oStream = null;
            bStream = null;
            try {
                try {
                    bStream = new ByteArrayOutputStream();
                    if (!xml) {
                        oStream = new ObjectOutputStream(bStream);
                        oStream.writeObject(obj);
                        oStream.close();
                        break block11;
                    }
                    XMLEncoder xmlEncoder = new XMLEncoder(bStream, encoder);
                    xmlEncoder.writeObject(obj);
                    xmlEncoder.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                try {
                    if (oStream != null) {
                        oStream.close();
                    }
                    bStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return bStream.toByteArray();
    }

    public static boolean object2File(Object obj, String path) {
        return IOUtils.object2File(obj, path, null);
    }

    public static boolean delete(String path) {
        File file = new File(path);
        boolean deleted = true;
        if (file.isDirectory()) {
            String[] names = file.list();
            int i = 0;
            while (i < names.length) {
                deleted = deleted && IOUtils.delete(String.valueOf(path) + "/" + names[i]);
                ++i;
            }
        }
        return deleted && file.delete();
    }

    public static List list(String path) {
        ArrayList list = new ArrayList();
        IOUtils.list(path, list, path);
        return list;
    }

    private static void list(String path, ArrayList list, String prefix) {
        File file = new File(path);
        if (file.isDirectory()) {
            String[] names = file.list();
            int i = 0;
            while (i < names.length) {
                String name = String.valueOf(path) + "/" + names[i];
                File element = new File(name);
                if (element.isDirectory()) {
                    IOUtils.list(name, list, prefix);
                } else {
                    list.add(name.substring(prefix.length()));
                }
                ++i;
            }
        }
    }

    public static boolean object2File(Object obj, String path, ObjectEncoder encoder) {
        boolean result = false;
        FileOutputStream fos = null;
        boolean xml = path.toLowerCase().endsWith(".xml");
        try {
            try {
                if (path.indexOf("/") != -1) {
                    File dir = new File(path.substring(0, path.lastIndexOf("/")));
                    dir.mkdirs();
                }
                fos = new FileOutputStream(path);
                fos.write(IOUtils.object2Bytes(obj, encoder, xml));
                fos.flush();
                result = true;
            }
            catch (Exception e) {
                if (DevUtils.debuging("io")) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            try {
                fos.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static void loadProperties() {
        PropertyResourceBundle properties = null;
        try {
            properties = new PropertyResourceBundle(new FileInputStream(System.getProperty("properties")));
        }
        catch (Exception e) {
            System.err.println("Must provide valid -Dproperties=${property file} system property");
            System.exit(1);
        }
        Enumeration<String> keys = properties.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith("//")) continue;
            System.out.println(String.valueOf(key) + " = " + properties.getString(key));
            System.setProperty(key, properties.getString(key));
        }
    }
}

