/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.LazilyParsedNumber;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.util.Map;

final class TypeAdapters$25
extends TypeAdapter<JsonElement> {
    TypeAdapters$25() {
    }

    @Override
    public final JsonElement read(JsonReader object) {
        switch (((JsonReader)object).peek()) {
            case STRING: {
                return new JsonPrimitive(((JsonReader)object).nextString());
            }
            case NUMBER: {
                object = ((JsonReader)object).nextString();
                return new JsonPrimitive(new LazilyParsedNumber((String)object));
            }
            case BOOLEAN: {
                return new JsonPrimitive(((JsonReader)object).nextBoolean());
            }
            case NULL: {
                ((JsonReader)object).nextNull();
                return JsonNull.INSTANCE;
            }
            case BEGIN_ARRAY: {
                JsonArray jsonArray = new JsonArray();
                ((JsonReader)object).beginArray();
                while (((JsonReader)object).hasNext()) {
                    jsonArray.add(this.read((JsonReader)object));
                }
                ((JsonReader)object).endArray();
                return jsonArray;
            }
            case BEGIN_OBJECT: {
                JsonObject jsonObject = new JsonObject();
                ((JsonReader)object).beginObject();
                while (((JsonReader)object).hasNext()) {
                    jsonObject.add(((JsonReader)object).nextName(), this.read((JsonReader)object));
                }
                ((JsonReader)object).endObject();
                return jsonObject;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public final void write(JsonWriter jsonWriter, JsonElement iterator) {
        if (iterator == null || ((JsonElement)((Object)iterator)).isJsonNull()) {
            jsonWriter.nullValue();
            return;
        }
        if (((JsonElement)((Object)iterator)).isJsonPrimitive()) {
            if (((JsonPrimitive)((Object)(iterator = ((JsonElement)((Object)iterator)).getAsJsonPrimitive()))).isNumber()) {
                jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsNumber());
                return;
            }
            if (((JsonPrimitive)((Object)iterator)).isBoolean()) {
                jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsBoolean());
                return;
            }
            jsonWriter.value(((JsonPrimitive)((Object)iterator)).getAsString());
            return;
        }
        if (((JsonElement)((Object)iterator)).isJsonArray()) {
            jsonWriter.beginArray();
            for (JsonElement jsonElement : ((JsonElement)((Object)iterator)).getAsJsonArray()) {
                this.write(jsonWriter, jsonElement);
            }
            jsonWriter.endArray();
            return;
        }
        if (((JsonElement)((Object)iterator)).isJsonObject()) {
            jsonWriter.beginObject();
            for (Map.Entry<String, JsonElement> entry : ((JsonElement)((Object)iterator)).getAsJsonObject().entrySet()) {
                jsonWriter.name(entry.getKey());
                this.write(jsonWriter, entry.getValue());
            }
            jsonWriter.endObject();
            return;
        }
        throw new IllegalArgumentException("Couldn't write " + iterator.getClass());
    }
}

