/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.multi.MultipleBarcodeReader;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import com.google.zxing.pdf417.decoder.PDF417ScanningDecoder;
import com.google.zxing.pdf417.detector.Detector;
import com.google.zxing.pdf417.detector.PDF417DetectorResult;
import java.util.ArrayList;
import java.util.Map;

public final class PDF417Reader
implements Reader,
MultipleBarcodeReader {
    @Override
    public final Result decode(BinaryBitmap binaryBitmap) {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap resultArray, Map<DecodeHintType, ?> map) {
        if ((resultArray = PDF417Reader.a((BinaryBitmap)resultArray, map, false)) == null || resultArray.length == 0 || resultArray[0] == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        return resultArray[0];
    }

    @Override
    public final Result[] decodeMultiple(BinaryBitmap binaryBitmap) {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public final Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) {
        try {
            return PDF417Reader.a(binaryBitmap, map, true);
        }
        catch (ChecksumException | FormatException readerException) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static Result[] a(BinaryBitmap object, Map<DecodeHintType, ?> object2, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = Detector.detect((BinaryBitmap)object, object2, bl2);
        object2 = ((PDF417DetectorResult)object).getPoints().iterator();
        while (object2.hasNext()) {
            Object object3;
            Object object4 = object3 = (ResultPoint[])object2.next();
            int n2 = Math.min(Math.min(PDF417Reader.b(object3[0], object4[4]), PDF417Reader.b(object4[6], object4[2]) * 17 / 18), Math.min(PDF417Reader.b(object4[1], object4[5]), PDF417Reader.b(object4[7], object4[3]) * 17 / 18));
            object4 = object3;
            object4 = PDF417ScanningDecoder.decode(((PDF417DetectorResult)object).getBits(), object3[4], object3[5], object3[6], object3[7], n2, Math.max(Math.max(PDF417Reader.a(object3[0], object4[4]), PDF417Reader.a(object4[6], object4[2]) * 17 / 18), Math.max(PDF417Reader.a(object4[1], object4[5]), PDF417Reader.a(object4[7], object4[3]) * 17 / 18)));
            object3 = new Result(((DecoderResult)object4).getText(), ((DecoderResult)object4).getRawBytes(), (ResultPoint[])object3, BarcodeFormat.PDF_417);
            ((Result)object3).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, ((DecoderResult)object4).getECLevel());
            object4 = (PDF417ResultMetadata)((DecoderResult)object4).getOther();
            if (object4 != null) {
                ((Result)object3).putMetadata(ResultMetadataType.PDF417_EXTRA_METADATA, object4);
            }
            arrayList.add(object3);
        }
        return arrayList.toArray(new Result[arrayList.size()]);
    }

    private static int a(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return 0;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    private static int b(ResultPoint resultPoint, ResultPoint resultPoint2) {
        if (resultPoint == null || resultPoint2 == null) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.abs(resultPoint.getX() - resultPoint2.getX());
    }

    @Override
    public final void reset() {
    }
}

