/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitSource;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.StringUtils;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

final class DecodedBitStreamParser {
    private static final char[] a = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ $%*+-./:".toCharArray();

    private DecodedBitStreamParser() {
    }

    static DecoderResult a(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel, Map<DecodeHintType, ?> map) {
        BitSource bitSource = new BitSource(byArray);
        StringBuilder stringBuilder = new StringBuilder(50);
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>(1);
        int n2 = -1;
        int n3 = -1;
        try {
            Mode mode;
            Object object = null;
            boolean bl2 = false;
            block15: do {
                mode = bitSource.available() < 4 ? Mode.TERMINATOR : Mode.forBits(bitSource.readBits(4));
                block1 : switch (mode) {
                    case TERMINATOR: {
                        break;
                    }
                    case FNC1_FIRST_POSITION: 
                    case FNC1_SECOND_POSITION: {
                        bl2 = true;
                        break;
                    }
                    case STRUCTURED_APPEND: {
                        if (bitSource.available() < 16) {
                            throw FormatException.getFormatInstance();
                        }
                        n2 = bitSource.readBits(8);
                        n3 = bitSource.readBits(8);
                        break;
                    }
                    case ECI: {
                        int n4;
                        object = bitSource;
                        int n5 = ((BitSource)object).readBits(8);
                        if ((n5 & 0x80) == 0) {
                            n4 = n5 & 0x7F;
                        } else if ((n5 & 0xC0) == 128) {
                            int n6 = ((BitSource)object).readBits(8);
                            n4 = (n5 & 0x3F) << 8 | n6;
                        } else if ((n5 & 0xE0) == 192) {
                            int n7 = ((BitSource)object).readBits(16);
                            n4 = (n5 & 0x1F) << 16 | n7;
                        } else {
                            throw FormatException.getFormatInstance();
                        }
                        object = CharacterSetECI.getCharacterSetECIByValue(n4);
                        if (object != null) continue block15;
                        throw FormatException.getFormatInstance();
                    }
                    case HANZI: {
                        int n5 = bitSource.readBits(4);
                        int n8 = bitSource.readBits(mode.getCharacterCountBits(version));
                        if (n5 != 1) continue block15;
                        DecodedBitStreamParser.a(bitSource, stringBuilder, n8);
                        break;
                    }
                    default: {
                        int n5 = bitSource.readBits(mode.getCharacterCountBits(version));
                        switch (mode) {
                            case NUMERIC: {
                                DecodedBitStreamParser.c(bitSource, stringBuilder, n5);
                                break block1;
                            }
                            case ALPHANUMERIC: {
                                DecodedBitStreamParser.a(bitSource, stringBuilder, n5, bl2);
                                break block1;
                            }
                            case BYTE: {
                                DecodedBitStreamParser.a(bitSource, stringBuilder, n5, (CharacterSetECI)((Object)object), arrayList, map);
                                break block1;
                            }
                            case KANJI: {
                                DecodedBitStreamParser.b(bitSource, stringBuilder, n5);
                                break block1;
                            }
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
            } while (mode != Mode.TERMINATOR);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FormatException.getFormatInstance();
        }
        return new DecoderResult(byArray, stringBuilder.toString(), arrayList.isEmpty() ? null : arrayList, errorCorrectionLevel == null ? null : errorCorrectionLevel.toString(), n2, n3);
    }

    private static void a(BitSource bitSource, StringBuilder stringBuilder, int n2) {
        if (n2 * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = bitSource.readBits(13);
            n4 = (n4 = n4 / 96 << 8 | n4 % 96) < 959 ? (n4 += 41377) : (n4 += 42657);
            byArray[n3] = (byte)(n4 >> 8);
            byArray[n3 + 1] = (byte)n4;
            n3 += 2;
            --n2;
        }
        try {
            stringBuilder.append(new String(byArray, "GB2312"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void b(BitSource bitSource, StringBuilder stringBuilder, int n2) {
        if (n2 * 13 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        while (n2 > 0) {
            int n4 = bitSource.readBits(13);
            n4 = (n4 = n4 / 192 << 8 | n4 % 192) < 7936 ? (n4 += 33088) : (n4 += 49472);
            byArray[n3] = (byte)(n4 >> 8);
            byArray[n3 + 1] = (byte)n4;
            n3 += 2;
            --n2;
        }
        try {
            stringBuilder.append(new String(byArray, "SJIS"));
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
    }

    private static void a(BitSource bitSource, StringBuilder stringBuilder, int n2, CharacterSetECI characterSetECI, Collection<byte[]> collection, Map<DecodeHintType, ?> map) {
        if (n2 << 3 > bitSource.available()) {
            throw FormatException.getFormatInstance();
        }
        byte[] byArray = new byte[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)bitSource.readBits(8);
        }
        String string = characterSetECI == null ? StringUtils.guessEncoding(byArray, map) : characterSetECI.name();
        try {
            stringBuilder.append(new String(byArray, string));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw FormatException.getFormatInstance();
        }
        collection.add(byArray);
    }

    private static char a(int n2) {
        if (n2 >= a.length) {
            throw FormatException.getFormatInstance();
        }
        return a[n2];
    }

    private static void a(BitSource bitSource, StringBuilder stringBuilder, int n2, boolean bl2) {
        int n3;
        int n4 = stringBuilder.length();
        while (n2 > 1) {
            if (bitSource.available() < 11) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(11);
            stringBuilder.append(DecodedBitStreamParser.a(n3 / 45));
            stringBuilder.append(DecodedBitStreamParser.a(n3 % 45));
            n2 -= 2;
        }
        if (n2 == 1) {
            if (bitSource.available() < 6) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.a(bitSource.readBits(6)));
        }
        if (bl2) {
            for (n3 = n4; n3 < stringBuilder.length(); ++n3) {
                if (stringBuilder.charAt(n3) != '%') continue;
                if (n3 < stringBuilder.length() - 1 && stringBuilder.charAt(n3 + 1) == '%') {
                    stringBuilder.deleteCharAt(n3 + 1);
                    continue;
                }
                stringBuilder.setCharAt(n3, '\u001d');
            }
        }
    }

    private static void c(BitSource bitSource, StringBuilder stringBuilder, int n2) {
        int n3;
        while (n2 >= 3) {
            if (bitSource.available() < 10) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(10);
            if (n3 >= 1000) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.a(n3 / 100));
            stringBuilder.append(DecodedBitStreamParser.a(n3 / 10 % 10));
            stringBuilder.append(DecodedBitStreamParser.a(n3 % 10));
            n2 -= 3;
        }
        if (n2 == 2) {
            if (bitSource.available() < 7) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(7);
            if (n3 >= 100) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.a(n3 / 10));
            stringBuilder.append(DecodedBitStreamParser.a(n3 % 10));
            return;
        }
        if (n2 == 1) {
            if (bitSource.available() < 4) {
                throw FormatException.getFormatInstance();
            }
            n3 = bitSource.readBits(4);
            if (n3 >= 10) {
                throw FormatException.getFormatInstance();
            }
            stringBuilder.append(DecodedBitStreamParser.a(n3));
        }
    }
}

