/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.Logger;
import com.j256.ormlite.logger.LoggerFactory;
import com.j256.ormlite.stmt.StatementBuilder$StatementInfo;
import com.j256.ormlite.stmt.StatementBuilder$StatementType;
import com.j256.ormlite.stmt.StatementBuilder$WhereOperation;
import com.j256.ormlite.stmt.Where;
import com.j256.ormlite.stmt.mapped.MappedPreparedStmt;
import com.j256.ormlite.table.TableInfo;
import java.util.ArrayList;
import java.util.List;

public abstract class StatementBuilder<T, ID> {
    private static Logger logger = LoggerFactory.getLogger(StatementBuilder.class);
    public final TableInfo<T, ID> tableInfo;
    protected final String tableName;
    public final m databaseType;
    protected final Dao<T, ID> dao;
    protected StatementBuilder$StatementType type;
    protected boolean addTableName;
    protected Where<T, ID> where = null;

    public StatementBuilder(m m2, TableInfo<T, ID> tableInfo, Dao<T, ID> dao, StatementBuilder$StatementType statementBuilder$StatementType) {
        this.databaseType = m2;
        this.tableInfo = tableInfo;
        this.tableName = tableInfo.getTableName();
        this.dao = dao;
        this.type = statementBuilder$StatementType;
        if (!statementBuilder$StatementType.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)statementBuilder$StatementType) + " statement is not allowed");
        }
    }

    public Where<T, ID> where() {
        this.where = new Where<T, ID>(this.tableInfo, this, this.databaseType);
        return this.where;
    }

    public void setWhere(Where<T, ID> where) {
        this.where = where;
    }

    protected MappedPreparedStmt<T, ID> prepareStatement(Long l2) {
        FieldType[] fieldTypeArray = new ArrayList();
        String string = this.buildStatementString((List<w>)fieldTypeArray);
        w[] wArray = fieldTypeArray.toArray(new w[fieldTypeArray.size()]);
        FieldType[] fieldTypeArray2 = this.getResultFieldTypes();
        fieldTypeArray = new FieldType[fieldTypeArray.size()];
        for (int i2 = 0; i2 < wArray.length; ++i2) {
            fieldTypeArray[i2] = wArray[i2].getFieldType();
        }
        if (!this.type.isOkForStatementBuilder()) {
            throw new IllegalStateException("Building a statement from a " + (Object)((Object)this.type) + " statement is not allowed");
        }
        return new MappedPreparedStmt<T, ID>(this.tableInfo, string, fieldTypeArray, fieldTypeArray2, wArray, this.databaseType.isLimitSqlSupported() ? null : l2, this.type);
    }

    public String prepareStatementString() {
        ArrayList<w> arrayList = new ArrayList<w>();
        return this.buildStatementString(arrayList);
    }

    public StatementBuilder$StatementInfo prepareStatementInfo() {
        ArrayList<w> arrayList = new ArrayList<w>();
        String string = this.buildStatementString(arrayList);
        return new StatementBuilder$StatementInfo(string, arrayList, null);
    }

    @Deprecated
    public void clear() {
        this.reset();
    }

    public void reset() {
        this.where = null;
    }

    protected String buildStatementString(List<w> object) {
        StringBuilder stringBuilder = new StringBuilder(128);
        this.appendStatementString(stringBuilder, (List<w>)object);
        object = stringBuilder.toString();
        logger.debug("built statement {}", object);
        return object;
    }

    protected void appendStatementString(StringBuilder stringBuilder, List<w> list) {
        this.appendStatementStart(stringBuilder, list);
        this.appendWhereStatement(stringBuilder, list, StatementBuilder$WhereOperation.FIRST);
        this.appendStatementEnd(stringBuilder, list);
    }

    public abstract void appendStatementStart(StringBuilder var1, List<w> var2);

    protected boolean appendWhereStatement(StringBuilder stringBuilder, List<w> list, StatementBuilder$WhereOperation statementBuilder$WhereOperation) {
        if (this.where == null) {
            return statementBuilder$WhereOperation == StatementBuilder$WhereOperation.FIRST;
        }
        statementBuilder$WhereOperation.appendBefore(stringBuilder);
        this.where.appendSql(this.addTableName ? this.tableName : null, stringBuilder, list);
        statementBuilder$WhereOperation.appendAfter(stringBuilder);
        return false;
    }

    public abstract void appendStatementEnd(StringBuilder var1, List<w> var2);

    protected boolean shouldPrependTableNameToColumns() {
        return false;
    }

    protected FieldType[] getResultFieldTypes() {
        return null;
    }

    protected FieldType verifyColumnName(String string) {
        return this.tableInfo.getFieldTypeByColumnName(string);
    }

    StatementBuilder$StatementType getType() {
        return this.type;
    }
}

