/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.QueryBuilder$InternalQueryBuilderWrapper;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.Between;
import com.j256.ormlite.stmt.query.Exists;
import com.j256.ormlite.stmt.query.In;
import com.j256.ormlite.stmt.query.InSubQuery;
import com.j256.ormlite.stmt.query.ManyClause;
import com.j256.ormlite.stmt.query.Not;
import com.j256.ormlite.stmt.query.Raw;
import com.j256.ormlite.stmt.query.SimpleComparison;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Where<T, ID> {
    private static final int START_CLAUSE_SIZE = 4;
    private final TableInfo<T, ID> tableInfo;
    private final StatementBuilder<T, ID> statementBuilder;
    private final FieldType idFieldType;
    private final String idColumnName;
    private final m databaseType;
    private F[] clauseStack = new F[4];
    private int clauseStackLevel = 0;
    private J needsFuture = null;

    Where(TableInfo<T, ID> tableInfo, StatementBuilder<T, ID> statementBuilder, m m2) {
        this.tableInfo = tableInfo;
        this.statementBuilder = statementBuilder;
        this.idFieldType = tableInfo.getIdField();
        this.idColumnName = this.idFieldType == null ? null : this.idFieldType.getColumnName();
        this.databaseType = m2;
    }

    public Where<T, ID> and() {
        this.addNeedsFuture(new ManyClause(this.pop("AND"), "AND"));
        return this;
    }

    public Where<T, ID> and(Where<T, ID> fArray, Where<T, ID> object, Where<T, ID> ... object2) {
        fArray = this.buildClauseArray((Where<T, ID>[])object2, "AND");
        object = this.pop("AND");
        object2 = this.pop("AND");
        this.addClause(new ManyClause((F)object2, (F)object, fArray, "AND"));
        return this;
    }

    public Where<T, ID> and(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Must have at least one clause in and(numClauses)");
        }
        F[] fArray = new F[n2];
        --n2;
        while (n2 >= 0) {
            fArray[n2] = this.pop("AND");
            --n2;
        }
        this.addClause(new ManyClause(fArray, "AND"));
        return this;
    }

    public Where<T, ID> between(String string, Object object, Object object2) {
        this.addClause(new Between(string, this.findColumnFieldType(string), object, object2));
        return this;
    }

    public Where<T, ID> eq(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, "="));
        return this;
    }

    public Where<T, ID> ge(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, ">="));
        return this;
    }

    public Where<T, ID> gt(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, ">"));
        return this;
    }

    public Where<T, ID> in(String string, Iterable<?> iterable) {
        this.addClause(new In(string, this.findColumnFieldType(string), iterable, true));
        return this;
    }

    public Where<T, ID> notIn(String string, Iterable<?> iterable) {
        this.addClause(new In(string, this.findColumnFieldType(string), iterable, false));
        return this;
    }

    public Where<T, ID> in(String string, Object ... objectArray) {
        return this.in(true, string, objectArray);
    }

    public Where<T, ID> notIn(String string, Object ... objectArray) {
        return this.in(false, string, objectArray);
    }

    public Where<T, ID> in(String string, QueryBuilder<?, ?> queryBuilder) {
        return this.in(true, string, queryBuilder);
    }

    public Where<T, ID> notIn(String string, QueryBuilder<?, ?> queryBuilder) {
        return this.in(false, string, queryBuilder);
    }

    public Where<T, ID> exists(QueryBuilder<?, ?> queryBuilder) {
        queryBuilder.enableInnerQuery();
        this.addClause(new Exists(new QueryBuilder$InternalQueryBuilderWrapper(queryBuilder)));
        return this;
    }

    public Where<T, ID> isNull(String string) {
        this.addClause(new I(string, this.findColumnFieldType(string)));
        return this;
    }

    public Where<T, ID> isNotNull(String string) {
        this.addClause(new H(string, this.findColumnFieldType(string)));
        return this;
    }

    public Where<T, ID> le(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, "<="));
        return this;
    }

    public Where<T, ID> lt(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, "<"));
        return this;
    }

    public Where<T, ID> like(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, "LIKE"));
        return this;
    }

    public Where<T, ID> ne(String string, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, "<>"));
        return this;
    }

    public Where<T, ID> not() {
        this.addNeedsFuture(new Not());
        return this;
    }

    public Where<T, ID> not(Where<T, ID> where) {
        this.addClause(new Not(this.pop("NOT")));
        return this;
    }

    public Where<T, ID> or() {
        this.addNeedsFuture(new ManyClause(this.pop("OR"), "OR"));
        return this;
    }

    public Where<T, ID> or(Where<T, ID> fArray, Where<T, ID> object, Where<T, ID> ... object2) {
        fArray = this.buildClauseArray((Where<T, ID>[])object2, "OR");
        object = this.pop("OR");
        object2 = this.pop("OR");
        this.addClause(new ManyClause((F)object2, (F)object, fArray, "OR"));
        return this;
    }

    public Where<T, ID> or(int n2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Must have at least one clause in or(numClauses)");
        }
        F[] fArray = new F[n2];
        --n2;
        while (n2 >= 0) {
            fArray[n2] = this.pop("OR");
            --n2;
        }
        this.addClause(new ManyClause(fArray, "OR"));
        return this;
    }

    public Where<T, ID> idEq(ID ID2) {
        if (this.idColumnName == null) {
            throw new SQLException("Object has no id column specified");
        }
        this.addClause(new SimpleComparison(this.idColumnName, this.idFieldType, ID2, "="));
        return this;
    }

    public <OD> Where<T, ID> idEq(Dao<OD, ?> dao, OD OD2) {
        if (this.idColumnName == null) {
            throw new SQLException("Object has no id column specified");
        }
        this.addClause(new SimpleComparison(this.idColumnName, this.idFieldType, dao.extractId(OD2), "="));
        return this;
    }

    public Where<T, ID> raw(String string, w ... wArray) {
        w[] wArray2 = wArray;
        int n2 = wArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            w w2 = wArray2[i2];
            String string2 = w2.getColumnName();
            if (string2 == null) {
                if (w2.getSqlType() != null) continue;
                throw new IllegalArgumentException("Either the column name or SqlType must be set on each argument");
            }
            w2.setMetaInfo(this.findColumnFieldType(string2));
        }
        this.addClause(new Raw(string, wArray));
        return this;
    }

    public Where<T, ID> rawComparison(String string, String string2, Object object) {
        this.addClause(new SimpleComparison(string, this.findColumnFieldType(string), object, string2));
        return this;
    }

    public A<T> prepare$7d6773b3$64e524b0() {
        return this.statementBuilder.prepareStatement(null);
    }

    public List<T> query() {
        return this.checkQueryBuilderMethod("query()").query();
    }

    public h<String[]> queryRaw() {
        return this.checkQueryBuilderMethod("queryRaw()").queryRaw();
    }

    public T queryForFirst() {
        return this.checkQueryBuilderMethod("queryForFirst()").queryForFirst();
    }

    public String[] queryRawFirst() {
        return this.checkQueryBuilderMethod("queryRawFirst()").queryRawFirst();
    }

    public long countOf() {
        return this.checkQueryBuilderMethod("countOf()").countOf();
    }

    public e<T> iterator() {
        return this.checkQueryBuilderMethod("iterator()").iterator();
    }

    @Deprecated
    public Where<T, ID> clear() {
        return this.reset();
    }

    public Where<T, ID> reset() {
        for (int i2 = 0; i2 < this.clauseStackLevel; ++i2) {
            this.clauseStack[i2] = null;
        }
        this.clauseStackLevel = 0;
        return this;
    }

    public String getStatement() {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendSql(null, stringBuilder, new ArrayList<w>());
        return stringBuilder.toString();
    }

    void appendSql(String string, StringBuilder stringBuilder, List<w> list) {
        if (this.clauseStackLevel == 0) {
            throw new IllegalStateException("No where clauses defined.  Did you miss a where operation?");
        }
        if (this.clauseStackLevel != 1) {
            throw new IllegalStateException("Both the \"left-hand\" and \"right-hand\" clauses have been defined.  Did you miss an AND or OR?");
        }
        this.peek().appendSql(this.databaseType, string, stringBuilder, list);
    }

    public String toString() {
        if (this.clauseStackLevel == 0) {
            return "empty where clause";
        }
        F f2 = this.peek();
        return "where clause: " + f2;
    }

    private QueryBuilder<T, ID> checkQueryBuilderMethod(String string) {
        if (this.statementBuilder instanceof QueryBuilder) {
            return (QueryBuilder)this.statementBuilder;
        }
        throw new SQLException("Cannot call " + string + " on a statement of type " + (Object)((Object)this.statementBuilder.getType()));
    }

    private Where<T, ID> in(boolean bl2, String string, Object ... objectArray) {
        if (objectArray.length == 1) {
            if (objectArray[0].getClass().isArray()) {
                throw new IllegalArgumentException("Object argument to " + (bl2 ? "IN" : "notId") + " seems to be an array within an array");
            }
            if (objectArray[0] instanceof Where) {
                throw new IllegalArgumentException("Object argument to " + (bl2 ? "IN" : "notId") + " seems to be a Where object, did you mean the QueryBuilder?");
            }
            if (objectArray[0] instanceof A) {
                throw new IllegalArgumentException("Object argument to " + (bl2 ? "IN" : "notId") + " seems to be a prepared statement, did you mean the QueryBuilder?");
            }
        }
        this.addClause(new In(string, this.findColumnFieldType(string), objectArray, bl2));
        return this;
    }

    private Where<T, ID> in(boolean bl2, String string, QueryBuilder<?, ?> queryBuilder) {
        if (queryBuilder.getSelectColumnCount() != 1) {
            if (queryBuilder.getSelectColumnCount() == 0) {
                throw new SQLException("Inner query must have only 1 select column specified instead of *");
            }
            throw new SQLException("Inner query must have only 1 select column specified instead of " + queryBuilder.getSelectColumnCount() + ": " + Arrays.toString(queryBuilder.getSelectColumns().toArray(new String[0])));
        }
        queryBuilder.enableInnerQuery();
        this.addClause(new InSubQuery(string, this.findColumnFieldType(string), new QueryBuilder$InternalQueryBuilderWrapper(queryBuilder), bl2));
        return this;
    }

    private F[] buildClauseArray(Where<T, ID>[] whereArray, String string) {
        F[] fArray;
        if (whereArray.length == 0) {
            fArray = null;
        } else {
            fArray = new F[whereArray.length];
            for (int i2 = whereArray.length - 1; i2 >= 0; --i2) {
                fArray[i2] = this.pop(string);
            }
        }
        return fArray;
    }

    private void addNeedsFuture(J j2) {
        if (this.needsFuture != null) {
            throw new IllegalStateException(this.needsFuture + " is already waiting for a future clause, can't add: " + j2);
        }
        this.needsFuture = j2;
        this.push(j2);
    }

    private void addClause(F f2) {
        if (this.needsFuture == null) {
            this.push(f2);
            return;
        }
        this.needsFuture.setMissingClause(f2);
        this.needsFuture = null;
    }

    private FieldType findColumnFieldType(String string) {
        return this.tableInfo.getFieldTypeByColumnName(string);
    }

    private void push(F f2) {
        if (this.clauseStackLevel == this.clauseStack.length) {
            F[] fArray = new F[this.clauseStackLevel << 1];
            for (int i2 = 0; i2 < this.clauseStackLevel; ++i2) {
                fArray[i2] = this.clauseStack[i2];
                this.clauseStack[i2] = null;
            }
            this.clauseStack = fArray;
        }
        this.clauseStack[this.clauseStackLevel++] = f2;
    }

    private F pop(String object) {
        if (this.clauseStackLevel == 0) {
            throw new IllegalStateException("Expecting there to be a clause already defined for '" + (String)object + "' operation");
        }
        object = this.clauseStack[--this.clauseStackLevel];
        this.clauseStack[this.clauseStackLevel] = null;
        return object;
    }

    private F peek() {
        return this.clauseStack[this.clauseStackLevel - 1];
    }
}

