/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.logger.LoggerFactory$1;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTableConfig<T> {
    private Class<T> dataClass;
    private String tableName;
    private List<DatabaseFieldConfig> fieldConfigs;
    private FieldType[] fieldTypes;
    private Constructor<T> constructor;

    public DatabaseTableConfig() {
    }

    public DatabaseTableConfig(Class<T> clazz, List<DatabaseFieldConfig> list) {
        this(clazz, DatabaseTableConfig.extractTableName(clazz), list);
    }

    public DatabaseTableConfig(Class<T> clazz, String string, List<DatabaseFieldConfig> list) {
        this.dataClass = clazz;
        this.tableName = string;
        this.fieldConfigs = list;
    }

    private DatabaseTableConfig(Class<T> clazz, String string, FieldType[] fieldTypeArray) {
        this.dataClass = clazz;
        this.tableName = string;
        this.fieldTypes = fieldTypeArray;
    }

    public void initialize() {
        if (this.dataClass == null) {
            throw new IllegalStateException("dataClass was never set on " + this.getClass().getSimpleName());
        }
        if (this.tableName == null) {
            this.tableName = DatabaseTableConfig.extractTableName(this.dataClass);
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<T> clazz) {
        this.dataClass = clazz;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setFieldConfigs(List<DatabaseFieldConfig> list) {
        this.fieldConfigs = list;
    }

    public void extractFieldTypes(L l2) {
        if (this.fieldTypes == null) {
            if (this.fieldConfigs == null) {
                this.fieldTypes = DatabaseTableConfig.extractFieldTypes(l2, this.dataClass, this.tableName);
                return;
            }
            this.fieldTypes = this.convertFieldConfigs(l2, this.tableName, this.fieldConfigs);
        }
    }

    public FieldType[] getFieldTypes(m m2) {
        if (this.fieldTypes == null) {
            throw new SQLException("Field types have not been extracted in table config");
        }
        return this.fieldTypes;
    }

    public List<DatabaseFieldConfig> getFieldConfigs() {
        return this.fieldConfigs;
    }

    public Constructor<T> getConstructor() {
        if (this.constructor == null) {
            this.constructor = DatabaseTableConfig.findNoArgConstructor(this.dataClass);
        }
        return this.constructor;
    }

    public void setConstructor(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public static <T> DatabaseTableConfig<T> fromClass(L l2, Class<T> clazz) {
        String string = DatabaseTableConfig.extractTableName(clazz);
        if (l2.a().isEntityNamesMustBeUpCase()) {
            string = string.toUpperCase();
        }
        return new DatabaseTableConfig<T>(clazz, string, DatabaseTableConfig.extractFieldTypes(l2, clazz, string));
    }

    public static <T> String extractTableName(Class<T> clazz) {
        Object object = clazz.getAnnotation(N.class);
        if (object != null && object.a() != null && object.a().length() > 0) {
            object = object.a();
        } else {
            object = LoggerFactory$1.getEntityName(clazz);
            if (object == null) {
                object = clazz.getSimpleName().toLowerCase();
            }
        }
        return object;
    }

    public static <T> Constructor<T> findNoArgConstructor(Class<T> clazz) {
        Constructor<?>[] constructorArray;
        try {
            constructorArray = clazz.getDeclaredConstructors();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Can't lookup declared constructors for " + clazz, exception);
        }
        for (Constructor<?> constructor : constructorArray) {
            if (constructor.getParameterTypes().length != 0) continue;
            if (!constructor.isAccessible()) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new IllegalArgumentException("Could not open access to constructor for " + clazz);
                }
            }
            return constructor;
        }
        if (clazz.getEnclosingClass() == null) {
            throw new IllegalArgumentException("Can't find a no-arg constructor for " + clazz);
        }
        throw new IllegalArgumentException("Can't find a no-arg constructor for " + clazz + ".  Missing static on inner class?");
    }

    private static <T> FieldType[] extractFieldTypes(L l2, Class<T> clazz, String string) {
        ArrayList<FieldType> arrayList = new ArrayList<FieldType>();
        for (Class<T> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            for (Field field : clazz2.getDeclaredFields()) {
                FieldType object = FieldType.createFieldType(l2, string, field, clazz);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        if (arrayList.isEmpty()) {
            throw new IllegalArgumentException("No fields have a " + DatabaseField.class.getSimpleName() + " annotation in " + clazz);
        }
        return arrayList.toArray(new FieldType[arrayList.size()]);
    }

    private FieldType[] convertFieldConfigs(L l2, String string, List<DatabaseFieldConfig> object) {
        ArrayList<FieldType> arrayList = new ArrayList<FieldType>();
        object = object.iterator();
        while (object.hasNext()) {
            DatabaseFieldConfig databaseFieldConfig = (DatabaseFieldConfig)object.next();
            FieldType fieldType = null;
            for (Class<T> clazz = this.dataClass; clazz != null; clazz = clazz.getSuperclass()) {
                Field field;
                try {
                    field = clazz.getDeclaredField(databaseFieldConfig.getFieldName());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                if (field == null) continue;
                fieldType = new FieldType(l2, string, field, databaseFieldConfig, this.dataClass);
                break;
            }
            if (fieldType == null) {
                throw new SQLException("Could not find declared field with name '" + databaseFieldConfig.getFieldName() + "' for " + this.dataClass);
            }
            arrayList.add(fieldType);
        }
        if (arrayList.isEmpty()) {
            throw new SQLException("No fields were configured for class " + this.dataClass);
        }
        return arrayList.toArray(new FieldType[arrayList.size()]);
    }
}

