/*
 * Decompiled with CFR 0.152.
 */
package de.t68.utils.keyboard;

import de.t68.utils.keyboard.KeyboardLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class LanguageMap
extends TreeMap<String, KeyboardLayout> {
    protected static final String[] CONFIGNAMES = new String[]{"Simplified Chinese.xml", "Traditional Chinese.xml", "Danish.xml", "Dutch.xml", "English.xml", "International English.xml", "Finnish.xml", "French.xml", "German.xml", "Italian.xml", "Japanese.xml", "Korean.xml", "Norwegian.xml", "Pig Latin.xml", "Portuguese.xml", "Portuguese (Brazil).xml", "Russian.xml", "Spanish.xml", "Spanish-HispanicAmerica.xml", "Swedish.xml", "Thai.xml", "Turkish.xml", "Ukrainian.xml"};
    protected static LanguageMap instance;

    public static LanguageMap getInstance() {
        if (instance == null) {
            instance = new LanguageMap("config");
        }
        return instance;
    }

    public static void main(String[] object) {
        for (Object object2 : LanguageMap.getInstance().values()) {
            try {
                Element element = ((KeyboardLayout)object2).getAsElement();
                object2 = new File(((KeyboardLayout)object2).name + ".xml");
                object2 = new FileOutputStream((File)object2);
                Format format = Format.getPrettyFormat();
                format.setEncoding("utf-16");
                format.setTextMode(Format.TextMode.TRIM);
                new XMLOutputter(format).output(new Document(element), (OutputStream)object2);
                ((FileOutputStream)object2).close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected LanguageMap(String object) {
        Serializable serializable;
        String string3 = "de/t68/utils/keyboard/config";
        Object object2 = CONFIGNAMES;
        int n2 = CONFIGNAMES.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string22 = object2[i2];
            try {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(string3 + "/" + string22);
                serializable = new KeyboardLayout(inputStream);
                for (String string22 : ((KeyboardLayout)serializable).getLocaleString()) {
                    this.put(string22, serializable);
                }
                inputStream.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        File[] fileArray = new File((String)object).listFiles(new P());
        if (fileArray != null) {
            File[] fileArray2 = fileArray;
            int n3 = fileArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                serializable = fileArray2[i3];
                try {
                    object2 = new FileInputStream((File)serializable);
                    KeyboardLayout keyboardLayout = new KeyboardLayout((InputStream)object2);
                    for (String string3 : keyboardLayout.getLocaleString()) {
                        this.put(string3, keyboardLayout);
                    }
                    ((FileInputStream)object2).close();
                    continue;
                }
                catch (Exception exception) {
                    System.out.println("error parsing : " + ((File)serializable).getAbsolutePath());
                    exception.printStackTrace();
                }
            }
        }
    }

    public KeyboardLayout getKeyboardLayoutForCurrentLocale() {
        String string = Locale.getDefault().getLanguage();
        String string2 = Locale.getDefault().getCountry();
        return this.getKeyboardLayoutForLocale(string, string2);
    }

    public KeyboardLayout getKeyboardLayoutForLocale(String string, String object) {
        KeyboardLayout keyboardLayout = (KeyboardLayout)this.get("international");
        object = (KeyboardLayout)this.get(string + "-" + (String)object);
        if (object != null) {
            return (KeyboardLayout)((KeyboardLayout)object).clone();
        }
        object = (KeyboardLayout)this.get(string);
        if (object != null) {
            return (KeyboardLayout)((KeyboardLayout)object).clone();
        }
        for (Map.Entry entry : this.entrySet()) {
            if (!((String)entry.getKey()).startsWith(string + "-")) continue;
            return (KeyboardLayout)((KeyboardLayout)entry.getValue()).clone();
        }
        if (keyboardLayout == null) {
            return (KeyboardLayout)((KeyboardLayout)this.values().iterator().next()).clone();
        }
        return (KeyboardLayout)keyboardLayout.clone();
    }
}

