/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.graph.presentation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import org.tigris.gef.base.Diagram;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.LayerDiagram;
import org.tigris.gef.base.NudgeAction;
import org.tigris.gef.base.SelectNearAction;
import org.tigris.gef.base.SelectNextAction;
import org.tigris.gef.base.ZoomAction;
import org.tigris.gef.di.DiagramElement;
import org.tigris.gef.event.GraphSelectionListener;
import org.tigris.gef.event.ModeChangeListener;
import org.tigris.gef.graph.ConnectionConstrainer;
import org.tigris.gef.graph.GraphEdgeRenderer;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.GraphNodeRenderer;
import org.tigris.gef.graph.presentation.DefaultGraphModel;
import org.tigris.gef.graph.presentation.JGraphInternalPane;
import org.tigris.gef.graph.presentation.WheelKeyListenerToggleAction;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigText;

public class JGraph
extends JPanel
implements AdjustmentListener,
MouseWheelListener,
Cloneable {
    private Editor editor;
    private JGraphInternalPane drawingPane;
    private JScrollPane scrollPane;
    private Dimension defaultSize = new Dimension(6000, 6000);
    private Hashtable _viewPortPositions = new Hashtable();
    private String _currentDiagramId = null;
    private ZoomAction zoomOut = new ZoomAction(0.9);
    private ZoomAction zoomIn = new ZoomAction(1.1);
    static final long serialVersionUID = -5459241816919316496L;

    public JGraph() {
        this(new DefaultGraphModel());
    }

    public JGraph(ConnectionConstrainer connectionConstrainer) {
        this(new DefaultGraphModel(connectionConstrainer));
    }

    public JGraph(Diagram diagram) {
        this(new Editor(diagram));
    }

    public JGraph(GraphModel graphModel) {
        this(new Editor(graphModel, null));
    }

    public void setTitle(String string) {
        this.scrollPane.setBorder(new TitledBorder(string));
    }

    public JGraph(Editor object) {
        super(false);
        this.editor = object;
        this.drawingPane = new JGraphInternalPane(this.editor);
        this.setDrawingSize(this.getDefaultSize());
        this.scrollPane = new JScrollPane(this.drawingPane);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setBorder(null);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(25);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(25);
        this.editor.setJComponent(this.drawingPane);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        this.addMouseListener(this.editor);
        this.addMouseMotionListener(this.editor);
        this.addKeyListener(this.editor);
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        this.initKeys();
        this.validate();
        object = ((Editor)object).getLayerManager().getContents();
        if (object != null) {
            this.updateDrawingSizeToIncludeAllFigs(Collections.enumeration(object));
        }
        this.establishAlternateMouseWheelListener(this, 10);
    }

    public boolean equals(Object object) {
        if (object instanceof JGraph) {
            object = (JGraph)object;
            if ((this.getCurrentDiagramId() != null && this.getCurrentDiagramId().equals(((JGraph)object).getCurrentDiagramId()) || this.getCurrentDiagramId() == null && ((JGraph)object).getCurrentDiagramId() == null) && this.getEditor().equals(((JGraph)object).getEditor())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.getCurrentDiagramId() == null) {
            return 0;
        }
        return this.getCurrentDiagramId().hashCode();
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.drawingPane.addMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.drawingPane.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.drawingPane.addKeyListener(keyListener);
    }

    public Object clone() {
        return new JGraph((Editor)this.editor.clone());
    }

    public void initKeys() {
        this.bindKey(new SelectNextAction("Select Next", true), 9, 0);
        this.bindKey(new SelectNextAction("Select Previous", false), 9, 1);
        this.bindKey(new NudgeAction(1), 37, 0);
        this.bindKey(new NudgeAction(2), 39, 0);
        this.bindKey(new NudgeAction(3), 38, 0);
        this.bindKey(new NudgeAction(4), 40, 0);
        this.bindKey(new NudgeAction(1, 8), 37, 1);
        this.bindKey(new NudgeAction(2, 8), 39, 1);
        this.bindKey(new NudgeAction(3, 8), 38, 1);
        this.bindKey(new NudgeAction(4, 8), 40, 1);
        this.bindKey(new NudgeAction(1, 18), 37, 8);
        this.bindKey(new NudgeAction(2, 18), 39, 8);
        this.bindKey(new NudgeAction(3, 18), 38, 8);
        this.bindKey(new NudgeAction(4, 18), 40, 8);
        this.bindKey(new SelectNearAction(1), 37, 4);
        this.bindKey(new SelectNearAction(2), 39, 4);
        this.bindKey(new SelectNearAction(3), 38, 4);
        this.bindKey(new SelectNearAction(4), 40, 4);
    }

    public void bindKey(ActionListener actionListener, int n2, int n3) {
        this.drawingPane.registerKeyboardAction(actionListener, KeyStroke.getKeyStroke(n2, n3), 0);
    }

    public Editor getEditor() {
        return this.editor;
    }

    public void setDiagram(Diagram object) {
        if (object == null) {
            return;
        }
        if (this._currentDiagramId != null) {
            this._viewPortPositions.put(this._currentDiagramId, this.scrollPane.getViewport().getViewRect());
        }
        this.setDrawingSize(this.getDefaultSize());
        this.updateDrawingSizeToIncludeAllFigs(((Diagram)object).elements());
        this.editor.getLayerManager().replaceActiveLayer(((Diagram)object).getLayer());
        this.editor.setGraphModel(((Diagram)object).getGraphModel());
        this.editor.getSelectionManager().deselectAll();
        this.editor.setScale(((Diagram)object).getScale());
        object = Integer.toString(object.hashCode());
        if (((String)object).equals(this._currentDiagramId)) {
            return;
        }
        this._currentDiagramId = object;
        if (this._viewPortPositions.get(this._currentDiagramId) != null) {
            object = (Rectangle)this._viewPortPositions.get(this._currentDiagramId);
            this.scrollPane.getViewport().setViewPosition(new Point(((Rectangle)object).x, ((Rectangle)object).y));
            return;
        }
        this.scrollPane.getViewport().setViewPosition(new Point());
    }

    protected void updateDrawingSizeToIncludeAllFigs(Enumeration enumeration) {
        if (enumeration == null) {
            return;
        }
        Dimension dimension = new Dimension(this.defaultSize.width, this.defaultSize.height);
        while (enumeration.hasMoreElements()) {
            Cloneable cloneable = ((Fig)enumeration.nextElement()).getBounds();
            Point point = cloneable.getLocation();
            cloneable = cloneable.getSize();
            if (point.x + ((Dimension)cloneable).width + 5 > dimension.width) {
                dimension.setSize(point.x + ((Dimension)cloneable).width + 5, dimension.height);
            }
            if (point.y + ((Dimension)cloneable).height + 5 <= dimension.height) continue;
            dimension.setSize(dimension.width, point.y + ((Dimension)cloneable).height + 5);
        }
        this.setDrawingSize(dimension.width, dimension.height);
    }

    public void setDrawingSize(int n2, int n3) {
        this.setDrawingSize(new Dimension(n2, n3));
    }

    public void setDrawingSize(Dimension dimension) {
        this.editor.drawingSizeChanged(dimension);
    }

    public void setGraphModel(GraphModel graphModel) {
        this.editor.setGraphModel(graphModel);
    }

    public GraphModel getGraphModel() {
        return this.editor.getGraphModel();
    }

    public void setGraphNodeRenderer(GraphNodeRenderer graphNodeRenderer) {
        this.editor.setGraphNodeRenderer(graphNodeRenderer);
    }

    public GraphNodeRenderer getGraphNodeRenderer() {
        return this.editor.getGraphNodeRenderer();
    }

    public void setGraphEdgeRenderer(GraphEdgeRenderer graphEdgeRenderer) {
        this.editor.setGraphEdgeRenderer(graphEdgeRenderer);
    }

    public GraphEdgeRenderer getGraphEdgeRenderer() {
        return this.editor.getGraphEdgeRenderer();
    }

    @Override
    public void setVisible(boolean bl2) {
        super.setVisible(bl2);
        this.drawingPane.setVisible(bl2);
    }

    @Override
    public boolean isManagingFocus() {
        return true;
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    public void addGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.getEditor().addGraphSelectionListener(graphSelectionListener);
    }

    public void removeGraphSelectionListener(GraphSelectionListener graphSelectionListener) {
        this.getEditor().removeGraphSelectionListener(graphSelectionListener);
    }

    public void addModeChangeListener(ModeChangeListener modeChangeListener) {
        this.getEditor().addModeChangeListener(modeChangeListener);
    }

    public void removeModeChangeListener(ModeChangeListener modeChangeListener) {
        this.getEditor().removeModeChangeListener(modeChangeListener);
    }

    public void select(Fig fig) {
        if (fig == null) {
            this.deselectAll();
            return;
        }
        this.editor.getSelectionManager().select(fig);
    }

    public void selectByOwner(Object object) {
        Layer layer = this.editor.getLayerManager().getActiveLayer();
        if (layer instanceof LayerDiagram) {
            this.select(((LayerDiagram)layer).presentationFor(object));
        }
    }

    public void selectByOwnerOrFig(Object object) {
        if (object instanceof Fig) {
            this.select((Fig)object);
            return;
        }
        this.selectByOwner(object);
    }

    public void selectByOwnerOrNoChange(Object object) {
        Layer layer = this.editor.getLayerManager().getActiveLayer();
        if (layer instanceof LayerDiagram && (object = ((LayerDiagram)layer).presentationFor(object)) != null) {
            this.select((Fig)object);
        }
    }

    public void deselect(Fig fig) {
        this.editor.getSelectionManager().deselect(fig);
    }

    public void toggleItem(Fig fig) {
        this.editor.getSelectionManager().toggle(fig);
    }

    public void deselectAll() {
        this.editor.getSelectionManager().deselectAll();
    }

    public void select(Collection<DiagramElement> collection) {
        this.editor.getSelectionManager().selectFigs(collection);
    }

    public void select(Vector vector) {
        this.editor.getSelectionManager().select(vector);
    }

    public void toggleItems(Vector vector) {
        this.editor.getSelectionManager().toggle(vector);
    }

    public Vector selectedFigs() {
        return this.editor.getSelectionManager().getFigs();
    }

    public void setDefaultSize(int n2, int n3) {
        this.defaultSize = new Dimension(n2, n3);
    }

    public void setDefaultSize(Dimension dimension) {
        this.defaultSize = dimension;
    }

    public Dimension getDefaultSize() {
        return this.defaultSize;
    }

    public Point getViewPosition() {
        return this.scrollPane.getViewport().getViewPosition();
    }

    public void setViewPosition(Point point) {
        if (point != null) {
            this.scrollPane.getViewport().setViewPosition(point);
        }
    }

    public void establishAlternateMouseWheelListener(MouseWheelListener eventListener, int n2) {
        eventListener = new WheelKeyListenerToggleAction(this.drawingPane, (MouseWheelListener)eventListener, n2);
        this.drawingPane.addKeyListener((KeyListener)eventListener);
    }

    protected String getCurrentDiagramId() {
        return this._currentDiagramId;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent object) {
        object = FigText.getActiveTextEditor();
        if (object != null) {
            object.endEditing();
        }
        this.editor.damageAll();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.isAltDown() || mouseWheelEvent.isControlDown()) {
            if (mouseWheelEvent.getWheelRotation() < 0) {
                this.zoomOut.actionPerformed(null);
            } else if (mouseWheelEvent.getWheelRotation() > 0) {
                this.zoomIn.actionPerformed(null);
            }
            mouseWheelEvent.consume();
        }
    }
}

