/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.persistence;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;
import java.text.NumberFormat;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.gef.persistence.SvgWriter2D$GraphicsContext;
import org.tigris.gef.persistence.SvgWriter2D$Stack;
import org.tigris.gef.persistence.export.FontUtility;
import org.tigris.gef.presentation.Fig;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SvgWriter2D
extends Graphics2D {
    private static final Logger LOG = Logger.getLogger(SvgWriter2D.class.getCanonicalName());
    private static final Stroke DEFAULT_STROKE = new BasicStroke();
    private static final Color DEFAULT_COLOR = Color.black;
    private static final Color DEFAULT_BACKGROUND = Color.white;
    private PrintWriter writer;
    private Document svg;
    private SvgWriter2D$Stack<Element> elements = new SvgWriter2D$Stack(this, null);
    private SvgWriter2D$Stack<SvgWriter2D$GraphicsContext> graphicsContexts = new SvgWriter2D$Stack(this, null);
    private SvgWriter2D$GraphicsContext activeGC;
    private Shape clip;
    private int hInset = 10;
    private int vInset = 10;
    private String svgNamespace = "http://www.w3.org/2000/svg";
    private boolean isInline = false;
    private RenderingHints renderingHints = new RenderingHints(null);
    private AffineTransform transform = new AffineTransform();

    public SvgWriter2D(OutputStream object, Rectangle rectangle) {
        this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)object, "UTF-8"));
        object = DocumentBuilderFactory.newInstance();
        ((DocumentBuilderFactory)object).setNamespaceAware(false);
        ((DocumentBuilderFactory)object).setValidating(false);
        object = ((DocumentBuilderFactory)object).newDocumentBuilder();
        this.svg = ((DocumentBuilder)object).newDocument();
        object = this.svg.createElement("svg");
        object.setAttribute("xmlns", this.svgNamespace);
        object.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        object.setAttribute("width", "" + (2 * this.hInset + rectangle.width));
        object.setAttribute("height", "" + (2 * this.vInset + rectangle.height));
        object.setAttribute("version", "1.1");
        this.elements.push((Element)object);
        this.activeGC = new SvgWriter2D$GraphicsContext(this, Color.black, Color.white, 1);
        this.activeGC.font = new Font("Verdana", 0, 8);
        this.graphicsContexts.push(this.activeGC);
        object = this.svg.createElement("g");
        object.setAttribute("stroke", this.toHexString(this.activeGC.foreground));
        object.setAttribute("fill", this.toHexString(this.activeGC.background));
        object.setAttribute("font", this.activeGC.font.getFontName());
        object.setAttribute("stroke-width", "1");
        this.elements.push((Element)object);
    }

    public SvgWriter2D(OutputStream outputStream, Rectangle rectangle, boolean bl2) {
        this(outputStream, rectangle);
        this.isInline = bl2;
    }

    @Override
    public Graphics2D create() {
        return this;
    }

    @Override
    public void dispose() {
        while (!this.elements.isEmpty()) {
            this.popElement();
        }
        this.printDOMTree(this.svg);
        this.writer.close();
    }

    public void printDOMTree(Node object) {
        switch (object.getNodeType()) {
            case 9: {
                if (!this.isInline) {
                    this.writer.println("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
                    this.writer.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">");
                }
                this.printDOMTree(((Document)object).getDocumentElement());
                return;
            }
            case 1: {
                this.printElementNode((Node)object);
                return;
            }
            case 5: {
                this.writer.print("&");
                this.writer.print(object.getNodeName());
                this.writer.print(";");
                return;
            }
            case 4: {
                this.writer.print("<![CDATA[");
                this.writer.print(object.getNodeValue());
                this.writer.print("]]>");
                return;
            }
            case 3: {
                this.printTextNode((Node)object);
                return;
            }
            case 7: {
                this.writer.print("<?");
                this.writer.print(object.getNodeName());
                object = object.getNodeValue();
                this.writer.print("");
                this.writer.print((String)object);
                this.writer.print("?>");
            }
        }
    }

    private void printElementNode(Node node) {
        this.writer.print("<");
        this.writer.print(node.getNodeName());
        NamedNodeMap namedNodeMap = node.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Node node2 = namedNodeMap.item(i2);
            this.writer.print(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList.getLength() > 0) {
            this.writer.println(">");
            int n2 = nodeList.getLength();
            for (int i3 = 0; i3 < n2; ++i3) {
                this.printDOMTree(nodeList.item(i3));
            }
            this.writer.print("</");
            this.writer.print(node.getNodeName());
            this.writer.println(">");
            return;
        }
        this.writer.println("/>");
    }

    private void printTextNode(Node object) {
        object = object.getNodeValue();
        block5: for (int i2 = 0; i2 < ((String)object).length(); ++i2) {
            switch (((String)object).charAt(i2)) {
                case '&': {
                    this.writer.print("&amp;");
                    continue block5;
                }
                case '<': {
                    this.writer.print("&lt;");
                    continue block5;
                }
                case '>': {
                    this.writer.print("&gt;");
                    continue block5;
                }
                default: {
                    this.writer.print(((String)object).charAt(i2));
                }
            }
        }
    }

    @Override
    public Color getColor() {
        return this.activeGC.foreground;
    }

    private String getColorAsString() {
        return this.toHexString(this.activeGC.foreground);
    }

    private String toHexString(Color color) {
        return "#" + Integer.toHexString(color.getRGB()).substring(2);
    }

    @Override
    public void setColor(Color color) {
        this.activeGC.foreground = color;
    }

    @Override
    public void setPaintMode() {
        this.activeGC.XOR = false;
        LOG.warning("Unimplemented - setPaintMode");
    }

    @Override
    public void setXORMode(Color color) {
        this.activeGC.XOR = true;
        LOG.warning("Unimplemented - setXORMode");
    }

    @Override
    public Font getFont() {
        return this.activeGC.font;
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            this.activeGC.font = font;
            LOG.fine("setFont " + font.getFontName() + " " + font);
            return;
        }
        LOG.fine("null setFont " + this.activeGC.font.getFontName() + " " + this.activeGC.font);
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return FontUtility.getFontMetrics(font);
    }

    @Override
    public void copyArea(int n2, int n3, int n4, int n5, int n6, int n7) {
        LOG.warning("unimplemented copyArea");
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, Color color, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, Color color, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    @Override
    public boolean drawImage(Image image, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Color color, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return true;
    }

    private void drawRect(double d2, double d3, double d4, double d5, Color color, Color color2) {
        LOG.fine("drawRect " + d2 + " " + d3 + " " + d4 + " " + d5);
        Element element = this.svg.createElement("rect");
        element.setAttribute("x", String.valueOf(d2));
        element.setAttribute("y", String.valueOf(d3));
        element.setAttribute("width", String.valueOf(d4));
        element.setAttribute("height", String.valueOf(d5));
        this.setDrawingAttributes(element, new SvgWriter2D$GraphicsContext(this, color, color2, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, this.activeGC.foreground, null);
    }

    private void drawRect(double d2, double d3, double d4, double d5) {
        this.drawRect(d2, d3, d4, d5, this.activeGC.foreground, null);
    }

    private void fillRect(double d2, double d3, double d4, double d5) {
        this.drawRect(d2, d3, d4, d5, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void fillRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void clearRect(int n2, int n3, int n4, int n5) {
        this.drawRect(n2, n3, n4, n5, this.activeGC.background, this.activeGC.background);
    }

    private void drawOval(double d2, double d3, double d4, double d5, Color color, Color color2) {
        LOG.fine("drawOval " + d2 + " " + d3 + " " + d4 + " " + d5);
        Element element = this.svg.createElement("ellipse");
        element.setAttribute("cx", "" + (d2 + d4 / 2.0));
        element.setAttribute("cy", "" + (d3 + d5 / 2.0));
        element.setAttribute("rx", "" + d4 / 2.0);
        element.setAttribute("ry", "" + d5 / 2.0);
        this.setDrawingAttributes(element, new SvgWriter2D$GraphicsContext(this, color, color2, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawOval(int n2, int n3, int n4, int n5) {
        this.drawOval(n2, n3, n4, n5, this.activeGC.foreground, null);
    }

    private void drawOval(double d2, double d3, double d4, double d5) {
        this.drawOval(d2, d3, d4, d5, this.activeGC.foreground, null);
    }

    private void fillOval(double d2, double d3, double d4, double d5) {
        this.drawOval(d2, d3, d4, d5, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void fillOval(int n2, int n3, int n4, int n5) {
        this.drawOval(n2, n3, n4, n5, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void drawArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        LOG.warning("Not implemented : drawArc");
    }

    @Override
    public void fillArc(int n2, int n3, int n4, int n5, int n6, int n7) {
        LOG.warning("Not implemented : fillArc");
    }

    private void drawRoundRect(double d2, double d3, double d4, double d5, double d6, double d7, Color color, Color color2) {
        LOG.fine("drawRoundRect " + d2 + " " + d3 + " " + d4 + " " + d5);
        Element element = this.svg.createElement("rect");
        element.setAttribute("x", String.valueOf(d2));
        element.setAttribute("y", String.valueOf(d3));
        element.setAttribute("width", String.valueOf(d4));
        element.setAttribute("height", String.valueOf(d5));
        element.setAttribute("rx", String.valueOf(d6));
        element.setAttribute("ry", String.valueOf(d7));
        this.setDrawingAttributes(element, new SvgWriter2D$GraphicsContext(this, color, color2, this.activeGC.lineWidth));
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRoundRect(n2, n3, n4, n5, n6, n7, this.activeGC.foreground, this.activeGC.background);
    }

    private void drawRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRoundRect(d2, d3, d4, d5, d6, d7, this.activeGC.foreground, this.activeGC.background);
    }

    @Override
    public void fillRoundRect(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.drawRoundRect(n2, n3, n4, n5, n6, n7, this.activeGC.foreground, this.activeGC.foreground);
    }

    private void fillRoundRect(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.drawRoundRect(d2, d3, d4, d5, d6, d7, this.activeGC.foreground, this.activeGC.foreground);
    }

    private void drawPolygon(int[] nArray, int[] nArray2, int n2, Color serializable, Color color) {
        LOG.fine("drawPolygon");
        Element element = this.svg.createElement("polygon");
        this.setDrawingAttributes(element, new SvgWriter2D$GraphicsContext(this, (Color)serializable, color, this.activeGC.lineWidth));
        serializable = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                ((StringBuffer)serializable).append(" ");
            }
            ((StringBuffer)serializable).append(nArray[i2] + "," + nArray2[i2]);
        }
        element.setAttribute("points", ((StringBuffer)serializable).toString());
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n2) {
        this.drawPolygon(nArray, nArray2, n2, this.activeGC.foreground, null);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n2) {
        this.drawPolygon(nArray, nArray2, n2, this.activeGC.foreground, this.activeGC.foreground);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n2) {
        LOG.fine("drawPolyLine");
        Element element = this.svg.createElement("polyline");
        this.setDrawingAttributes(element);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(nArray[i2] + "," + nArray2[i2]);
        }
        element.setAttribute("points", stringBuffer.toString());
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawLine(int n2, int n3, int n4, int n5) {
        this.drawLine((double)n2, (double)n3, (double)n4, (double)n5);
    }

    private void drawLine(double d2, double d3, double d4, double d5) {
        LOG.fine("drawLine " + d2 + " " + d3 + " " + d4 + " " + d5);
        Element element = this.svg.createElement("line");
        element.setAttribute("x1", String.valueOf(d2));
        element.setAttribute("y1", String.valueOf(d3));
        element.setAttribute("x2", String.valueOf(d4));
        element.setAttribute("y2", String.valueOf(d5));
        this.setDrawingAttributes(element);
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void setClip(int n2, int n3, int n4, int n5) {
        this.setClip(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public void setClip(Shape shape) {
        this.clip = shape;
        LOG.fine("setClip " + shape);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    @Override
    public void clipRect(int n2, int n3, int n4, int n5) {
        if (this.clip == null) {
            this.setClip(n2, n3, n4, n5);
            return;
        }
        this.clip(new Rectangle(n2, n3, n4, n5));
    }

    @Override
    public Shape getClip() {
        return this.clip;
    }

    @Override
    public void clip(Shape shape) {
        if (this.clip == null) {
            this.clip = shape;
        } else {
            Area area = new Area(this.clip);
            area.intersect(new Area(shape));
            GeneralPath generalPath = new GeneralPath();
            generalPath.append(area.getPathIterator(null), true);
            this.clip = generalPath;
        }
        LOG.fine("Clip with " + shape + " result = " + this.clip);
    }

    @Override
    public void translate(int n2, int n3) {
        this.translate((double)n2, (double)n3);
    }

    @Override
    public void scale(double d2, double d3) {
        LOG.fine("Scale " + d2 + " " + d3);
        this.transform.scale(d2, d3);
        this.transformGroup("scale(" + d2 + "," + d3 + ")");
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        LOG.fine("setTransform " + affineTransform);
    }

    @Override
    public void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
        LOG.fine("Shear " + d2 + " " + d3);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        LOG.fine("Transform " + affineTransform);
    }

    @Override
    public void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
        LOG.fine("Translate " + d2 + " " + d3);
    }

    @Override
    public void drawString(String string, int n2, int n3) {
        this.drawString(string, (float)n2, (float)n3);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
    }

    @Override
    public void addRenderingHints(Map<?, ?> map) {
        this.renderingHints.putAll(map);
        LOG.warning("Warning - addRenderingHint not supported");
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
        LOG.warning("Warning - setRenderingHint not supported");
    }

    @Override
    public void setRenderingHints(Map<?, ?> map) {
        this.renderingHints.putAll(map);
        LOG.warning("Warning - setRenderingHint not supported");
    }

    @Override
    public void draw(Shape shape) {
        LOG.fine("Draw - " + shape);
        if (shape instanceof Line2D) {
            shape = (Line2D)shape;
            this.drawLine(((Line2D)shape).getX1(), ((Line2D)shape).getY1(), ((Line2D)shape).getX2(), ((Line2D)shape).getY2());
            return;
        }
        if (shape instanceof Rectangle2D) {
            shape = (Rectangle2D)shape;
            this.drawRect(((RectangularShape)shape).getX(), ((RectangularShape)shape).getY(), ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight());
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            shape = (RoundRectangle2D)shape;
            this.drawRoundRect(((RectangularShape)shape).getX(), ((RectangularShape)shape).getY(), ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight(), ((RoundRectangle2D)shape).getArcWidth(), ((RoundRectangle2D)shape).getArcHeight());
            return;
        }
        if (shape instanceof Polygon) {
            this.drawPolygon((Polygon)shape);
            return;
        }
        if (shape instanceof Ellipse2D) {
            shape = (Ellipse2D)shape;
            this.drawOval(((RectangularShape)shape).getCenterX(), ((RectangularShape)shape).getCenterY(), ((RectangularShape)shape).getWidth() / 2.0, ((RectangularShape)shape).getHeight() / 2.0);
            return;
        }
        this.drawPath(shape, this.activeGC.foreground, null);
    }

    private void drawPath(Shape shape, Color color, Color color2) {
        LOG.fine("draw GeneralPath");
        Element element = this.svg.createElement("path");
        this.setDrawingAttributes(element, new SvgWriter2D$GraphicsContext(this, color, color2, this.activeGC.lineWidth));
        element.setAttribute("d", this.getPath(shape));
        ((Element)this.elements.peek()).appendChild(element);
    }

    private String getPath(Shape object) {
        StringBuffer stringBuffer = new StringBuffer();
        object = object.getPathIterator(null);
        while (!object.isDone()) {
            double[] dArray = new double[6];
            int n2 = object.currentSegment(dArray);
            if (n2 == 0) {
                double[] dArray2 = new double[2];
                double[] dArray3 = dArray2;
                dArray2[0] = dArray[0];
                dArray3[1] = dArray[1];
                stringBuffer.append(" M " + dArray[0] + " " + dArray[1]);
                LOG.fine("MOVETO " + dArray[0] + ", " + dArray[1]);
            } else if (n2 == 1) {
                stringBuffer.append(" L " + dArray[0] + " " + dArray[1]);
                LOG.fine("LINETO " + dArray[0] + ", " + dArray[1]);
            } else if (n2 == 3) {
                stringBuffer.append(" C " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5]);
                LOG.fine("CUBICTO " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3] + " " + dArray[4] + " " + dArray[5]);
            } else if (n2 == 2) {
                stringBuffer.append(" Q " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3]);
                LOG.fine("QUADTO " + dArray[0] + " " + dArray[1] + " " + dArray[2] + " " + dArray[3]);
            } else if (n2 == 4) {
                stringBuffer.append(" Z");
                LOG.fine("CLOSE path");
            } else {
                LOG.warning("Unsupported GeneralPath segment type " + n2);
            }
            object.next();
        }
        return stringBuffer.toString();
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        LOG.warning("Unimplemented -  drawGlyphVector");
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        LOG.warning("Unimplemented -  drawImage");
        return false;
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n2, int n3) {
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
    }

    @Override
    public void drawString(String string, float f2, float f3) {
        Element element = this.svg.createElement("text");
        element.setAttribute("x", String.valueOf(f2));
        element.setAttribute("y", String.valueOf(f3));
        element.setAttribute("font-family", this.activeGC.font.getFamily());
        element.setAttribute("font-size", "" + this.activeGC.font.getSize());
        element.setAttribute("fill", this.getColorAsString());
        if (this.getFont().isBold()) {
            element.setAttribute("font-weight", "bold");
        }
        if (this.getFont().isItalic()) {
            element.setAttribute("font-style", "italic");
        }
        element.appendChild(this.svg.createTextNode(string));
        ((Element)this.elements.peek()).appendChild(element);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
    }

    @Override
    public void fill(Shape shape) {
        if (shape instanceof Line2D) {
            shape = (Line2D)shape;
            this.drawLine(((Line2D)shape).getX1(), ((Line2D)shape).getY1(), ((Line2D)shape).getX2(), ((Line2D)shape).getY2());
            return;
        }
        if (shape instanceof Rectangle2D) {
            shape = (Rectangle2D)shape;
            this.fillRect(((RectangularShape)shape).getX(), ((RectangularShape)shape).getY(), ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight());
            return;
        }
        if (shape instanceof RoundRectangle2D) {
            shape = (RoundRectangle2D)shape;
            this.fillRoundRect(((RectangularShape)shape).getX(), ((RectangularShape)shape).getY(), ((RectangularShape)shape).getWidth(), ((RectangularShape)shape).getHeight(), ((RoundRectangle2D)shape).getArcWidth(), ((RoundRectangle2D)shape).getArcHeight());
            return;
        }
        if (shape instanceof Polygon) {
            this.fillPolygon((Polygon)shape);
            return;
        }
        if (shape instanceof Ellipse2D) {
            shape = (Ellipse2D)shape;
            this.fillOval(((RectangularShape)shape).getCenterX(), ((RectangularShape)shape).getCenterY(), ((RectangularShape)shape).getWidth() / 2.0, ((RectangularShape)shape).getHeight() / 2.0);
            return;
        }
        this.drawPath(shape, this.activeGC.foreground, this.activeGC.foreground);
        LOG.warning("Falling back to fill shape " + shape);
    }

    @Override
    public Color getBackground() {
        return this.activeGC.background;
    }

    @Override
    public Composite getComposite() {
        return this.activeGC.composite;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        LOG.warning("Unimplemented - getDeviceConfiguration");
        return null;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        LOG.warning("Unimplemented - getFontRenderContext");
        return null;
    }

    @Override
    public Paint getPaint() {
        return this.activeGC.paint;
    }

    @Override
    public Stroke getStroke() {
        return this.activeGC.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl2) {
        return shape.intersects(rectangle);
    }

    @Override
    public void rotate(double d2) {
        this.transform.rotate(d2);
        this.transformGroup("rotate(" + this.degrees(d2) + ")");
    }

    @Override
    public void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
        this.transformGroup("rotate(" + this.degrees(d2) + "," + d3 + "," + d4 + ")");
    }

    @Override
    public void setBackground(Color color) {
        this.activeGC.background = color;
    }

    @Override
    public void setComposite(Composite composite) {
        if (composite != null) {
            this.activeGC.composite = composite;
            LOG.fine("New composite = " + this.activeGC.composite);
        }
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint != null) {
            this.activeGC.paint = paint;
            LOG.fine("new paint = " + this.activeGC.paint);
        }
    }

    private void updateRenderGroup() {
    }

    @Override
    public void setStroke(Stroke stroke) {
        if (stroke != null) {
            this.activeGC.stroke = stroke;
            LOG.fine("new stroke = " + this.activeGC.stroke);
        }
    }

    private double degrees(double d2) {
        return d2 / Math.PI * 180.0;
    }

    private void transformGroup(String string) {
        Element element = this.svg.createElement("g");
        element.setAttribute("transform", string);
        ((Element)this.elements.peek()).appendChild(element);
    }

    private void setDrawingAttributes(Element element) {
        this.setDrawingAttributes(element, (SvgWriter2D$GraphicsContext)this.graphicsContexts.peek(), this.activeGC);
    }

    private void setDrawingAttributes(Element element, SvgWriter2D$GraphicsContext svgWriter2D$GraphicsContext) {
        this.setDrawingAttributes(element, (SvgWriter2D$GraphicsContext)this.graphicsContexts.peek(), svgWriter2D$GraphicsContext);
    }

    private void setDrawingAttributes(Element element, SvgWriter2D$GraphicsContext object, SvgWriter2D$GraphicsContext object2) {
        Object object3;
        int n2;
        if (((SvgWriter2D$GraphicsContext)object2).background != null && !((SvgWriter2D$GraphicsContext)object2).background.equals(((SvgWriter2D$GraphicsContext)object).background)) {
            element.setAttribute("fill", this.toHexString(((SvgWriter2D$GraphicsContext)object2).background));
        }
        if (!((SvgWriter2D$GraphicsContext)object2).foreground.equals(((SvgWriter2D$GraphicsContext)object).foreground)) {
            element.setAttribute("stroke", this.toHexString(((SvgWriter2D$GraphicsContext)object2).foreground));
        }
        if ((n2 = ((SvgWriter2D$GraphicsContext)object2).foreground.getAlpha()) != ((SvgWriter2D$GraphicsContext)object).foreground.getAlpha()) {
            object3 = NumberFormat.getNumberInstance();
            ((NumberFormat)object3).setMaximumFractionDigits(3);
            element.setAttribute("opacity", ((NumberFormat)object3).format((double)n2 / 255.0));
        }
        if (((SvgWriter2D$GraphicsContext)object2).stroke != null && !((SvgWriter2D$GraphicsContext)object2).stroke.equals(((SvgWriter2D$GraphicsContext)object).stroke)) {
            object3 = ((SvgWriter2D$GraphicsContext)object2).stroke;
            if (object3 instanceof BasicStroke) {
                object = "";
                float[] fArray = ((BasicStroke)object3).getDashArray();
                object2 = fArray;
                if (fArray != null && ((Object)object2).length > 1) {
                    for (Object object4 : object2) {
                        object = (String)object + (float)object4 + ", ";
                    }
                    object = ((String)object).substring(0, ((String)object).length() - 2);
                    element.setAttribute("stroke-dasharray", (String)object);
                }
                element.setAttribute("stroke-width", "" + ((BasicStroke)object3).getLineWidth());
                return;
            }
            element.setAttribute("stroke-width", "1");
        }
    }

    public void beginFig(Fig fig) {
        this.beginFig(fig, null, null);
    }

    public void beginFig(Fig object, String string, String object2) {
        if (object2 != null) {
            this.createLink((String)object2);
        }
        object2 = this.svg.createElement("g");
        if (string != null) {
            object2.setAttribute("class", string);
        }
        object = new SvgWriter2D$GraphicsContext(this, ((Fig)object).getLineColor(), ((Fig)object).getFillColor(), ((Fig)object).getLineWidth());
        this.setDrawingAttributes((Element)object2, (SvgWriter2D$GraphicsContext)this.graphicsContexts.peek(), (SvgWriter2D$GraphicsContext)object);
        this.graphicsContexts.push((SvgWriter2D$GraphicsContext)object);
        this.elements.push((Element)object2);
    }

    private void createLink(String string) {
        Element element = this.svg.createElement("a");
        element.setAttribute("xlink:href", string);
        this.elements.push(element);
    }

    public void endFig() {
        this.popElement();
        this.popElement();
        this.graphicsContexts.pop();
    }

    private Element popElement() {
        Element element = this.elements.pop();
        Element element2 = (Element)this.elements.peek();
        if (element2 == null) {
            this.svg.appendChild(element);
        } else {
            element2.appendChild(element);
        }
        return element;
    }
}

